# Frequently Asked Questions (FAQ)

This is an example FAQ document for the Nexvor RAG system.
Customize this with your server's actual questions and answers!

## Getting Started

### How do I join the server?
1. Launch Minecraft (Java Edition)
2. Click "Multiplayer"
3. Add Server: `play.example.com`
4. Connect and enjoy!

**Supported Versions:** 1.17 - 1.21+

### Is this server cracked/premium?
This is a premium (official) Minecraft server. You need a legitimate Minecraft account to play.

### Do I need any mods or resource packs?
No mods are required! The server is fully vanilla-compatible. Optional resource packs may be available for enhanced visuals.

## Land Claims and Protection

### How do I claim land?
Use the `/claim` command while holding a golden shovel:
1. Right-click one corner with golden shovel
2. Right-click opposite corner
3. Your land is now protected!

**Free Claims:** All players get 5,000 claim blocks to start.

### How do I trust players on my claim?
- `/trust <player>` - Full build access
- `/containertrust <player>` - Access chests only
- `/accesstrust <player>` - Use buttons/levers only
- `/untrust <player>` - Remove all trust

### How do I get more claim blocks?
- Play time: 100 blocks per hour
- Vote for the server: 500 blocks per vote
- Purchase claim blocks: Check `/buy claims`

## Economy

### How do I earn money?
- Sell items at `/shop`
- Complete daily quests: `/quests`
- Participate in events
- Vote for the server: `/vote`
- Sell to other players at player shops

### What can I buy with money?
- Items at `/shop`
- Claim blocks
- Cosmetics and ranks
- Spawn eggs and rare items
- Teleportation services

### How do I check my balance?
Use `/balance` or `/bal` to see your current money.

## Teleportation

### How do I set a home?
- `/sethome <name>` - Set a home location
- `/home <name>` - Teleport to that home
- `/delhome <name>` - Delete a home

**Default homes:** 3 (more available with ranks)

### Can I teleport to other players?
- `/tpa <player>` - Request to teleport to someone
- `/tpahere <player>` - Request someone teleport to you
- `/tpaccept` - Accept a teleport request
- `/tpdeny` - Deny a teleport request

### How do I get back to spawn?
Use `/spawn` to return to the main spawn area at any time.

## Ranks and Permissions

### What ranks are available?
- **Member** (default) - Basic permissions
- **VIP** - Extra homes, colored chat, /hat command
- **VIP+** - More claim blocks, /ec (ender chest), /workbench
- **MVP** - Fly in claims, more perks, exclusive cosmetics

### How do I get a rank?
- Purchase at our webstore: `store.example.com`
- Win giveaways and events
- Special promotions

### Do ranks give unfair advantages?
No! All ranks are cosmetic or quality-of-life. No pay-to-win features.

## Server Features

### What game modes are available?
- **Survival** - Main survival world with economy
- **Creative** - Creative plots (apply for access)
- **Mini-games** - Parkour, PvP arena, events

### Are there custom enchantments?
Yes! Discover custom enchantments by:
- Fishing (rare catches)
- Voting rewards
- Special events
- `/enchanter` shop

### Is there a resource world?
Yes! `/warp resources` takes you to a monthly-reset mining world. Mine freely without affecting the main world.

## Community

### Where can I chat with players?
- **In-game chat** - Type normally
- **Discord** - Join at `discord.gg/example`
- **Forums** - Visit `forum.example.com`

### How do I report rule breakers?
1. In-game: `/report <player> <reason>`
2. Discord: Open a support ticket
3. Website: Submit a report form

### Can I create a town or faction?
Yes! Use `/town create <name>` to start your own town. Invite players, claim land together, and build a community!

## Technical Issues

### I'm experiencing lag, what should I do?
1. Check your internet connection
2. Close other programs using bandwidth
3. Try `/ping` to check your latency
4. Lower Minecraft video settings
5. Report persistent lag to staff

### I lost my items due to a bug!
1. Take screenshots if possible
2. Note the time and location
3. Contact staff via `/ticket` or Discord
4. Staff will investigate and restore items if valid

### Can I use shaders or OptiFine?
Yes! Client-side mods like OptiFine, shaders, and minimaps are allowed.

## Events and Updates

### When are events held?
- **Weekly events:** Saturday & Sunday at 3 PM EST
- **Monthly competitions:** First Saturday of each month
- **Seasonal events:** Special holiday events

Check `/events` in-game for schedule!

### How often does the server update?
- Plugin updates: Weekly
- Minecraft version updates: Within 1-2 weeks of release
- New features: Monthly

---

**Still have questions?**
- Ask in-game: Our community is friendly!
- Discord support: `discord.gg/example`
- Contact staff: `/ticket` or `/mail send <staff> <message>`

**Last Updated:** 2025-01-01
