# Server Commands Guide

This is an example commands reference for the Nexvor RAG system.
Update this with your server's actual commands!

## Essential Commands

### Basic Commands
- `/spawn` - Teleport to spawn
- `/help` - Show help menu
- `/rules` - Display server rules
- `/vote` - Get voting links and rewards
- `/discord` - Get Discord invite link

### Information Commands
- `/ping` - Check your connection latency
- `/tps` - Check server performance
- `/list` - See online players
- `/playtime` - Check your total playtime
- `/seen <player>` - Check when a player was last online

## Teleportation

### Home Commands
- `/sethome <name>` - Set a home location (max 3)
- `/home <name>` - Teleport to a home
- `/homes` - List all your homes
- `/delhome <name>` - Delete a home

### Player Teleport
- `/tpa <player>` - Request to teleport to a player
- `/tpahere <player>` - Request a player teleport to you
- `/tpaccept` - Accept teleport request
- `/tpdeny` - Deny teleport request
- `/tptoggle` - Disable all teleport requests

### Warps
- `/warp <name>` - Teleport to a server warp
- `/warps` - List all available warps
- `/warp spawn` - Alternative to /spawn
- `/warp resources` - Go to resource world
- `/warp shop` - Visit main shopping area

### Back Command
- `/back` - Return to your last death location (VIP+)

## Land Claims

### Claiming Land
- `/claim` - Create a claim (use golden shovel)
- `/abandonclaim` - Delete the claim you're standing in
- `/abandonallclaims` - Delete ALL your claims (careful!)
- `/claimlist` - List all your claims
- `/trust <player>` - Grant full access to your claim
- `/untrust <player>` - Remove a player's access

### Claim Information
- `/claiminfo` - Show info about claim you're in
- `/claimblocks` - Check your available claim blocks
- `/trapped` - Teleport out if stuck in a claim

### Advanced Trust
- `/containertrust <player>` - Allow chest access only
- `/accesstrust <player>` - Allow buttons/levers only
- `/permissiontrust <player>` - Allow managing trust (dangerous!)
- `/trustlist` - See who you trust

## Economy

### Money Commands
- `/balance` or `/bal` - Check your money
- `/baltop` - See richest players
- `/pay <player> <amount>` - Send money to a player
- `/worth` - Check value of item in hand

### Shopping
- `/shop` - Open server shop GUI
- `/shop sell` - Quick-sell items in inventory
- `/ah` or `/auction` - Player auction house
- `/ah sell <price>` - Sell item in your hand

## Social & Chat

### Messaging
- `/msg <player> <message>` - Private message
- `/r <message>` - Reply to last message
- `/ignore <player>` - Block messages from a player
- `/mail send <player> <message>` - Send offline mail
- `/mail read` - Read your mail

### Nexvor AI Commands
- `/nexvor chat <message>` or `/ai <message>` - Chat with AI
- `/nexvor forget` - Clear your AI conversation history
- `/nexvor privacy` - View/export/delete your AI data
- `/nexvor group create <name>` - Create AI group chat (Medium tier)
- `/nexvor events toggle <event>` - Toggle AI event notifications (Medium tier)
- `/nexvor bots list` - List available AI personalities (MAX tier)
- `/nexvor kb upload <file>` - Upload knowledge base document (MAX tier)

## Towns/Factions

### Town Basics
- `/town create <name>` - Create a new town
- `/town invite <player>` - Invite someone to your town
- `/town join <name>` - Accept town invitation
- `/town leave` - Leave your current town
- `/town spawn` - Teleport to town spawn

### Town Management
- `/town claim` - Claim chunk for your town
- `/town unclaim` - Unclaim current chunk
- `/town deposit <amount>` - Deposit money to town bank
- `/town rank add <player> <rank>` - Promote a member

### Town Information
- `/town` - Show your town info
- `/town list` - List all towns on server
- `/town online` - See online town members

## Player Shops

### Creating Shops
- `/chestshop create` - Create a chest shop
- `/chestshop remove` - Remove a chest shop
- `/chestshop price <amount>` - Set shop price

### Managing Shops
- `/shopinfo` - Get info about a shop
- `/shops` - List all your shops
- `/shopreport` - Report shop issues

## Utility Commands

### Item Management
- `/trash` - Open trash can GUI
- `/ec` or `/enderchest` - Open ender chest (VIP+)
- `/workbench` or `/wb` - Open crafting table (VIP+)
- `/anvil` - Open anvil remotely (MVP+)
- `/hat` - Wear item in hand as hat (VIP+)

### Player Management
- `/afk` - Mark yourself as AFK
- `/nick <name>` - Set a nickname (VIP+)
- `/realname <nick>` - Find real name from nickname

## Staff Commands (Moderator+)

### Moderation
- `/kick <player> <reason>` - Kick a player
- `/mute <player> <time> <reason>` - Mute a player
- `/warn <player> <reason>` - Warn a player
- `/history <player>` - Check punishment history

### Teleportation
- `/tp <player>` - Teleport to a player
- `/tp <player1> <player2>` - Teleport player1 to player2
- `/tphere <player>` - Teleport player to you

### World Management
- `/time set <day|night>` - Change time
- `/weather <clear|rain|thunder>` - Change weather
- `/gamemode <mode> <player>` - Change gamemode

## Admin Commands (Admin+)

### Server Management
- `/reload` - Reload server plugins (use carefully!)
- `/stop` - Stop the server gracefully
- `/whitelist add/remove <player>` - Manage whitelist
- `/ban <player> <reason>` - Ban a player permanently

### Advanced
- `/vanish` - Become invisible
- `/invsee <player>` - View player's inventory
- `/god` - Enable god mode
- `/fly` - Enable flight

## Tips & Tricks

### Command Shortcuts
- Most commands have short versions: `/tpa` = `/teleport ask`
- Tab-complete works for all commands and player names
- Use arrow keys to cycle through command history

### Useful Combos
1. **Fast travel setup:**
   - `/sethome base` at your base
   - `/sethome farm` at your farm
   - `/sethome shop` near shopping district

2. **Safety routine:**
   - Set a home before exploring
   - Use `/back` after death (VIP+)
   - Keep valuable items in ender chest

3. **Earning money fast:**
   - `/vote` daily for rewards
   - `/quests` for easy starter money
   - Sell excess resources at `/shop`

### Command Permissions

**Default (Member):**
- Basic teleportation, homes (3), claims, economy

**VIP Rank:**
- Extra homes (5), /ec, /wb, /nick, /hat

**VIP+ Rank:**
- More homes (10), /back, /fly in claims

**MVP Rank:**
- Unlimited homes, /anvil, more claim blocks

---

**Need help with a command?**
Type the command without arguments to see usage help!
Example: `/sethome` shows: "Usage: /sethome <name>"

**Still confused?**
Ask in chat or use `/ticket` to contact staff!

**Last Updated:** 2025-01-01
