# Python Installation Guide for Nexvor Vector Database

## Why Python?

Nexvor's Vector Database feature uses **FREE local embeddings** via ChromaDB and Sentence Transformers.
This saves you money (no API costs) compared to cloud embedding services.

**Benefits:**
- ✅ **FREE** - No ongoing API costs for embeddings
- ✅ **Local** - All data stays on your server
- ✅ **Fast** - No network latency
- ✅ **Private** - Your knowledge base never leaves your server

---

## Installation

### Windows

**1. Download Python 3.11+**
- Visit: https://www.python.org/downloads/
- Download Python 3.11 (or newer)
- **IMPORTANT:** Check "Add Python to PATH" during installation

**2. Verify Installation**
```cmd
python --version
```
Should show: `Python 3.11.x` or higher

**3. Restart Minecraft Server**
Nexvor will auto-detect Python and install dependencies

---

### Linux (Ubuntu/Debian)

**1. Install Python 3.11+**
```bash
sudo apt update
sudo apt install python3.11 python3.11-venv python3-pip
```

**2. Verify Installation**
```bash
python3 --version
```
Should show: `Python 3.11.x` or higher

**3. Restart Minecraft Server**
Nexvor will auto-detect Python and install dependencies

---

### Linux (CentOS/RHEL)

**1. Install Python 3.11+**
```bash
sudo yum install python311 python311-pip
```

**2. Verify Installation**
```bash
python3.11 --version
```

**3. Configure Nexvor**
Edit `config.yml`:
```yaml
vector_db:
  python:
    executable: "python3.11"  # Specify exact version
```

**4. Restart Minecraft Server**

---

### macOS

**1. Install Homebrew** (if not installed)
```bash
/bin/bash -c "$(curl -fsSL https://raw.githubusercontent.com/Homebrew/install/HEAD/install.sh)"
```

**2. Install Python 3.11+**
```bash
brew install python@3.11
```

**3. Verify Installation**
```bash
python3 --version
```

**4. Restart Minecraft Server**

---

## Troubleshooting

### "Python not found" Error

**Check if Python is installed:**
```bash
# Windows
where python

# Linux/macOS
which python3
```

**If not in PATH, specify manually in config.yml:**
```yaml
vector_db:
  python:
    executable: "C:\\Python311\\python.exe"  # Windows example
    # OR
    executable: "/usr/bin/python3.11"        # Linux example
```

---

### "pip install failed" Error

**Manually install dependencies:**
```bash
# Navigate to plugin directory
cd plugins/Nexvor/python

# Install dependencies
pip install -r requirements.txt

# OR with python3
python3 -m pip install -r requirements.txt
```

---

### Still Having Issues?

**Fallback to API Embeddings:**

Edit `config.yml`:
```yaml
vector_db:
  mode: "api"  # Use API instead of Python

  api:
    provider: "openai"  # or "groq", "anthropic"
    model: "text-embedding-3-small"
```

**Cost:** ~$0.01 per 1000 documents (very cheap)

---

## Verifying Installation

**When server starts, you should see:**
```
[Nexvor] Checking for Python installation...
[Nexvor] ✓ Python 3.11.5 found!
[Nexvor] Installing ChromaDB dependencies...
[Nexvor] ✓ ChromaDB initialized (FREE embeddings enabled)
[Nexvor] Vector Database ready!
```

**Test with command:**
```
/nexvor vectordb test
```

Should show: `✓ Vector database is working! (Python mode)`

---

## What Gets Installed?

**Python Packages:**
- `chromadb` - Vector database (~50MB)
- `sentence-transformers` - Embedding models (~100MB)
- `torch` - PyTorch (dependency, ~500MB)

**Total disk space:** ~650MB

**First install takes:** 2-5 minutes (downloading models)

---

## Support

- Discord: [Your Discord Server]
- Website: https://nexvor.dev
- Issues: https://github.com/yourrepo/nexvor/issues
