/*
 * Decompiled with CFR 0.152.
 */
package com.nexvor.vectordb.models;

import java.util.Map;

public class SearchResult {
    private String id;
    private String content;
    private double score;
    private Map<String, Object> metadata;

    public SearchResult(String id, String content, double score) {
        this.id = id;
        this.content = content;
        this.score = score;
    }

    public SearchResult(String id, String content, double score, Map<String, Object> metadata) {
        this.id = id;
        this.content = content;
        this.score = score;
        this.metadata = metadata;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public double getScore() {
        return this.score;
    }

    public void setScore(double score) {
        this.score = score;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
    }

    public double getSimilarityPercent() {
        return Math.max(0.0, Math.min(100.0, (1.0 - this.score) * 100.0));
    }

    public String toString() {
        return "SearchResult{id='" + this.id + "', score=" + String.format("%.4f", this.score) + ", similarity=" + String.format("%.1f%%", this.getSimilarityPercent()) + ", content='" + this.content.substring(0, Math.min(100, this.content.length())) + "...'}";
    }
}

