/*
 * Decompiled with CFR 0.152.
 */
package com.nexvor.vectordb;

import com.nexvor.Nexvor;
import com.nexvor.core.NexvorLogger;
import com.nexvor.vectordb.APIVectorDB;
import com.nexvor.vectordb.PythonVectorDB;
import com.nexvor.vectordb.VectorDBInterface;
import com.nexvor.vectordb.models.SearchResult;
import com.nexvor.vectordb.models.VectorDocument;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class VectorDBManager {
    private final Nexvor plugin;
    private final NexvorLogger logger;
    private final VectorDBInterface implementation;
    private final String mode;

    public VectorDBManager(Nexvor plugin) {
        this.plugin = plugin;
        this.logger = plugin.getNexvorLogger();
        String configMode = plugin.getConfig().getString("vector_db.mode", "auto");
        if (configMode.equals("api")) {
            this.implementation = new APIVectorDB(plugin);
            this.mode = "api";
            this.logger.info("Vector DB initialized in API mode");
        } else if (configMode.equals("python")) {
            if (PythonVectorDB.isPythonAvailable(plugin)) {
                this.implementation = new PythonVectorDB(plugin);
                this.mode = "python";
                this.logger.info("Vector DB initialized in Python mode (FREE embeddings)");
            } else {
                this.logger.warn("Python mode requested but Python not found! Falling back to API mode");
                this.implementation = new APIVectorDB(plugin);
                this.mode = "api";
            }
        } else if (PythonVectorDB.isPythonAvailable(plugin)) {
            this.implementation = new PythonVectorDB(plugin);
            this.mode = "python";
            this.logger.info("Vector DB auto-detected Python (FREE embeddings enabled!)");
        } else {
            this.logger.warn("Python not found, using API mode for embeddings");
            this.logger.warn("Install Python 3.8+ for FREE embeddings!");
            this.logger.warn("See: plugins/Nexvor/python/INSTALL_PYTHON.md");
            this.implementation = new APIVectorDB(plugin);
            this.mode = "api";
        }
    }

    public CompletableFuture<Boolean> initialize() {
        return this.implementation.initialize();
    }

    public CompletableFuture<Boolean> addDocuments(String collection, List<VectorDocument> documents) {
        return this.implementation.addDocuments(collection, documents);
    }

    public CompletableFuture<List<SearchResult>> search(String collection, String query, int limit) {
        return this.implementation.search(collection, query, limit);
    }

    public CompletableFuture<Boolean> deleteDocuments(String collection, List<String> ids) {
        return this.implementation.deleteDocuments(collection, ids);
    }

    public CompletableFuture<Integer> getCollectionSize(String collection) {
        return this.implementation.getCollectionSize(collection);
    }

    public CompletableFuture<Boolean> clearCollection(String collection) {
        return this.implementation.clearCollection(collection);
    }

    public CompletableFuture<Boolean> test() {
        return this.implementation.test();
    }

    public void shutdown() {
        this.implementation.shutdown();
    }

    public String getMode() {
        return this.mode;
    }

    public boolean isFree() {
        return this.mode.equals("python");
    }
}

