/*
 * Decompiled with CFR 0.152.
 */
package com.nexvor.updater;

public class UpdateResponse {
    private String latestVersion;
    private String downloadUrl;
    private String changelog;
    private boolean critical;
    private String minMinecraftVersion;

    public UpdateResponse() {
    }

    public UpdateResponse(String latestVersion, String downloadUrl, String changelog, boolean critical) {
        this.latestVersion = latestVersion;
        this.downloadUrl = downloadUrl;
        this.changelog = changelog;
        this.critical = critical;
    }

    public String getLatestVersion() {
        return this.latestVersion;
    }

    public void setLatestVersion(String latestVersion) {
        this.latestVersion = latestVersion;
    }

    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    public void setDownloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
    }

    public String getChangelog() {
        return this.changelog;
    }

    public void setChangelog(String changelog) {
        this.changelog = changelog;
    }

    public boolean isCritical() {
        return this.critical;
    }

    public void setCritical(boolean critical) {
        this.critical = critical;
    }

    public String getMinMinecraftVersion() {
        return this.minMinecraftVersion;
    }

    public void setMinMinecraftVersion(String minMinecraftVersion) {
        this.minMinecraftVersion = minMinecraftVersion;
    }

    public boolean isUpdateAvailable(String currentVersion) {
        if (this.latestVersion == null || currentVersion == null) {
            return false;
        }
        return this.compareVersions(this.latestVersion, currentVersion) > 0;
    }

    private int compareVersions(String v1, String v2) {
        String[] parts1 = v1.split("\\.");
        String[] parts2 = v2.split("\\.");
        int length = Math.max(parts1.length, parts2.length);
        for (int i = 0; i < length; ++i) {
            int num2;
            int num1 = i < parts1.length ? this.parseVersionPart(parts1[i]) : 0;
            int n = num2 = i < parts2.length ? this.parseVersionPart(parts2[i]) : 0;
            if (num1 == num2) continue;
            return num1 - num2;
        }
        return 0;
    }

    private int parseVersionPart(String part) {
        try {
            String numericPart = part.split("-")[0];
            return Integer.parseInt(numericPart);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }
}

