/*
 * Decompiled with CFR 0.152.
 */
package com.nexvor.ratelimit;

import com.nexvor.ratelimit.RateLimitReason;

public class RateLimitResult {
    private final boolean allowed;
    private final String message;
    private final RateLimitReason reason;
    private final long waitTimeSeconds;

    private RateLimitResult(boolean allowed, String message, RateLimitReason reason, long waitTimeSeconds) {
        this.allowed = allowed;
        this.message = message;
        this.reason = reason;
        this.waitTimeSeconds = waitTimeSeconds;
    }

    public static RateLimitResult allowed() {
        return new RateLimitResult(true, null, null, 0L);
    }

    public static RateLimitResult denied(String message, RateLimitReason reason) {
        return new RateLimitResult(false, message, reason, 0L);
    }

    public static RateLimitResult denied(String message, RateLimitReason reason, long waitTimeSeconds) {
        return new RateLimitResult(false, message, reason, waitTimeSeconds);
    }

    public boolean isAllowed() {
        return this.allowed;
    }

    public String getMessage() {
        return this.message;
    }

    public RateLimitReason getReason() {
        return this.reason;
    }

    public long getWaitTimeSeconds() {
        return this.waitTimeSeconds;
    }

    public String toString() {
        if (this.allowed) {
            return "RateLimitResult{allowed=true}";
        }
        return "RateLimitResult{allowed=false, reason=" + String.valueOf((Object)this.reason) + ", message='" + this.message + "'}";
    }
}

