/*
 * Decompiled with CFR 0.152.
 */
package com.nexvor.rag.models;

import java.util.HashMap;
import java.util.Map;

public class DocumentChunk {
    private String id;
    private String kbId;
    private String sourceFile;
    private int chunkIndex;
    private String content;
    private Map<String, Object> metadata;
    private long createdAt;

    public DocumentChunk(String id, String kbId, String sourceFile, int chunkIndex, String content) {
        this.id = id;
        this.kbId = kbId;
        this.sourceFile = sourceFile;
        this.chunkIndex = chunkIndex;
        this.content = content;
        this.metadata = new HashMap<String, Object>();
        this.createdAt = System.currentTimeMillis();
        this.metadata.put("kb_id", kbId);
        this.metadata.put("source_file", sourceFile);
        this.metadata.put("chunk_index", chunkIndex);
        this.metadata.put("created_at", this.createdAt);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getKbId() {
        return this.kbId;
    }

    public void setKbId(String kbId) {
        this.kbId = kbId;
    }

    public String getSourceFile() {
        return this.sourceFile;
    }

    public void setSourceFile(String sourceFile) {
        this.sourceFile = sourceFile;
    }

    public int getChunkIndex() {
        return this.chunkIndex;
    }

    public void setChunkIndex(int chunkIndex) {
        this.chunkIndex = chunkIndex;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
    }

    public void addMetadata(String key, Object value) {
        this.metadata.put(key, value);
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(long createdAt) {
        this.createdAt = createdAt;
    }

    public String getPreview() {
        if (this.content == null) {
            return "";
        }
        return this.content.length() > 100 ? this.content.substring(0, 100) + "..." : this.content;
    }

    public String toString() {
        return "DocumentChunk{id='" + this.id + "', kbId='" + this.kbId + "', sourceFile='" + this.sourceFile + "', chunkIndex=" + this.chunkIndex + ", preview='" + this.getPreview() + "', createdAt=" + this.createdAt + "}";
    }
}

