/*
 * Decompiled with CFR 0.152.
 */
package com.nexvor.rag;

import com.nexvor.Nexvor;
import com.nexvor.core.NexvorLogger;
import com.nexvor.vectordb.VectorDBManager;
import com.nexvor.vectordb.models.SearchResult;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class RAGSearcher {
    private final Nexvor plugin;
    private final NexvorLogger logger;
    private final VectorDBManager vectorDBManager;
    private final boolean enabled;
    private final List<String> collections;
    private final int maxResults;
    private final double minSimilarity;
    private final int maxContextLength;

    public RAGSearcher(Nexvor plugin) {
        this.plugin = plugin;
        this.logger = plugin.getNexvorLogger();
        this.vectorDBManager = plugin.getVectorDBManager();
        this.enabled = plugin.getConfig().getBoolean("rag.search.enabled", true);
        this.collections = plugin.getConfig().getStringList("rag.search.collections");
        this.maxResults = plugin.getConfig().getInt("rag.search.max_results", 3);
        this.minSimilarity = plugin.getConfig().getDouble("rag.search.min_similarity", 0.7);
        this.maxContextLength = plugin.getConfig().getInt("rag.search.max_context_length", 2000);
        this.logger.info("RAG searcher initialized (enabled: " + this.enabled + ", max results: " + this.maxResults + ")");
    }

    public CompletableFuture<String> searchContext(String query) {
        if (!this.enabled || this.vectorDBManager == null) {
            return CompletableFuture.completedFuture("");
        }
        return CompletableFuture.supplyAsync(() -> {
            try {
                ArrayList<SearchResult> allResults = new ArrayList<SearchResult>();
                for (String string : this.collections) {
                    List<SearchResult> results = this.vectorDBManager.search(string, query, this.maxResults).join();
                    if (results == null) continue;
                    allResults.addAll(results);
                }
                if (allResults.isEmpty()) {
                    this.logger.debug("No RAG context found for query: " + query);
                    return "";
                }
                List<SearchResult> filteredResults = new ArrayList<SearchResult>();
                for (SearchResult result : allResults) {
                    if (!(result.getSimilarityPercent() >= this.minSimilarity * 100.0)) continue;
                    filteredResults.add(result);
                }
                if (filteredResults.isEmpty()) {
                    this.logger.debug("No RAG results met similarity threshold (" + this.minSimilarity * 100.0 + "%)");
                    return "";
                }
                filteredResults.sort((a, b) -> Double.compare(b.getScore(), a.getScore()));
                if (filteredResults.size() > this.maxResults) {
                    filteredResults = filteredResults.subList(0, this.maxResults);
                }
                String string = this.buildContextString(filteredResults);
                this.logger.debug("Found " + filteredResults.size() + " RAG results for query: " + query);
                return string;
            }
            catch (Exception e) {
                this.logger.error("Error searching RAG context", e);
                return "";
            }
        });
    }

    private String buildContextString(List<SearchResult> results) {
        StringBuilder context = new StringBuilder();
        context.append("RELEVANT KNOWLEDGE BASE CONTEXT:\n\n");
        for (int i = 0; i < results.size(); ++i) {
            SearchResult result = results.get(i);
            String sourceFile = (String)result.getMetadata().getOrDefault("source_file", "unknown");
            context.append("[Source: ").append(sourceFile).append("]\n");
            context.append(result.getContent()).append("\n\n");
        }
        context.append("END OF KNOWLEDGE BASE CONTEXT\n\n");
        Object contextStr = context.toString();
        if (((String)contextStr).length() > this.maxContextLength) {
            contextStr = ((String)contextStr).substring(0, this.maxContextLength) + "\n[Context truncated...]";
        }
        return contextStr;
    }

    public String injectContext(String originalPrompt, String ragContext) {
        if (ragContext == null || ragContext.isEmpty()) {
            return originalPrompt;
        }
        StringBuilder enhanced = new StringBuilder();
        enhanced.append("IMPORTANT: You have access to the server's knowledge base. ");
        enhanced.append("Use the context below to answer questions accurately. ");
        enhanced.append("If the context doesn't contain relevant information, answer based on your general knowledge.\n\n");
        enhanced.append(ragContext);
        enhanced.append("---\n\n");
        enhanced.append(originalPrompt);
        return enhanced.toString();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public List<String> getCollections() {
        return new ArrayList<String>(this.collections);
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public double getMinSimilarity() {
        return this.minSimilarity;
    }
}

