/*
 * Decompiled with CFR 0.152.
 */
package com.nexvor.memory;

import com.nexvor.Nexvor;
import com.nexvor.ai.models.ChatMessage;
import com.nexvor.memory.DatabaseManager;
import com.nexvor.memory.ProximityGroup;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class ProximityChatManager {
    private final Nexvor plugin;
    private final DatabaseManager databaseManager;
    private final Map<String, ProximityGroup> activeGroups;
    private final Map<UUID, String> playerToGroup;
    private final double proximityRadius;
    private final boolean autoManage;
    private final int minPlayers;
    private final boolean includePlayerNames;

    public ProximityChatManager(Nexvor plugin, DatabaseManager databaseManager) {
        this.plugin = plugin;
        this.databaseManager = databaseManager;
        this.activeGroups = new ConcurrentHashMap<String, ProximityGroup>();
        this.playerToGroup = new ConcurrentHashMap<UUID, String>();
        this.proximityRadius = plugin.getConfigManager().getProximityChatRadius();
        this.autoManage = plugin.getConfigManager().isProximityChatAutoManage();
        this.minPlayers = plugin.getConfigManager().getProximityChatMinPlayers();
        this.includePlayerNames = plugin.getConfigManager().isProximityChatIncludePlayerNames();
    }

    public void startUpdateTask() {
        if (!this.autoManage) {
            return;
        }
        int updateInterval = this.plugin.getConfigManager().getProximityChatUpdateInterval();
        this.plugin.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, () -> this.updateProximityGroups(), (long)updateInterval, (long)updateInterval);
        this.plugin.getNexvorLogger().info("Proximity chat update task started (interval: " + updateInterval + " ticks)");
    }

    private void updateProximityGroups() {
        Collection onlinePlayers = Bukkit.getOnlinePlayers();
        HashMap<UUID, Set<UUID>> nearbyPlayers = new HashMap<UUID, Set<UUID>>();
        for (Player player1 : onlinePlayers) {
            HashSet<UUID> nearby = new HashSet<UUID>();
            nearby.add(player1.getUniqueId());
            for (Player player2 : onlinePlayers) {
                Location loc2;
                Location loc1;
                if (player1.equals((Object)player2) || !player1.getWorld().equals((Object)player2.getWorld()) || !((loc1 = player1.getLocation()).distance(loc2 = player2.getLocation()) <= this.proximityRadius)) continue;
                nearby.add(player2.getUniqueId());
            }
            if (nearby.size() < this.minPlayers) continue;
            nearbyPlayers.put(player1.getUniqueId(), nearby);
        }
        this.updateGroups(nearbyPlayers);
    }

    private void updateGroups(Map<UUID, Set<UUID>> nearbyPlayers) {
        HashSet playersInGroups = new HashSet();
        nearbyPlayers.values().forEach(playersInGroups::addAll);
        this.playerToGroup.keySet().removeIf(uuid -> !playersInGroups.contains(uuid));
        HashSet<Set<UUID>> processedClusters = new HashSet<Set<UUID>>();
        for (Set<UUID> cluster : nearbyPlayers.values()) {
            if (processedClusters.contains(cluster)) continue;
            processedClusters.add(cluster);
            String groupId = this.findOrCreateGroupForCluster(cluster);
            for (UUID uuid2 : cluster) {
                this.playerToGroup.put(uuid2, groupId);
            }
        }
        this.activeGroups.values().removeIf(group -> {
            if (group.isEmpty() || group.getMemberCount() < this.minPlayers) {
                this.plugin.getNexvorLogger().debug("Dissolved proximity group: " + group.getGroupId());
                return true;
            }
            return false;
        });
    }

    private String findOrCreateGroupForCluster(Set<UUID> cluster) {
        for (ProximityGroup group : this.activeGroups.values()) {
            Set<UUID> groupMembers = group.getMembers();
            if (!groupMembers.containsAll(cluster) && !cluster.containsAll(groupMembers)) continue;
            for (UUID uuid2 : cluster) {
                group.addMember(uuid2);
            }
            groupMembers.stream().filter(uuid -> !cluster.contains(uuid)).forEach(group::removeMember);
            group.updateActivity();
            return group.getGroupId();
        }
        String groupId = "proximity-" + UUID.randomUUID().toString().substring(0, 8);
        ProximityGroup newGroup = new ProximityGroup(groupId);
        cluster.forEach(newGroup::addMember);
        this.activeGroups.put(groupId, newGroup);
        this.plugin.getNexvorLogger().debug("Created proximity group: " + groupId + " with " + cluster.size() + " members");
        return groupId;
    }

    public String getPlayerGroup(UUID playerUuid) {
        return this.playerToGroup.get(playerUuid);
    }

    public ProximityGroup getGroup(String groupId) {
        return this.activeGroups.get(groupId);
    }

    public boolean savePlayerMessage(UUID playerUuid, String playerName, String message) {
        String groupId = this.getPlayerGroup(playerUuid);
        if (groupId == null) {
            return false;
        }
        String content = this.includePlayerNames ? "[" + playerName + "] " + message : message;
        this.saveMessage(groupId, playerUuid, "user", content);
        return true;
    }

    public void saveAIResponse(String groupId, String response) {
        this.saveMessage(groupId, null, "assistant", response);
    }

    private void saveMessage(String groupId, UUID playerUuid, String role, String content) {
        String insert = "INSERT INTO proximity_messages (group_id, player_uuid, role, content, timestamp) VALUES (?, ?, ?, ?, ?)";
        try (Connection conn = this.databaseManager.getConnection();
             PreparedStatement stmt = conn.prepareStatement(insert);){
            stmt.setString(1, groupId);
            stmt.setString(2, playerUuid != null ? playerUuid.toString() : null);
            stmt.setString(3, role);
            stmt.setString(4, content);
            stmt.setLong(5, System.currentTimeMillis());
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.getNexvorLogger().error("Failed to save proximity message", e);
        }
    }

    public List<ChatMessage> getGroupContext(String groupId, int maxMessages) {
        ArrayList<ChatMessage> messages = new ArrayList<ChatMessage>();
        String query = "SELECT role, content FROM proximity_messages\nWHERE group_id = ?\nORDER BY timestamp DESC\nLIMIT ?\n";
        try (Connection conn = this.databaseManager.getConnection();
             PreparedStatement stmt = conn.prepareStatement(query);){
            stmt.setString(1, groupId);
            stmt.setInt(2, maxMessages);
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                messages.add(new ChatMessage(rs.getString("role"), rs.getString("content")));
            }
            Collections.reverse(messages);
        }
        catch (SQLException e) {
            this.plugin.getNexvorLogger().error("Failed to get proximity context", e);
        }
        return messages;
    }

    public int getActiveGroupCount() {
        return this.activeGroups.size();
    }

    public void clearAllHistory() {
        String delete = "DELETE FROM proximity_messages";
        try (Connection conn = this.databaseManager.getConnection();
             Statement stmt = conn.createStatement();){
            int rows = stmt.executeUpdate(delete);
            this.plugin.getNexvorLogger().info("Cleared " + rows + " proximity messages");
        }
        catch (SQLException e) {
            this.plugin.getNexvorLogger().error("Failed to clear proximity history", e);
        }
    }
}

