/*
 * Decompiled with CFR 0.152.
 */
package com.nexvor.memory;

import com.nexvor.Nexvor;
import com.nexvor.ai.models.ChatMessage;
import com.nexvor.core.NexvorLogger;
import com.nexvor.memory.ConversationManager;
import com.nexvor.memory.DatabaseManager;
import com.nexvor.memory.models.Conversation;
import com.nexvor.utils.TokenEstimator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;

public class DiscordConversationManager {
    private final Nexvor plugin;
    private final DatabaseManager databaseManager;
    private final ConversationManager conversationManager;
    private final NexvorLogger logger;
    private final int maxContextTokens;
    private final int maxMessages;

    public DiscordConversationManager(Nexvor plugin) {
        this.plugin = plugin;
        this.databaseManager = plugin.getDatabaseManager();
        this.conversationManager = plugin.getConversationManager();
        this.logger = plugin.getNexvorLogger();
        this.maxContextTokens = plugin.getConfig().getInt("memory.max_context_tokens", 2048);
        this.maxMessages = plugin.getConfig().getInt("memory.max_messages", 50);
    }

    public List<ChatMessage> getConversationContext(String discordUserId) {
        boolean syncEnabled = this.plugin.getConfig().getBoolean("discord.discordsrv.sync_context.enabled", true);
        boolean allowUnlinked = this.plugin.getConfig().getBoolean("discord.discordsrv.sync_context.allow_unlinked_users", true);
        UUID minecraftUuid = this.databaseManager.getLinkedMinecraftAccount(discordUserId);
        if (minecraftUuid != null && syncEnabled) {
            return this.getMergedContext(discordUserId, minecraftUuid);
        }
        if (!allowUnlinked && minecraftUuid == null) {
            this.logger.debug("Discord user " + discordUserId + " not linked and linking is required");
            return new ArrayList<ChatMessage>();
        }
        return this.getDiscordOnlyContext(discordUserId);
    }

    private List<ChatMessage> getDiscordOnlyContext(String discordUserId) {
        List<Conversation> history = this.databaseManager.getDiscordConversationHistory(discordUserId, this.maxMessages);
        return this.applyTokenLimit(history);
    }

    private List<ChatMessage> getMergedContext(String discordUserId, UUID minecraftUuid) {
        List<Conversation> discordHistory = this.databaseManager.getDiscordConversationHistory(discordUserId, this.maxMessages);
        List<Conversation> minecraftHistory = this.databaseManager.getConversationHistory(minecraftUuid, this.maxMessages);
        ArrayList<Conversation> merged = new ArrayList<Conversation>();
        merged.addAll(discordHistory);
        merged.addAll(minecraftHistory);
        merged.sort(Comparator.comparingLong(Conversation::getTimestamp));
        return this.applyTokenLimit(merged);
    }

    private List<ChatMessage> applyTokenLimit(List<Conversation> conversations) {
        Conversation conv;
        int msgTokens;
        ArrayList<ChatMessage> result = new ArrayList<ChatMessage>();
        int totalTokens = 0;
        for (int i = conversations.size() - 1; i >= 0 && totalTokens + (msgTokens = TokenEstimator.estimateTokens((conv = conversations.get(i)).getContent())) <= this.maxContextTokens; --i) {
            ChatMessage msg = conv.getRole().equals("user") ? ChatMessage.user(conv.getContent()) : ChatMessage.assistant(conv.getContent());
            result.add(0, msg);
            totalTokens += msgTokens;
        }
        this.logger.debug("Discord context: " + result.size() + " messages, ~" + totalTokens + " tokens");
        return result;
    }

    public void saveUserMessage(String discordUserId, String message) {
        this.databaseManager.saveDiscordMessage(discordUserId, "user", message);
    }

    public void saveAssistantMessage(String discordUserId, String response) {
        this.databaseManager.saveDiscordMessage(discordUserId, "assistant", response);
    }

    public void deleteConversationHistory(String discordUserId) {
        this.databaseManager.deleteDiscordConversationHistory(discordUserId);
        this.logger.info("Deleted Discord conversation history for user: " + discordUserId);
    }

    public int getMessageCount(String discordUserId) {
        return this.databaseManager.getDiscordMessageCount(discordUserId);
    }

    public boolean isLinked(String discordUserId) {
        return this.databaseManager.getLinkedMinecraftAccount(discordUserId) != null;
    }

    public UUID getLinkedMinecraftAccount(String discordUserId) {
        return this.databaseManager.getLinkedMinecraftAccount(discordUserId);
    }

    public void linkAccount(UUID minecraftUuid, String discordUserId) {
        this.databaseManager.linkDiscordAccount(minecraftUuid, discordUserId);
        this.logger.info("Linked Discord " + discordUserId + " to Minecraft " + String.valueOf(minecraftUuid));
    }

    public void unlinkAccount(UUID minecraftUuid) {
        this.databaseManager.unlinkDiscordAccount(minecraftUuid);
        this.logger.info("Unlinked Discord account for Minecraft " + String.valueOf(minecraftUuid));
    }
}

