/*
 * Decompiled with CFR 0.152.
 */
package com.nexvor.listeners;

import com.nexvor.Nexvor;
import com.nexvor.ai.ProviderManager;
import com.nexvor.ai.models.ChatMessage;
import com.nexvor.ai.models.ChatRequest;
import com.nexvor.filter.FilterResult;
import com.nexvor.filter.LanguageFilter;
import com.nexvor.memory.ConversationManager;
import com.nexvor.ratelimit.RateLimitManager;
import com.nexvor.ratelimit.RateLimitResult;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.plugin.Plugin;

public class MentionChatListener
implements Listener {
    private final Nexvor plugin;
    private Pattern mentionPattern;

    public MentionChatListener(Nexvor plugin) {
        this.plugin = plugin;
        this.updateMentionPattern();
    }

    public void updateMentionPattern() {
        String botName = this.plugin.getConfigManager().getBotName().toLowerCase();
        this.mentionPattern = Pattern.compile("(?i)(^|\\s|@)" + Pattern.quote(botName) + "($|[\\s,!?.:;])", 2);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        if (!this.plugin.getConfigManager().isBotEnabled()) {
            return;
        }
        if (!this.plugin.getConfigManager().isMentionTriggerEnabled()) {
            return;
        }
        Player player = event.getPlayer();
        String message = event.getMessage();
        if (!this.mentionPattern.matcher(message).find()) {
            return;
        }
        String cleanMessage = this.extractMessage(message);
        if (cleanMessage.isEmpty()) {
            return;
        }
        this.processAIRequest(player, cleanMessage);
    }

    private String extractMessage(String message) {
        String botName = this.plugin.getConfigManager().getBotName();
        String cleaned = message.replaceFirst("(?i)^@?" + Pattern.quote(botName) + "[,:]?\\s*", "").replaceFirst("(?i)\\s*@?" + Pattern.quote(botName) + "[,!?.:;]*\\s*", " ").replaceFirst("(?i)^(hey|hi|hello|yo)\\s+@?" + Pattern.quote(botName) + "[,:]?\\s*", "").trim();
        return cleaned;
    }

    private void processAIRequest(Player player, String message) {
        FilterResult filterResult;
        RateLimitResult rateLimitResult;
        UUID playerUuid = player.getUniqueId();
        String playerName = player.getName();
        String botName = this.plugin.getConfigManager().getBotName();
        String prefix = this.plugin.getConfigManager().getPrefix();
        ProviderManager providerManager = this.plugin.getProviderManager();
        if (providerManager == null || !providerManager.hasProvider()) {
            return;
        }
        ConversationManager conversationManager = this.plugin.getConversationManager();
        if (conversationManager == null) {
            return;
        }
        RateLimitManager rateLimitManager = this.plugin.getRateLimitManager();
        if (rateLimitManager != null && !(rateLimitResult = rateLimitManager.checkAllowed(player)).isAllowed()) {
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> player.sendMessage(prefix + " " + rateLimitResult.getMessage()));
            return;
        }
        if (conversationManager.isOptedOut(playerUuid)) {
            return;
        }
        LanguageFilter languageFilter = this.plugin.getLanguageFilter();
        if (languageFilter != null && languageFilter.isEnabled() && !(filterResult = languageFilter.check(message)).isAllowed()) {
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> player.sendMessage(prefix + " \u00a7cYour message contains inappropriate language."));
            return;
        }
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> player.sendMessage(prefix + " \u00a77" + botName + " is thinking..."));
        List<ChatMessage> conversationHistory = conversationManager.getConversationContext(playerUuid, playerName);
        ChatRequest.Builder requestBuilder = ChatRequest.builder().model(providerManager.getPrimaryProvider().getDefaultModel()).addSystemMessage(this.plugin.getConfigManager().getSystemPrompt()).temperature(0.7).maxTokens(500);
        for (ChatMessage historyMessage : conversationHistory) {
            if (historyMessage.getRole().equals("user")) {
                requestBuilder.addUserMessage(historyMessage.getContent());
                continue;
            }
            if (!historyMessage.getRole().equals("assistant")) continue;
            requestBuilder.addAssistantMessage(historyMessage.getContent());
        }
        requestBuilder.addUserMessage(message);
        ChatRequest request = requestBuilder.build();
        conversationManager.saveUserMessage(playerUuid, playerName, message);
        ((CompletableFuture)providerManager.sendRequest(request).thenAccept(response -> Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            if (!response.isSuccess()) {
                player.sendMessage(prefix + " \u00a7cFailed to get response: " + response.getErrorMessage());
                return;
            }
            String aiResponse = response.getContent();
            conversationManager.saveAssistantMessage(playerUuid, playerName, aiResponse);
            if (rateLimitManager != null) {
                rateLimitManager.recordRequest(player);
            }
            if (this.plugin.getConfigManager().isPublicResponses()) {
                String publicMessage = prefix + " \u00a7f" + aiResponse;
                Bukkit.broadcastMessage((String)publicMessage);
                this.plugin.getLogger().info("[" + botName + "] " + playerName + " asked: " + message);
                this.plugin.getLogger().info("[" + botName + "] Response: " + aiResponse);
            } else {
                player.sendMessage(prefix + " \u00a7f" + aiResponse);
            }
        }))).exceptionally(throwable -> {
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                player.sendMessage(prefix + " \u00a7cAn error occurred while contacting the AI.");
                this.plugin.getNexvorLogger().error("Chat exception for " + playerName, (Throwable)throwable);
            });
            return null;
        });
    }
}

