/*
 * Decompiled with CFR 0.152.
 */
package com.nexvor.listeners;

import com.nexvor.Nexvor;
import com.nexvor.ai.models.ChatMessage;
import com.nexvor.ai.models.ChatRequest;
import com.nexvor.core.PluginTier;
import com.nexvor.events.EventType;
import com.nexvor.memory.GroupConversation;
import com.nexvor.memory.ProximityGroup;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerAdvancementDoneEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerLevelChangeEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.raid.RaidFinishEvent;
import org.bukkit.event.raid.RaidTriggerEvent;
import org.bukkit.plugin.Plugin;

public class EventAwarenessListener
implements Listener {
    private final Nexvor plugin;
    private final Map<EventType, Long> lastEventTrigger = new ConcurrentHashMap<EventType, Long>();
    private final Map<String, Long> playerEventCooldown = new ConcurrentHashMap<String, Long>();
    private static final long PLAYER_EVENT_COOLDOWN_MS = 10000L;
    private static final Set<Material> RARE_MATERIALS = Set.of(Material.DIAMOND_ORE, Material.DEEPSLATE_DIAMOND_ORE, Material.ANCIENT_DEBRIS, Material.EMERALD_ORE, Material.DEEPSLATE_EMERALD_ORE);
    private static final Set<EntityType> BOSS_TYPES = Set.of(EntityType.ENDER_DRAGON, EntityType.WITHER);

    public EventAwarenessListener(Nexvor plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerDeath(PlayerDeathEvent event) {
        Player player = event.getEntity();
        if (!this.shouldProcessEvent(EventType.PLAYER_DEATH, player)) {
            return;
        }
        Object deathMessage = event.getDeathMessage();
        if (deathMessage == null) {
            deathMessage = player.getName() + " died";
        }
        String context = this.buildEventContext(EventType.PLAYER_DEATH, player, "Death Message: " + (String)deathMessage);
        this.triggerAIResponse(EventType.PLAYER_DEATH, player, context);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerAdvancement(PlayerAdvancementDoneEvent event) {
        EventType eventType;
        Player player = event.getPlayer();
        EventType eventType2 = eventType = this.isEventEnabled("player_achievement") ? EventType.PLAYER_ACHIEVEMENT : EventType.PLAYER_ADVANCEMENT;
        if (!this.shouldProcessEvent(eventType, player)) {
            return;
        }
        String advancementKey = event.getAdvancement().getKey().getKey();
        String advancementName = this.formatAdvancementName(advancementKey);
        String context = this.buildEventContext(eventType, player, "Achievement: " + advancementName + "\nKey: " + advancementKey);
        this.triggerAIResponse(eventType, player, context);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerLevelChange(PlayerLevelChangeEvent event) {
        int oldLevel;
        Player player = event.getPlayer();
        int newLevel = event.getNewLevel();
        if (newLevel <= (oldLevel = event.getOldLevel()) || newLevel % 5 != 0) {
            return;
        }
        if (!this.shouldProcessEvent(EventType.PLAYER_LEVEL_UP, player)) {
            return;
        }
        String context = this.buildEventContext(EventType.PLAYER_LEVEL_UP, player, "New Level: " + newLevel + "\nPrevious Level: " + oldLevel);
        this.triggerAIResponse(EventType.PLAYER_LEVEL_UP, player, context);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerJoin(PlayerJoinEvent event) {
        EventType eventType;
        Player player = event.getPlayer();
        boolean isFirstJoin = !player.hasPlayedBefore();
        EventType eventType2 = eventType = isFirstJoin ? EventType.PLAYER_FIRST_JOIN : EventType.PLAYER_JOIN;
        if (!this.shouldProcessEvent(eventType, player)) {
            return;
        }
        String context = this.buildEventContext(eventType, player, isFirstJoin ? "First time joining the server!" : "Rejoined the server");
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.triggerAIResponse(eventType, player, context), 40L);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        if (!this.shouldProcessEvent(EventType.PLAYER_QUIT, player)) {
            return;
        }
        String context = this.buildEventContext(EventType.PLAYER_QUIT, player, "Player has left the server");
        this.triggerAIResponse(EventType.PLAYER_QUIT, player, context);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player victim = (Player)entity;
        if (victim.getHealth() - event.getFinalDamage() > 0.0) {
            return;
        }
        Player killer = null;
        if (event.getDamager() instanceof Player) {
            killer = (Player)event.getDamager();
        } else {
            Projectile projectile;
            Entity entity2 = event.getDamager();
            if (entity2 instanceof Projectile && (projectile = (Projectile)entity2).getShooter() instanceof Player) {
                killer = (Player)projectile.getShooter();
            }
        }
        if (killer == null) {
            return;
        }
        if (!this.shouldProcessEvent(EventType.PLAYER_KILL_PLAYER, killer)) {
            return;
        }
        String context = this.buildEventContext(EventType.PLAYER_KILL_PLAYER, killer, "Victim: " + victim.getName() + "\nWeapon: " + String.valueOf(killer.getInventory().getItemInMainHand().getType()));
        this.triggerAIResponse(EventType.PLAYER_KILL_PLAYER, killer, context);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEntityDeath(EntityDeathEvent event) {
        LivingEntity entity = event.getEntity();
        Player killer = entity.getKiller();
        if (killer == null) {
            return;
        }
        if (BOSS_TYPES.contains(entity.getType())) {
            if (!this.shouldProcessEvent(EventType.BOSS_KILLED, killer)) {
                return;
            }
            String context = this.buildEventContext(EventType.BOSS_KILLED, killer, "Boss Type: " + entity.getType().name() + "\nLocation: " + this.formatLocation(entity.getLocation()));
            this.triggerAIResponse(EventType.BOSS_KILLED, killer, context);
            return;
        }
        if (!this.shouldProcessEvent(EventType.PLAYER_KILL_ENTITY, killer)) {
            return;
        }
        String context = this.buildEventContext(EventType.PLAYER_KILL_ENTITY, killer, "Entity Type: " + entity.getType().name());
        this.triggerAIResponse(EventType.PLAYER_KILL_ENTITY, killer, context);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerFish(PlayerFishEvent event) {
        if (event.getState() != PlayerFishEvent.State.CAUGHT_FISH) {
            return;
        }
        Player player = event.getPlayer();
        if (!this.shouldProcessEvent(EventType.FISHING_RARE_CATCH, player)) {
            return;
        }
        Entity entity = event.getCaught();
        if (entity instanceof Item) {
            boolean isTreasure;
            Item item = (Item)entity;
            Material caughtType = item.getItemStack().getType();
            boolean bl = isTreasure = caughtType == Material.BOW || caughtType == Material.ENCHANTED_BOOK || caughtType == Material.NAME_TAG || caughtType == Material.NAUTILUS_SHELL || caughtType == Material.SADDLE;
            if (!isTreasure) {
                return;
            }
            String context = this.buildEventContext(EventType.FISHING_RARE_CATCH, player, "Caught: " + caughtType.name());
            this.triggerAIResponse(EventType.FISHING_RARE_CATCH, player, context);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onRaidTrigger(RaidTriggerEvent event) {
        Player player = event.getPlayer();
        if (!this.shouldProcessEvent(EventType.RAID_TRIGGERED, player)) {
            return;
        }
        String context = this.buildEventContext(EventType.RAID_TRIGGERED, player, "Raid Location: " + this.formatLocation(event.getRaid().getLocation()));
        this.triggerAIResponse(EventType.RAID_TRIGGERED, player, context);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onRaidFinish(RaidFinishEvent event) {
        event.getWinners().forEach(player -> {
            if (!this.shouldProcessEvent(EventType.RAID_COMPLETED, (Player)player)) {
                return;
            }
            String context = this.buildEventContext(EventType.RAID_COMPLETED, (Player)player, "Raid Status: " + (event.getWinners().contains(player) ? "Victory!" : "Completed"));
            this.triggerAIResponse(EventType.RAID_COMPLETED, (Player)player, context);
        });
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onCreatureSpawn(CreatureSpawnEvent event) {
        if (!BOSS_TYPES.contains(event.getEntityType())) {
            return;
        }
        event.getEntity().getNearbyEntities(50.0, 50.0, 50.0).stream().filter(entity -> entity instanceof Player).map(entity -> (Player)entity).forEach(player -> {
            if (!this.shouldProcessEvent(EventType.BOSS_SPAWNED, (Player)player)) {
                return;
            }
            String context = this.buildEventContext(EventType.BOSS_SPAWNED, (Player)player, "Boss Type: " + event.getEntityType().name() + "\nSpawn Reason: " + event.getSpawnReason().name() + "\nLocation: " + this.formatLocation(event.getLocation()));
            this.triggerAIResponse(EventType.BOSS_SPAWNED, (Player)player, context);
        });
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        if (!RARE_MATERIALS.contains(event.getBlock().getType())) {
            return;
        }
        Player player = event.getPlayer();
        if (!this.shouldProcessEvent(EventType.BLOCK_BREAK_RARE, player)) {
            return;
        }
        String context = this.buildEventContext(EventType.BLOCK_BREAK_RARE, player, "Block Type: " + event.getBlock().getType().name() + "\nLocation: " + this.formatLocation(event.getBlock().getLocation()));
        this.triggerAIResponse(EventType.BLOCK_BREAK_RARE, player, context);
    }

    private boolean shouldProcessEvent(EventType eventType, Player player) {
        if (!this.plugin.getLicenseManager().hasTier(PluginTier.MEDIUM)) {
            return false;
        }
        if (!this.plugin.getConfig().getBoolean("event_awareness.enabled", true)) {
            return false;
        }
        if (!this.isEventEnabled(eventType.getConfigKey())) {
            return false;
        }
        Boolean playerPreference = this.plugin.getDatabaseManager().getEventPreference(player.getUniqueId(), eventType);
        if (playerPreference != null && !playerPreference.booleanValue()) {
            return false;
        }
        return !this.isOnCooldown(eventType);
    }

    private boolean isEventEnabled(String eventKey) {
        return this.plugin.getConfig().getBoolean("event_awareness.events." + eventKey, false);
    }

    private boolean isOnCooldown(EventType eventType) {
        long cooldownMs = this.plugin.getConfig().getLong("event_awareness.cooldown_seconds", 30L) * 1000L;
        Long lastTrigger = this.lastEventTrigger.get((Object)eventType);
        if (lastTrigger == null) {
            return false;
        }
        return System.currentTimeMillis() - lastTrigger < cooldownMs;
    }

    private void updateCooldown(EventType eventType) {
        this.lastEventTrigger.put(eventType, System.currentTimeMillis());
    }

    private String buildEventContext(EventType eventType, Player player, String details) {
        StringBuilder context = new StringBuilder();
        context.append("[EVENT] ").append(eventType.getDisplayName()).append("\n");
        context.append("Player: ").append(player.getName()).append("\n");
        context.append("World: ").append(player.getWorld().getName()).append("\n");
        context.append("Location: ").append(this.formatLocation(player.getLocation())).append("\n");
        context.append("\n").append(details).append("\n\n");
        String customPrompt = this.plugin.getConfig().getString("event_awareness.prompts." + eventType.getConfigKey());
        if (customPrompt != null && !customPrompt.isEmpty()) {
            context.append("Response guidance: ").append(customPrompt);
        }
        return context.toString();
    }

    private void triggerAIResponse(EventType eventType, Player player, String context) {
        long timeSince;
        String playerEventKey = String.valueOf(player.getUniqueId()) + ":" + eventType.name();
        Long lastPlayerEvent = this.playerEventCooldown.get(playerEventKey);
        if (lastPlayerEvent != null && (timeSince = System.currentTimeMillis() - lastPlayerEvent) < 10000L) {
            return;
        }
        this.playerEventCooldown.put(playerEventKey, System.currentTimeMillis());
        this.updateCooldown(eventType);
        String responseMode = this.plugin.getConfig().getString("event_awareness.response_mode", "private");
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try {
                List<ChatMessage> conversationHistory = this.plugin.getConversationManager().getConversationContext(player.getUniqueId(), player.getName());
                ChatRequest.Builder requestBuilder = ChatRequest.builder().model(this.plugin.getProviderManager().getPrimaryProvider().getDefaultModel()).addSystemMessage(this.plugin.getConfigManager().getSystemPrompt()).temperature(0.7).maxTokens(300);
                for (ChatMessage historyMessage : conversationHistory) {
                    if (historyMessage.getRole().equals("user")) {
                        requestBuilder.addUserMessage(historyMessage.getContent());
                        continue;
                    }
                    if (!historyMessage.getRole().equals("assistant")) continue;
                    requestBuilder.addAssistantMessage(historyMessage.getContent());
                }
                requestBuilder.addUserMessage(context);
                ChatRequest request = requestBuilder.build();
                this.plugin.getProviderManager().sendRequest(request).thenAccept(response -> {
                    if (response.isSuccess()) {
                        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.sendResponse(responseMode, player, response.getContent(), eventType));
                        this.plugin.getConversationManager().saveUserMessage(player.getUniqueId(), player.getName(), context);
                        this.plugin.getConversationManager().saveAssistantMessage(player.getUniqueId(), player.getName(), response.getContent());
                    } else {
                        this.plugin.getNexvorLogger().error("Failed to get AI response for event: " + response.getErrorMessage(), null);
                    }
                });
            }
            catch (Exception e) {
                this.plugin.getNexvorLogger().error("Failed to get AI response for event: " + e.getMessage(), e);
            }
        });
    }

    private void sendResponse(String mode, Player player, String response, EventType eventType) {
        String prefix = this.plugin.getConfigManager().getPrefix();
        switch (mode.toLowerCase()) {
            case "public": {
                Bukkit.broadcastMessage((String)(prefix + " \u00a7f" + response));
                this.plugin.getLogger().info("[" + this.plugin.getConfigManager().getBotName() + "] " + response);
                break;
            }
            case "group": {
                List<GroupConversation> playerGroups;
                ProximityGroup proximityGroup;
                String proximityGroupId;
                boolean sentToGroup = false;
                if (this.plugin.getProximityChatManager() != null && (proximityGroupId = this.plugin.getProximityChatManager().getPlayerGroup(player.getUniqueId())) != null && (proximityGroup = this.plugin.getProximityChatManager().getGroup(proximityGroupId)) != null) {
                    proximityGroup.getMembers().forEach(uuid -> {
                        Player member = Bukkit.getPlayer((UUID)uuid);
                        if (member != null && member.isOnline()) {
                            member.sendMessage(prefix + " \u00a7f" + response);
                        }
                    });
                    sentToGroup = true;
                }
                if (!sentToGroup && this.plugin.getGlobalChatManager() != null) {
                    Bukkit.getOnlinePlayers().forEach(p -> p.sendMessage(prefix + " \u00a7f" + response));
                    sentToGroup = true;
                }
                if (!sentToGroup && this.plugin.getGroupConversationManager() != null && !(playerGroups = this.plugin.getGroupConversationManager().getPlayerGroups(player.getUniqueId())).isEmpty()) {
                    GroupConversation group = playerGroups.get(0);
                    group.getMembers().forEach(uuid -> {
                        Player member = Bukkit.getPlayer((UUID)uuid);
                        if (member != null && member.isOnline()) {
                            member.sendMessage(prefix + " \u00a7f" + response);
                        }
                    });
                    sentToGroup = true;
                }
                if (sentToGroup) break;
                player.sendMessage(prefix + " \u00a7f" + response);
                break;
            }
            default: {
                player.sendMessage(prefix + " \u00a7f" + response);
            }
        }
    }

    private String formatLocation(Location location) {
        return String.format("(%d, %d, %d)", location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    private String formatAdvancementName(String key) {
        return Arrays.stream(key.split("_")).map(word -> word.substring(0, 1).toUpperCase() + word.substring(1).toLowerCase()).reduce((a, b) -> a + " " + b).orElse(key);
    }
}

