/*
 * Decompiled with CFR 0.152.
 */
package com.nexvor.integrations;

import com.nexvor.Nexvor;
import com.nexvor.core.NexvorLogger;
import com.nexvor.core.PluginTier;
import com.nexvor.integrations.DiscordSRVHook;
import com.nexvor.integrations.PlaceholderAPIHook;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class IntegrationManager {
    private final Nexvor plugin;
    private final NexvorLogger logger;
    private boolean placeholderAPIEnabled = false;
    private boolean discordSRVEnabled = false;
    private DiscordSRVHook discordSRVHook;

    public IntegrationManager(Nexvor plugin) {
        this.plugin = plugin;
        this.logger = plugin.getNexvorLogger();
    }

    public void initialize() {
        String discordMode;
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            try {
                PlaceholderAPIHook hook = new PlaceholderAPIHook(this.plugin);
                if (hook.register()) {
                    this.placeholderAPIEnabled = true;
                    this.logger.info("PlaceholderAPI integration enabled");
                }
            }
            catch (Exception e) {
                this.logger.warn("Failed to hook into PlaceholderAPI: " + e.getMessage());
            }
        }
        if ((discordMode = this.plugin.getConfig().getString("discord.mode", "disabled")).equalsIgnoreCase("discordsrv")) {
            if (Bukkit.getPluginManager().getPlugin("DiscordSRV") != null) {
                boolean enabled = this.plugin.getConfig().getBoolean("discord.discordsrv.enabled", true);
                if (!this.plugin.hasTier(PluginTier.MEDIUM)) {
                    this.logger.info("DiscordSRV detected but requires Medium tier or higher");
                } else if (!enabled) {
                    this.logger.info("DiscordSRV detected but disabled in config");
                } else {
                    try {
                        this.discordSRVHook = new DiscordSRVHook(this.plugin);
                        if (this.discordSRVHook.register()) {
                            this.discordSRVEnabled = true;
                            this.logger.info("DiscordSRV integration enabled - natural AI interactions active");
                            Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, () -> {
                                if (this.discordSRVHook != null) {
                                    this.discordSRVHook.cleanup();
                                }
                            }, 6000L, 6000L);
                        }
                    }
                    catch (Exception e) {
                        this.logger.warn("Failed to hook into DiscordSRV: " + e.getMessage());
                        e.printStackTrace();
                    }
                }
            } else {
                this.logger.warn("Discord mode set to 'discordsrv' but DiscordSRV plugin not found");
            }
        } else if (discordMode.equalsIgnoreCase("standalone")) {
            this.logger.warn("Standalone Discord bot mode is not yet available");
            this.logger.warn("Please use 'discordsrv' mode or wait for the Nexvor-Discord addon");
        }
        if (!this.placeholderAPIEnabled && !this.discordSRVEnabled) {
            this.logger.info("No optional integrations detected");
        }
    }

    public void shutdown() {
        if (this.discordSRVHook != null) {
            this.discordSRVHook.unregister();
        }
    }

    public boolean isPlaceholderAPIEnabled() {
        return this.placeholderAPIEnabled;
    }

    public boolean isDiscordSRVEnabled() {
        return this.discordSRVEnabled;
    }

    public DiscordSRVHook getDiscordSRVHook() {
        return this.discordSRVHook;
    }
}

