/*
 * Decompiled with CFR 0.152.
 */
package com.nexvor.integrations;

import com.nexvor.Nexvor;
import com.nexvor.ai.models.ChatMessage;
import com.nexvor.ai.models.ChatRequest;
import com.nexvor.ai.models.ChatResponse;
import com.nexvor.core.NexvorLogger;
import com.nexvor.integrations.DiscordMessageFormatter;
import com.nexvor.integrations.DiscordRateLimitManager;
import com.nexvor.memory.DiscordConversationManager;
import com.nexvor.ratelimit.RateLimitResult;
import github.scarsz.discordsrv.DiscordSRV;
import github.scarsz.discordsrv.api.Subscribe;
import github.scarsz.discordsrv.api.events.AccountLinkedEvent;
import github.scarsz.discordsrv.api.events.AccountUnlinkedEvent;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Message;
import github.scarsz.discordsrv.dependencies.jda.api.entities.MessageEmbed;
import github.scarsz.discordsrv.dependencies.jda.api.entities.TextChannel;
import github.scarsz.discordsrv.dependencies.jda.api.entities.User;
import github.scarsz.discordsrv.dependencies.jda.api.events.message.guild.GuildMessageReceivedEvent;
import github.scarsz.discordsrv.dependencies.jda.api.hooks.ListenerAdapter;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class DiscordSRVHook
extends ListenerAdapter {
    private final Nexvor plugin;
    private final NexvorLogger logger;
    private final DiscordConversationManager conversationManager;
    private final DiscordMessageFormatter formatter;
    private final DiscordRateLimitManager rateLimitManager;
    private User selfUser;

    public DiscordSRVHook(Nexvor plugin) {
        this.plugin = plugin;
        this.logger = plugin.getNexvorLogger();
        this.conversationManager = new DiscordConversationManager(plugin);
        this.formatter = new DiscordMessageFormatter(plugin);
        this.rateLimitManager = new DiscordRateLimitManager(plugin);
    }

    public boolean register() {
        try {
            DiscordSRV.api.subscribe((Object)this);
            if (DiscordSRV.getPlugin().getJda() != null) {
                DiscordSRV.getPlugin().getJda().addEventListener(new Object[]{this});
                this.selfUser = DiscordSRV.getPlugin().getJda().getSelfUser();
            }
            this.logger.info("DiscordSRV hook registered successfully");
            return true;
        }
        catch (Exception e) {
            this.logger.error("Failed to register DiscordSRV hook", e);
            return false;
        }
    }

    public void unregister() {
        try {
            DiscordSRV.api.unsubscribe((Object)this);
            this.logger.info("DiscordSRV hook unregistered");
        }
        catch (Exception e) {
            this.logger.error("Error unregistering DiscordSRV hook", e);
        }
    }

    public void onGuildMessageReceived(GuildMessageReceivedEvent event) {
        if (event.getAuthor().isBot()) {
            return;
        }
        Message message = event.getMessage();
        User author = event.getAuthor();
        TextChannel channel = event.getChannel();
        MessageTriggerType triggerType = this.classifyMessage(message);
        if (triggerType == MessageTriggerType.NONE) {
            return;
        }
        if (!this.isChannelAllowed(channel, triggerType)) {
            return;
        }
        this.processMessage(message, author, channel, triggerType);
    }

    private MessageTriggerType classifyMessage(Message message) {
        String content = message.getContentRaw().toLowerCase();
        String botName = this.plugin.getConfig().getString("bot.name", "nexvor").toLowerCase();
        if (this.selfUser != null && message.getMentionedUsers().contains(this.selfUser) && this.plugin.getConfig().getBoolean("discord.discordsrv.direct_mention.enabled", true)) {
            return MessageTriggerType.DIRECT_MENTION;
        }
        if (content.contains(botName) && this.plugin.getConfig().getBoolean("discord.discordsrv.name_mention.enabled", true)) {
            if (this.isQuestion(content)) {
                if (this.plugin.getConfig().getBoolean("discord.discordsrv.name_mention.respond_to_questions", true)) {
                    return MessageTriggerType.NAME_MENTION_QUESTION;
                }
            } else if (this.plugin.getConfig().getBoolean("discord.discordsrv.name_mention.respond_to_casual", true)) {
                return MessageTriggerType.NAME_MENTION_CASUAL;
            }
        }
        String prefix = this.plugin.getConfig().getString("discord.discordsrv.command_prefix.prefix", "!ai");
        if (this.plugin.getConfig().getBoolean("discord.discordsrv.command_prefix.enabled", false) && content.startsWith(prefix.toLowerCase() + " ")) {
            return MessageTriggerType.COMMAND_PREFIX;
        }
        return MessageTriggerType.NONE;
    }

    private boolean isQuestion(String message) {
        String[] helpWords;
        String[] questionWords;
        if ((message = message.trim().toLowerCase()).endsWith("?")) {
            return true;
        }
        for (String word : questionWords = new String[]{"what", "how", "why", "when", "where", "who", "which", "can you", "could you", "would you", "will you", "do you", "does", "is"}) {
            if (!message.startsWith(word + " ")) continue;
            return true;
        }
        for (String word : helpWords = new String[]{"help", "tell me", "explain", "show me"}) {
            if (!message.contains(word)) continue;
            return true;
        }
        return false;
    }

    private boolean isChannelAllowed(TextChannel channel, MessageTriggerType triggerType) {
        String configPrefix;
        switch (triggerType) {
            case DIRECT_MENTION: {
                String string = "discord.discordsrv.direct_mention";
                break;
            }
            case NAME_MENTION_QUESTION: 
            case NAME_MENTION_CASUAL: {
                String string = "discord.discordsrv.name_mention";
                break;
            }
            case COMMAND_PREFIX: {
                String string = "discord.discordsrv.command_prefix";
                break;
            }
            default: {
                String string = configPrefix = null;
            }
        }
        if (configPrefix == null) {
            return false;
        }
        boolean allowAll = this.plugin.getConfig().getBoolean(configPrefix + ".allow_all_channels", false);
        if (allowAll) {
            return true;
        }
        List allowedChannels = this.plugin.getConfig().getStringList(configPrefix + ".allowed_channels");
        return !allowedChannels.isEmpty() && allowedChannels.contains(channel.getId());
    }

    private void processMessage(Message message, User author, TextChannel channel, MessageTriggerType triggerType) {
        String extractedMessage = this.extractMessageContent(message, triggerType);
        if (extractedMessage.trim().isEmpty()) {
            channel.sendMessage((CharSequence)"How can I help you? Ask me a question!").queue();
            return;
        }
        switch (triggerType) {
            case DIRECT_MENTION: 
            case NAME_MENTION_QUESTION: 
            case COMMAND_PREFIX: {
                this.processAIRequest(message, author, channel, extractedMessage, false);
                break;
            }
            case NAME_MENTION_CASUAL: {
                this.processCasualMention(message, author, channel);
            }
        }
    }

    private String extractMessageContent(Message message, MessageTriggerType triggerType) {
        String content = message.getContentRaw();
        switch (triggerType) {
            case DIRECT_MENTION: {
                if (this.selfUser == null) break;
                content = content.replace("<@!" + this.selfUser.getId() + ">", "");
                content = content.replace("<@" + this.selfUser.getId() + ">", "");
                break;
            }
            case COMMAND_PREFIX: {
                String prefix = this.plugin.getConfig().getString("discord.discordsrv.command_prefix.prefix", "!ai");
                if (!content.toLowerCase().startsWith(prefix.toLowerCase() + " ")) break;
                content = content.substring(prefix.length() + 1);
            }
        }
        return content.trim();
    }

    private void processCasualMention(Message message, User author, TextChannel channel) {
        boolean useEmbeds;
        String casualResponse = this.plugin.getConfig().getString("discord.discordsrv.name_mention.casual_response", "I heard my name? How can I help?");
        if (this.plugin.getConfig().getBoolean("discord.discordsrv.reactions.enabled", true)) {
            String emoji = this.plugin.getConfig().getString("discord.discordsrv.reactions.success", "\u2705");
            message.addReaction(emoji).queue();
        }
        if (useEmbeds = this.plugin.getConfig().getBoolean("discord.discordsrv.response_style.use_embeds", true)) {
            channel.sendMessageEmbeds(this.formatter.buildCasualMentionEmbed(author, casualResponse), new MessageEmbed[0]).queue();
        } else {
            channel.sendMessage((CharSequence)this.formatter.formatCasualMentionPlainText(casualResponse)).queue();
        }
    }

    private void processAIRequest(Message message, User author, TextChannel channel, String userMessage, boolean isCasualMention) {
        long discordUserId = author.getIdLong();
        RateLimitResult rateLimitResult = this.rateLimitManager.checkAllowed(discordUserId);
        if (!rateLimitResult.isAllowed()) {
            this.handleRateLimit(message, channel, rateLimitResult);
            return;
        }
        if (this.plugin.getConfig().getBoolean("discord.discordsrv.reactions.enabled", true)) {
            String processingEmoji = this.plugin.getConfig().getString("discord.discordsrv.reactions.processing", "\u23f3");
            message.addReaction(processingEmoji).queue();
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try {
                List<ChatMessage> conversationHistory = this.conversationManager.getConversationContext(String.valueOf(discordUserId));
                ChatRequest.Builder requestBuilder = ChatRequest.builder().model(this.plugin.getProviderManager().getPrimaryProvider().getDefaultModel()).addSystemMessage(this.plugin.getConfigManager().getSystemPrompt()).temperature(0.7).maxTokens(500);
                for (ChatMessage historyMessage : conversationHistory) {
                    if (historyMessage.getRole().equals("user")) {
                        requestBuilder.addUserMessage(historyMessage.getContent());
                        continue;
                    }
                    if (!historyMessage.getRole().equals("assistant")) continue;
                    requestBuilder.addAssistantMessage(historyMessage.getContent());
                }
                requestBuilder.addUserMessage(userMessage);
                ChatRequest request = requestBuilder.build();
                this.conversationManager.saveUserMessage(String.valueOf(discordUserId), userMessage);
                ((CompletableFuture)this.plugin.getProviderManager().sendRequest(request).thenAccept(response -> this.handleAIResponse(message, author, channel, userMessage, (ChatResponse)response, discordUserId))).exceptionally(throwable -> {
                    this.handleAIError(message, channel, (Throwable)throwable);
                    return null;
                });
            }
            catch (Exception e) {
                this.handleAIError(message, channel, e);
            }
        });
    }

    private void handleAIResponse(Message originalMessage, User author, TextChannel channel, String userMessage, ChatResponse response, long discordUserId) {
        if (!response.isSuccess()) {
            this.handleAIError(originalMessage, channel, new Exception(response.getErrorMessage()));
            return;
        }
        String aiResponse = response.getContent();
        this.conversationManager.saveAssistantMessage(String.valueOf(discordUserId), aiResponse);
        this.rateLimitManager.recordRequest(discordUserId);
        if (this.plugin.getConfig().getBoolean("discord.discordsrv.reactions.enabled", true)) {
            String processingEmoji = this.plugin.getConfig().getString("discord.discordsrv.reactions.processing", "\u23f3");
            String successEmoji = this.plugin.getConfig().getString("discord.discordsrv.reactions.success", "\u2705");
            originalMessage.removeReaction(processingEmoji).queue();
            originalMessage.addReaction(successEmoji).queue();
        }
        this.sendDiscordResponse(channel, author, userMessage, aiResponse);
    }

    private void sendDiscordResponse(TextChannel channel, User author, String userMessage, String aiResponse) {
        boolean useEmbeds = this.plugin.getConfig().getBoolean("discord.discordsrv.response_style.use_embeds", true);
        boolean useFallback = this.plugin.getConfig().getBoolean("discord.discordsrv.response_style.use_plain_text_fallback", true);
        int splitThreshold = this.plugin.getConfig().getInt("discord.discordsrv.long_messages.split_threshold", 4000);
        if (useEmbeds) {
            try {
                if (aiResponse.length() <= splitThreshold) {
                    channel.sendMessageEmbeds(this.formatter.buildResponseEmbed(author, userMessage, aiResponse), new MessageEmbed[0]).queue();
                }
                List<MessageEmbed> embeds = this.formatter.buildSplitResponseEmbeds(author, userMessage, aiResponse);
                for (MessageEmbed embed : embeds) {
                    channel.sendMessageEmbeds(embed, new MessageEmbed[0]).queue();
                }
            }
            catch (Exception e) {
                if (useFallback) {
                    channel.sendMessage((CharSequence)this.formatter.formatPlainText(author.getName(), aiResponse)).queue();
                }
                this.logger.error("Failed to send Discord embed and fallback disabled", e);
            }
        } else {
            channel.sendMessage((CharSequence)this.formatter.formatPlainText(author.getName(), aiResponse)).queue();
        }
    }

    private void handleRateLimit(Message message, TextChannel channel, RateLimitResult result) {
        if (this.plugin.getConfig().getBoolean("discord.discordsrv.reactions.enabled", true)) {
            String emoji = this.plugin.getConfig().getString("discord.discordsrv.reactions.rate_limit", "\u23f0");
            message.addReaction(emoji).queue();
        }
        if (this.plugin.getConfig().getBoolean("discord.discordsrv.dm_notifications.send_rate_limit_dm", true)) {
            message.getAuthor().openPrivateChannel().queue(dm -> {
                if (result.getWaitTimeSeconds() > 0L) {
                    dm.sendMessageEmbeds(this.formatter.buildRateLimitEmbed(result.getWaitTimeSeconds()), new MessageEmbed[0]).queue();
                } else {
                    dm.sendMessage((CharSequence)result.getMessage()).queue();
                }
            });
        }
    }

    private void handleAIError(Message message, TextChannel channel, Throwable error) {
        this.logger.error("Discord AI request failed", error);
        if (this.plugin.getConfig().getBoolean("discord.discordsrv.reactions.enabled", true)) {
            String processingEmoji = this.plugin.getConfig().getString("discord.discordsrv.reactions.processing", "\u23f3");
            String errorEmoji = this.plugin.getConfig().getString("discord.discordsrv.reactions.error", "\u274c");
            message.removeReaction(processingEmoji).queue();
            message.addReaction(errorEmoji).queue();
        }
        channel.sendMessageEmbeds(this.formatter.buildErrorEmbed("Sorry, I encountered an error processing your request. Please try again later."), new MessageEmbed[0]).queue();
        if (this.plugin.getConfig().getBoolean("discord.discordsrv.dm_notifications.send_error_dm", false)) {
            message.getAuthor().openPrivateChannel().queue(dm -> dm.sendMessage((CharSequence)("An error occurred: " + error.getMessage())).queue());
        }
    }

    @Subscribe
    public void onAccountLinked(AccountLinkedEvent event) {
        UUID minecraftUuid = event.getPlayer().getUniqueId();
        String discordId = event.getUser().getId();
        this.conversationManager.linkAccount(minecraftUuid, discordId);
        this.logger.info("Account linked: Discord " + discordId + " \u2194 Minecraft " + String.valueOf(minecraftUuid));
    }

    @Subscribe
    public void onAccountUnlinked(AccountUnlinkedEvent event) {
        UUID minecraftUuid = event.getPlayer().getUniqueId();
        this.conversationManager.unlinkAccount(minecraftUuid);
        this.logger.info("Account unlinked: Minecraft " + String.valueOf(minecraftUuid));
    }

    public DiscordConversationManager getConversationManager() {
        return this.conversationManager;
    }

    public DiscordRateLimitManager getRateLimitManager() {
        return this.rateLimitManager;
    }

    public void cleanup() {
        this.rateLimitManager.cleanup();
    }

    private static enum MessageTriggerType {
        NONE,
        DIRECT_MENTION,
        NAME_MENTION_QUESTION,
        NAME_MENTION_CASUAL,
        COMMAND_PREFIX;

    }
}

