/*
 * Decompiled with CFR 0.152.
 */
package com.nexvor.integrations;

import com.nexvor.Nexvor;
import com.nexvor.core.NexvorLogger;
import com.nexvor.ratelimit.RateLimitReason;
import com.nexvor.ratelimit.RateLimitResult;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;

public class DiscordRateLimitManager {
    private final Nexvor plugin;
    private final NexvorLogger logger;
    private final Map<Long, Long> lastRequestTime;
    private final Map<Long, Queue<Long>> requestHistory;
    private final boolean enabled;
    private final int cooldownSeconds;
    private final int maxRequestsPerMinute;

    public DiscordRateLimitManager(Nexvor plugin) {
        this.plugin = plugin;
        this.logger = plugin.getNexvorLogger();
        this.lastRequestTime = new ConcurrentHashMap<Long, Long>();
        this.requestHistory = new ConcurrentHashMap<Long, Queue<Long>>();
        this.enabled = plugin.getConfig().getBoolean("discord.discordsrv.rate_limiting.enabled", true);
        this.cooldownSeconds = plugin.getConfig().getInt("discord.discordsrv.rate_limiting.cooldown_seconds", 5);
        this.maxRequestsPerMinute = plugin.getConfig().getInt("discord.discordsrv.rate_limiting.max_requests_per_minute", 6);
        this.logger.info("Discord rate limiting: " + (this.enabled ? "enabled" : "disabled"));
        if (this.enabled) {
            this.logger.info("Discord cooldown: " + this.cooldownSeconds + "s, max requests: " + this.maxRequestsPerMinute + "/min");
        }
    }

    public RateLimitResult checkAllowed(long discordUserId) {
        if (!this.enabled) {
            return RateLimitResult.allowed();
        }
        long now = System.currentTimeMillis();
        RateLimitResult cooldownResult = this.checkCooldown(discordUserId, now);
        if (!cooldownResult.isAllowed()) {
            return cooldownResult;
        }
        RateLimitResult windowResult = this.checkSlidingWindow(discordUserId, now);
        if (!windowResult.isAllowed()) {
            return windowResult;
        }
        return RateLimitResult.allowed();
    }

    private RateLimitResult checkCooldown(long discordUserId, long now) {
        if (!this.lastRequestTime.containsKey(discordUserId)) {
            return RateLimitResult.allowed();
        }
        long lastTime = this.lastRequestTime.get(discordUserId);
        long elapsedSeconds = (now - lastTime) / 1000L;
        if (elapsedSeconds < (long)this.cooldownSeconds) {
            long remainingSeconds;
            String message = "Please wait **" + remainingSeconds + " second" + ((remainingSeconds = (long)this.cooldownSeconds - elapsedSeconds) == 1L ? "" : "s") + "** before sending another message.";
            return RateLimitResult.denied(message, RateLimitReason.COOLDOWN, remainingSeconds);
        }
        return RateLimitResult.allowed();
    }

    private RateLimitResult checkSlidingWindow(long discordUserId, long now) {
        Queue history = this.requestHistory.computeIfAbsent(discordUserId, k -> new LinkedList());
        long oneMinuteAgo = now - 60000L;
        history.removeIf(time -> time < oneMinuteAgo);
        if (history.size() >= this.maxRequestsPerMinute) {
            String message = "You've sent **" + this.maxRequestsPerMinute + " messages** in the last minute. Please slow down.";
            return RateLimitResult.denied(message, RateLimitReason.RATE_LIMIT);
        }
        return RateLimitResult.allowed();
    }

    public void recordRequest(long discordUserId) {
        long now = System.currentTimeMillis();
        this.lastRequestTime.put(discordUserId, now);
        Queue history = this.requestHistory.computeIfAbsent(discordUserId, k -> new LinkedList());
        history.add(now);
        long oneMinuteAgo = now - 60000L;
        history.removeIf(time -> time < oneMinuteAgo);
    }

    public String getUsageStats(long discordUserId) {
        long now = System.currentTimeMillis();
        Queue<Long> history = this.requestHistory.get(discordUserId);
        int requestsThisMinute = 0;
        if (history != null) {
            long oneMinuteAgo = now - 60000L;
            requestsThisMinute = (int)history.stream().filter(time -> time >= oneMinuteAgo).count();
        }
        Long lastTime = this.lastRequestTime.get(discordUserId);
        Object lastRequestStr = "never";
        if (lastTime != null) {
            long secondsAgo = (now - lastTime) / 1000L;
            lastRequestStr = secondsAgo < 60L ? secondsAgo + "s ago" : (secondsAgo < 3600L ? secondsAgo / 60L + "m ago" : secondsAgo / 3600L + "h ago");
        }
        return "Usage: " + requestsThisMinute + "/" + this.maxRequestsPerMinute + " requests this minute | Last request: " + (String)lastRequestStr;
    }

    public void cleanup() {
        long now = System.currentTimeMillis();
        long fiveMinutesAgo = now - 300000L;
        this.lastRequestTime.entrySet().removeIf(entry -> (Long)entry.getValue() < fiveMinutesAgo);
        this.requestHistory.entrySet().removeIf(entry -> {
            Queue history = (Queue)entry.getValue();
            long oneMinuteAgo = now - 60000L;
            history.removeIf(time -> time < oneMinuteAgo);
            return history.isEmpty();
        });
        this.logger.debug("Discord rate limit cleanup: " + this.lastRequestTime.size() + " active users");
    }

    public void clearUser(long discordUserId) {
        this.lastRequestTime.remove(discordUserId);
        this.requestHistory.remove(discordUserId);
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

