/*
 * Decompiled with CFR 0.152.
 */
package com.nexvor.integrations;

import com.nexvor.Nexvor;
import github.scarsz.discordsrv.dependencies.jda.api.EmbedBuilder;
import github.scarsz.discordsrv.dependencies.jda.api.entities.MessageEmbed;
import github.scarsz.discordsrv.dependencies.jda.api.entities.User;
import java.awt.Color;
import java.time.Instant;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.List;

public class DiscordMessageFormatter {
    private final Nexvor plugin;
    private static final int EMBED_DESCRIPTION_LIMIT = 4096;
    private static final int EMBED_TOTAL_LIMIT = 6000;

    public DiscordMessageFormatter(Nexvor plugin) {
        this.plugin = plugin;
    }

    public MessageEmbed buildResponseEmbed(User user, String userMessage, String aiResponse) {
        EmbedBuilder embed = new EmbedBuilder();
        String botName = this.plugin.getConfig().getString("bot.name", "Nexvor");
        embed.setTitle("\ud83e\udd16 " + botName);
        String colorHex = this.plugin.getConfig().getString("discord.discordsrv.response_style.embed_color", "#5865F2");
        try {
            embed.setColor(Color.decode(colorHex));
        }
        catch (NumberFormatException e) {
            embed.setColor(Color.decode("#5865F2"));
        }
        if (userMessage != null && !userMessage.isEmpty()) {
            if (userMessage.length() <= 100) {
                String question = "**" + user.getAsMention() + " asked:**\n" + userMessage + "\n\n";
                embed.setDescription((CharSequence)(question + (String)(aiResponse.length() <= 3900 ? aiResponse : aiResponse.substring(0, 3900) + "...")));
            } else {
                embed.setDescription((CharSequence)(aiResponse.length() <= 4096 ? aiResponse : aiResponse.substring(0, 4000) + "..."));
            }
        } else {
            embed.setDescription((CharSequence)(aiResponse.length() <= 4096 ? aiResponse : aiResponse.substring(0, 4000) + "..."));
        }
        embed.setThumbnail(user.getEffectiveAvatarUrl());
        embed.setFooter("Powered by Nexvor");
        embed.setTimestamp((TemporalAccessor)Instant.now());
        return embed.build();
    }

    public MessageEmbed buildCasualMentionEmbed(User user, String casualResponse) {
        EmbedBuilder embed = new EmbedBuilder();
        String botName = this.plugin.getConfig().getString("bot.name", "Nexvor");
        embed.setTitle("\ud83d\udc4b " + botName);
        String colorHex = this.plugin.getConfig().getString("discord.discordsrv.response_style.embed_color", "#5865F2");
        try {
            embed.setColor(Color.decode(colorHex));
        }
        catch (NumberFormatException e) {
            embed.setColor(Color.decode("#5865F2"));
        }
        embed.setDescription((CharSequence)casualResponse);
        return embed.build();
    }

    public List<MessageEmbed> buildSplitResponseEmbeds(User user, String userMessage, String aiResponse) {
        ArrayList<MessageEmbed> embeds = new ArrayList<MessageEmbed>();
        int splitThreshold = 4000;
        int maxSplits = 3;
        if (aiResponse.length() <= splitThreshold) {
            embeds.add(this.buildResponseEmbed(user, userMessage, aiResponse));
            return embeds;
        }
        List<String> chunks = this.splitIntoChunks(aiResponse, splitThreshold);
        if (chunks.size() > maxSplits) {
            chunks = chunks.subList(0, maxSplits);
            String lastChunk = chunks.get(maxSplits - 1);
            chunks.set(maxSplits - 1, lastChunk + "\n\n_(Response truncated - too long)_");
        }
        EmbedBuilder firstEmbed = new EmbedBuilder();
        String botName = this.plugin.getConfig().getString("bot.name", "Nexvor");
        firstEmbed.setTitle("\ud83e\udd16 " + botName);
        String colorHex = this.plugin.getConfig().getString("discord.discordsrv.response_style.embed_color", "#5865F2");
        try {
            firstEmbed.setColor(Color.decode(colorHex));
        }
        catch (NumberFormatException e) {
            firstEmbed.setColor(Color.decode("#5865F2"));
        }
        if (userMessage != null && !userMessage.isEmpty() && userMessage.length() <= 100) {
            firstEmbed.setDescription((CharSequence)("**" + user.getAsMention() + " asked:**\n" + userMessage + "\n\n" + chunks.get(0)));
        } else {
            firstEmbed.setDescription((CharSequence)chunks.get(0));
        }
        firstEmbed.setThumbnail(user.getEffectiveAvatarUrl());
        String continuationFormat = "(continued {current}/{total})";
        firstEmbed.setFooter(continuationFormat.replace("{current}", "1").replace("{total}", String.valueOf(chunks.size())));
        embeds.add(firstEmbed.build());
        for (int i = 1; i < chunks.size(); ++i) {
            EmbedBuilder continuation = new EmbedBuilder();
            continuation.setColor(Color.decode(colorHex));
            continuation.setDescription((CharSequence)chunks.get(i));
            continuation.setFooter(continuationFormat.replace("{current}", String.valueOf(i + 1)).replace("{total}", String.valueOf(chunks.size())));
            embeds.add(continuation.build());
        }
        return embeds;
    }

    public String formatPlainText(String username, String aiResponse) {
        String botName = this.plugin.getConfig().getString("bot.name", "Nexvor");
        return "**[" + botName + "]** " + aiResponse;
    }

    public String formatCasualMentionPlainText(String casualResponse) {
        String botName = this.plugin.getConfig().getString("bot.name", "Nexvor");
        return "**[" + botName + "]** " + casualResponse;
    }

    private List<String> splitIntoChunks(String text, int maxLength) {
        ArrayList<String> chunks = new ArrayList<String>();
        while (text.length() > maxLength) {
            int splitPoint = this.findBestSplitPoint(text, maxLength);
            chunks.add(text.substring(0, splitPoint).trim());
            text = text.substring(splitPoint).trim();
        }
        if (!text.isEmpty()) {
            chunks.add(text);
        }
        return chunks;
    }

    private int findBestSplitPoint(String text, int maxLength) {
        if (text.length() <= maxLength) {
            return text.length();
        }
        int paragraphBreak = text.lastIndexOf("\n\n", maxLength);
        if (paragraphBreak > maxLength / 2) {
            return paragraphBreak + 2;
        }
        int sentenceBreak = text.lastIndexOf(". ", maxLength);
        if (sentenceBreak > maxLength / 2) {
            return sentenceBreak + 2;
        }
        int newlineBreak = text.lastIndexOf("\n", maxLength);
        if (newlineBreak > maxLength / 2) {
            return newlineBreak + 1;
        }
        int spaceBreak = text.lastIndexOf(" ", maxLength);
        if (spaceBreak > maxLength / 2) {
            return spaceBreak + 1;
        }
        return maxLength;
    }

    public MessageEmbed buildErrorEmbed(String errorMessage) {
        EmbedBuilder embed = new EmbedBuilder();
        embed.setTitle("\u274c Error");
        embed.setColor(Color.RED);
        embed.setDescription((CharSequence)errorMessage);
        return embed.build();
    }

    public MessageEmbed buildRateLimitEmbed(long remainingSeconds) {
        EmbedBuilder embed = new EmbedBuilder();
        embed.setTitle("\u23f0 Slow Down");
        embed.setColor(Color.ORANGE);
        embed.setDescription((CharSequence)("Please wait **" + remainingSeconds + " second" + (remainingSeconds == 1L ? "" : "s") + "** before sending another message."));
        return embed.build();
    }
}

