/*
 * Decompiled with CFR 0.152.
 */
package com.nexvor.features.max.models;

import java.util.ArrayList;
import java.util.List;

public class ToxicityResult {
    private double score = 0.0;
    private Severity severity = Severity.NONE;
    private List<String> reasons = new ArrayList<String>();
    private boolean whitelisted = false;

    public void addKeywordScore(double score, String reason) {
        this.score = Math.max(this.score, score);
        if (reason != null && !reason.isEmpty()) {
            this.reasons.add(reason);
        }
        this.updateSeverity();
    }

    public void addAIScore(double score, String reason) {
        this.score = Math.max(this.score, score * 1.1);
        if (reason != null && !reason.isEmpty()) {
            this.reasons.add("AI: " + reason);
        }
        this.updateSeverity();
    }

    private void updateSeverity() {
        this.severity = this.score >= 0.85 ? Severity.CRITICAL : (this.score >= 0.7 ? Severity.HIGH : (this.score >= 0.5 ? Severity.MEDIUM : (this.score >= 0.3 ? Severity.LOW : Severity.NONE)));
    }

    public double getScore() {
        return this.score;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public List<String> getReasons() {
        return new ArrayList<String>(this.reasons);
    }

    public boolean isWhitelisted() {
        return this.whitelisted;
    }

    public void setWhitelisted(boolean whitelisted) {
        this.whitelisted = whitelisted;
        if (whitelisted) {
            this.severity = Severity.NONE;
        }
    }

    public boolean isToxic() {
        return !this.whitelisted && this.severity.ordinal() >= Severity.MEDIUM.ordinal();
    }

    public boolean requiresAction() {
        return !this.whitelisted && this.severity.ordinal() >= Severity.HIGH.ordinal();
    }

    public String toString() {
        return "ToxicityResult{score=" + String.format("%.2f", this.score) + ", severity=" + String.valueOf((Object)this.severity) + ", reasons=" + this.reasons.size() + ", whitelisted=" + this.whitelisted + "}";
    }

    public static enum Severity {
        NONE,
        LOW,
        MEDIUM,
        HIGH,
        CRITICAL;

    }
}

