/*
 * Decompiled with CFR 0.152.
 */
package com.nexvor.features.max.models;

public class ModerationAction {
    private final ActionType type;
    private final String reason;
    private final int duration;

    private ModerationAction(ActionType type, String reason, int duration) {
        this.type = type;
        this.reason = reason;
        this.duration = duration;
    }

    public static ModerationAction none() {
        return new ModerationAction(ActionType.NONE, null, 0);
    }

    public static ModerationAction warn(String reason) {
        return new ModerationAction(ActionType.WARN, reason, 0);
    }

    public static ModerationAction block(String reason) {
        return new ModerationAction(ActionType.BLOCK, reason, 0);
    }

    public static ModerationAction mute(String reason, int durationSeconds) {
        return new ModerationAction(ActionType.MUTE, reason, durationSeconds);
    }

    public static ModerationAction kick(String reason) {
        return new ModerationAction(ActionType.KICK, reason, 0);
    }

    public static ModerationAction notifyAdmins(String reason) {
        return new ModerationAction(ActionType.NOTIFY_ADMINS, reason, 0);
    }

    public ActionType getType() {
        return this.type;
    }

    public String getReason() {
        return this.reason;
    }

    public int getDuration() {
        return this.duration;
    }

    public boolean shouldBlock() {
        return this.type == ActionType.BLOCK || this.type == ActionType.KICK;
    }

    public String toString() {
        return "ModerationAction{type=" + String.valueOf((Object)this.type) + ", reason='" + this.reason + "', duration=" + this.duration + "}";
    }

    public static enum ActionType {
        NONE,
        WARN,
        BLOCK,
        MUTE,
        KICK,
        NOTIFY_ADMINS;

    }
}

