/*
 * Decompiled with CFR 0.152.
 */
package com.nexvor.features.max.models;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class CommandValidator {
    private final String command;
    private final Pattern validatorPattern;
    private final String description;
    private final List<String> blacklistItems;

    public CommandValidator(String command, String validatorRegex, String description, List<String> blacklistItems) {
        this.command = command;
        this.validatorPattern = validatorRegex != null && !validatorRegex.isEmpty() ? Pattern.compile(validatorRegex) : null;
        this.description = description != null ? description : "";
        this.blacklistItems = blacklistItems != null ? new ArrayList<String>(blacklistItems) : new ArrayList();
    }

    public boolean validate(String commandText) {
        if (this.validatorPattern != null) {
            return this.validatorPattern.matcher(commandText).matches();
        }
        return commandText.toLowerCase().startsWith(this.command.toLowerCase());
    }

    public String getCommand() {
        return this.command;
    }

    public String getDescription() {
        return this.description;
    }

    public List<String> getBlacklistItems() {
        return new ArrayList<String>(this.blacklistItems);
    }

    public boolean hasBlacklistedItems() {
        return !this.blacklistItems.isEmpty();
    }

    public String toString() {
        return "CommandValidator{command='" + this.command + "', description='" + this.description + "', blacklistItems=" + this.blacklistItems.size() + "}";
    }
}

