/*
 * Decompiled with CFR 0.152.
 */
package com.nexvor.features.max.models;

public class CommandExecutionResult {
    private final ResultType type;
    private final String command;
    private final String message;

    private CommandExecutionResult(ResultType type, String command, String message) {
        this.type = type;
        this.command = command;
        this.message = message;
    }

    public static CommandExecutionResult success(String command) {
        return new CommandExecutionResult(ResultType.SUCCESS, command, "Command executed successfully");
    }

    public static CommandExecutionResult failed(String command, String reason) {
        return new CommandExecutionResult(ResultType.FAILED, command, reason);
    }

    public static CommandExecutionResult dryRun(String command) {
        return new CommandExecutionResult(ResultType.DRY_RUN, command, "Dry-run mode: command logged but not executed");
    }

    public static CommandExecutionResult noCommand() {
        return new CommandExecutionResult(ResultType.NO_COMMAND, null, "No [COMMAND] tag found in response");
    }

    public static CommandExecutionResult rejected(String reason) {
        return new CommandExecutionResult(ResultType.REJECTED, null, reason);
    }

    public static CommandExecutionResult rateLimited(String message) {
        return new CommandExecutionResult(ResultType.RATE_LIMITED, null, message);
    }

    public static CommandExecutionResult noPermission() {
        return new CommandExecutionResult(ResultType.NO_PERMISSION, null, "Player lacks required permission");
    }

    public static CommandExecutionResult disabled() {
        return new CommandExecutionResult(ResultType.DISABLED, null, "AI command execution is disabled");
    }

    public ResultType getType() {
        return this.type;
    }

    public String getCommand() {
        return this.command;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean isSuccess() {
        return this.type == ResultType.SUCCESS || this.type == ResultType.DRY_RUN;
    }

    public boolean wasExecuted() {
        return this.type == ResultType.SUCCESS || this.type == ResultType.FAILED;
    }

    public boolean isDryRun() {
        return this.type == ResultType.DRY_RUN;
    }

    public boolean hasCommand() {
        return this.command != null;
    }

    public String toString() {
        return "CommandExecutionResult{type=" + String.valueOf((Object)this.type) + ", command='" + this.command + "', message='" + this.message + "'}";
    }

    public static enum ResultType {
        SUCCESS,
        FAILED,
        DRY_RUN,
        NO_COMMAND,
        REJECTED,
        RATE_LIMITED,
        NO_PERMISSION,
        DISABLED;

    }
}

