/*
 * Decompiled with CFR 0.152.
 */
package com.nexvor.features.max.models;

import com.nexvor.ai.ProviderManager;

public class BotPersonality {
    private final String name;
    private final String personality;
    private final ProviderManager providerManager;
    private final String systemPrompt;
    private final int cooldownSeconds;
    private final int maxPerMinute;

    public BotPersonality(String name, String personality, ProviderManager providerManager, String systemPrompt, int cooldownSeconds, int maxPerMinute) {
        this.name = name;
        this.personality = personality;
        this.providerManager = providerManager;
        this.systemPrompt = systemPrompt;
        this.cooldownSeconds = cooldownSeconds;
        this.maxPerMinute = maxPerMinute;
    }

    public String getName() {
        return this.name;
    }

    public String getPersonality() {
        return this.personality;
    }

    public ProviderManager getProviderManager() {
        return this.providerManager;
    }

    public String getSystemPrompt() {
        return this.systemPrompt;
    }

    public int getCooldownSeconds() {
        return this.cooldownSeconds;
    }

    public int getMaxPerMinute() {
        return this.maxPerMinute;
    }

    public String getDescription() {
        String providerInfo = this.providerManager.getPrimaryProvider().getProviderName();
        String model = this.providerManager.getPrimaryProvider().getDefaultModel();
        return this.personality + " personality using " + providerInfo + " (" + model + ")";
    }

    public String toString() {
        return "BotPersonality{name='" + this.name + "', personality='" + this.personality + "', provider=" + this.providerManager.getPrimaryProvider().getProviderName() + "}";
    }
}

