/*
 * Decompiled with CFR 0.152.
 */
package com.nexvor.features.max;

import com.nexvor.Nexvor;
import com.nexvor.ai.models.ChatRequest;
import com.nexvor.ai.models.ChatResponse;
import com.nexvor.core.NexvorLogger;
import com.nexvor.features.max.DiscordWebhookSender;
import com.nexvor.features.max.models.ModerationAction;
import com.nexvor.features.max.models.ToxicityResult;
import com.nexvor.filter.FilterResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.permissions.ServerOperator;

public class ModerationManager {
    private final Nexvor plugin;
    private final NexvorLogger logger;
    private final Map<String, List<Pattern>> keywordPatterns = new HashMap<String, List<Pattern>>();
    private final Map<String, Integer> severityWeights = new HashMap<String, Integer>();
    private final List<Pattern> whitelistPatterns = new ArrayList<Pattern>();

    public ModerationManager(Nexvor plugin) {
        this.plugin = plugin;
        this.logger = plugin.getNexvorLogger();
        this.loadKeywordPatterns();
        this.loadContextWhitelist();
    }

    private void loadKeywordPatterns() {
        this.keywordPatterns.clear();
        this.severityWeights.clear();
        String method2 = this.plugin.getConfig().getString("moderation.method", "hybrid").toLowerCase();
        if (!method2.equals("keyword") && !method2.equals("hybrid")) {
            this.logger.info("Keyword-based moderation disabled (method: " + method2 + ")");
            return;
        }
        if (this.plugin.getLanguageFilter() != null) {
            this.logger.debug("Loaded keyword patterns from LanguageFilter");
        }
        this.logger.info("Keyword moderation enabled (method: " + method2 + ")");
    }

    private void loadContextWhitelist() {
        this.whitelistPatterns.clear();
        List whitelist = this.plugin.getConfig().getStringList("moderation.safe_phrases");
        for (String pattern : whitelist) {
            try {
                this.whitelistPatterns.add(Pattern.compile(pattern, 2));
            }
            catch (Exception e) {
                this.logger.warn("Invalid whitelist pattern: " + pattern);
            }
        }
        this.logger.info("Loaded " + this.whitelistPatterns.size() + " context whitelist patterns");
    }

    public ToxicityResult analyzeToxicity(String message, String context) {
        ToxicityResult result = new ToxicityResult();
        if (this.isWhitelistedContext(message)) {
            result.setWhitelisted(true);
            this.logger.debug("Message whitelisted by context: " + message);
            return result;
        }
        String method2 = this.plugin.getConfig().getString("moderation.method", "hybrid").toLowerCase();
        if (method2.equals("keyword") || method2.equals("hybrid")) {
            this.performKeywordScan(message, result);
        }
        if ((method2.equals("ai") || method2.equals("hybrid")) && this.plugin.getConfig().getBoolean("moderation.ai_moderation.enabled", false) && result.getSeverity() == ToxicityResult.Severity.MEDIUM) {
            this.performAIModeration(message, context, result);
        }
        return result;
    }

    private boolean isWhitelistedContext(String message) {
        String lowerMessage = message.toLowerCase();
        for (Pattern pattern : this.whitelistPatterns) {
            if (!pattern.matcher(lowerMessage).find()) continue;
            return true;
        }
        return false;
    }

    private void performKeywordScan(String message, ToxicityResult result) {
        FilterResult filterResult;
        String lowerMessage = message.toLowerCase();
        if (this.plugin.getLanguageFilter() != null && this.plugin.getLanguageFilter().isEnabled() && !(filterResult = this.plugin.getLanguageFilter().check(message)).isAllowed()) {
            int matchCount = filterResult.getMatchCount();
            double baseScore = Math.min(0.5 + (double)matchCount * 0.1, 0.9);
            result.addKeywordScore(baseScore, "Profanity detected (" + matchCount + " words)");
        }
        if (this.containsHateSpeech(lowerMessage)) {
            result.addKeywordScore(0.9, "Hate speech detected");
        }
        if (this.containsThreats(lowerMessage)) {
            result.addKeywordScore(0.85, "Threatening language detected");
        }
        if (this.containsHarassment(lowerMessage)) {
            result.addKeywordScore(0.75, "Harassment detected");
        }
        if (this.containsSpam(lowerMessage)) {
            result.addKeywordScore(0.4, "Spam pattern detected");
        }
    }

    private void performAIModeration(String message, String context, ToxicityResult result) {
        try {
            String prompt = this.buildModerationPrompt(message, context);
            ChatRequest request = ChatRequest.builder().model("llama-3.3-70b-versatile").addSystemMessage("You are a content moderation AI. Analyze messages for toxicity and respond with a score from 0.0 (clean) to 1.0 (highly toxic). Be objective and consider context.").addUserMessage(prompt).temperature(0.3).maxTokens(100).build();
            ChatResponse response = this.plugin.getProviderManager().sendRequest(request).join();
            if (response.isSuccess()) {
                double aiScore = this.parseModerationScore(response.getContent());
                result.addAIScore(aiScore, "AI analysis");
                this.logger.debug("AI moderation score: " + aiScore + " for message: " + message);
            }
        }
        catch (Exception e) {
            this.logger.warn("AI moderation failed, falling back to keyword-only: " + e.getMessage());
        }
    }

    private String buildModerationPrompt(String message, String context) {
        StringBuilder prompt = new StringBuilder();
        prompt.append("Analyze this message for toxicity:\n\n");
        prompt.append("Message: \"").append(message).append("\"\n\n");
        if (context != null && !context.isEmpty()) {
            prompt.append("Context: ").append(context).append("\n\n");
        }
        prompt.append("Respond with only a number from 0.0 to 1.0, where:\n");
        prompt.append("0.0-0.3 = Clean\n");
        prompt.append("0.3-0.5 = Mild concern\n");
        prompt.append("0.5-0.7 = Moderate toxicity\n");
        prompt.append("0.7-0.85 = High toxicity\n");
        prompt.append("0.85-1.0 = Severe violation\n\n");
        prompt.append("Score:");
        return prompt.toString();
    }

    private double parseModerationScore(String response) {
        try {
            String cleaned = response.replaceAll("[^0-9.]", "");
            double score = Double.parseDouble(cleaned);
            return Math.max(0.0, Math.min(1.0, score));
        }
        catch (Exception e) {
            this.logger.warn("Failed to parse AI moderation score: " + response);
            return 0.5;
        }
    }

    public ModerationAction determineAction(ToxicityResult result) {
        if (result.isWhitelisted() || !result.isToxic()) {
            return ModerationAction.none();
        }
        String severityKey = result.getSeverity().name().toLowerCase();
        String configPath = "moderation.auto_actions." + severityKey;
        boolean warn = this.plugin.getConfig().getBoolean(configPath + ".warn", false);
        boolean mute = this.plugin.getConfig().getBoolean(configPath + ".mute", false);
        boolean kick = this.plugin.getConfig().getBoolean(configPath + ".kick", false);
        boolean notifyAdmins = this.plugin.getConfig().getBoolean(configPath + ".notify_admins", false);
        ArrayList actions = new ArrayList();
        if (kick) {
            return ModerationAction.kick("Toxic behavior: " + result.getReasons().get(0));
        }
        if (mute) {
            int duration = this.plugin.getConfig().getInt(configPath + ".mute_duration", 300);
            return ModerationAction.mute("Toxic behavior: " + result.getReasons().get(0), duration);
        }
        if (warn) {
            return ModerationAction.warn("Your message was flagged as inappropriate");
        }
        if (notifyAdmins) {
            return ModerationAction.notifyAdmins("Player violated moderation rules (Severity: " + String.valueOf((Object)result.getSeverity()) + ")");
        }
        return ModerationAction.block("Message flagged by moderation system");
    }

    public void takeAction(Player player, ToxicityResult result, ModerationAction action) {
        DiscordWebhookSender webhookSender;
        switch (action.getType()) {
            case WARN: {
                player.sendMessage(String.valueOf(ChatColor.RED) + "[Moderation] " + action.getReason());
                break;
            }
            case BLOCK: {
                player.sendMessage(String.valueOf(ChatColor.RED) + "[Moderation] Your message was blocked.");
                break;
            }
            case MUTE: {
                player.sendMessage(String.valueOf(ChatColor.RED) + "[Moderation] You have been muted for " + action.getDuration() + " seconds.");
                this.logger.warn("[Moderation] Player " + player.getName() + " muted for " + action.getDuration() + "s: " + action.getReason());
                break;
            }
            case KICK: {
                player.kickPlayer(String.valueOf(ChatColor.RED) + "[Moderation] " + action.getReason());
                break;
            }
            case NOTIFY_ADMINS: {
                this.notifyAdmins(player, result, action);
                break;
            }
        }
        this.plugin.getDatabaseManager().logModeration(player.getUniqueId(), player.getName(), result.getReasons().toString(), result.getSeverity().name(), action.getType().name(), action.getReason());
        if (result.getSeverity().ordinal() >= ToxicityResult.Severity.HIGH.ordinal() && (webhookSender = this.plugin.getDiscordWebhookSender()) != null && webhookSender.isEnabled()) {
            webhookSender.sendModerationAlert(player.getName(), result.getSeverity().name(), action.getType().name(), action.getReason());
        }
    }

    private void notifyAdmins(Player player, ToxicityResult result, ModerationAction action) {
        String message = String.valueOf(ChatColor.GOLD) + "[Nexvor Moderation] " + String.valueOf(ChatColor.WHITE) + player.getName() + String.valueOf(ChatColor.GRAY) + " \u2192 Severity: " + String.valueOf(ChatColor.RED) + String.valueOf((Object)result.getSeverity()) + String.valueOf(ChatColor.GRAY) + " (" + action.getReason() + ")";
        Bukkit.getOnlinePlayers().stream().filter(ServerOperator::isOp).forEach(op -> op.sendMessage(message));
        this.logger.warn("[Moderation] " + player.getName() + " - " + String.valueOf((Object)result.getSeverity()) + ": " + String.valueOf(result.getReasons()));
    }

    public void reload() {
        this.loadKeywordPatterns();
        this.loadContextWhitelist();
        this.logger.info("Moderation configuration reloaded");
    }

    private boolean containsHateSpeech(String message) {
        String[] patterns;
        for (String pattern : patterns = new String[]{"kill yourself", "kys", "rope yourself", "nazi", "racist slur patterns"}) {
            if (!message.contains(pattern)) continue;
            return true;
        }
        return false;
    }

    private boolean containsThreats(String message) {
        String[] patterns;
        for (String pattern : patterns = new String[]{"i will kill", "i'll hurt", "gonna hurt", "watch your back", "you're dead"}) {
            if (!message.contains(pattern)) continue;
            return true;
        }
        return false;
    }

    private boolean containsHarassment(String message) {
        String[] patterns;
        for (String pattern : patterns = new String[]{"nobody likes you", "you're worthless", "go die", "everyone hates"}) {
            if (!message.contains(pattern)) continue;
            return true;
        }
        return false;
    }

    private boolean containsSpam(String message) {
        if (message.length() > 50) {
            char prevChar = '\u0000';
            int repeatCount = 0;
            for (char c : message.toCharArray()) {
                if (c == prevChar) {
                    if (++repeatCount <= 10) continue;
                    return true;
                }
                repeatCount = 0;
                prevChar = c;
            }
        }
        return message.length() > 20 && message.equals(message.toUpperCase());
    }
}

