/*
 * Decompiled with CFR 0.152.
 */
package com.nexvor.features.max;

import com.nexvor.Nexvor;
import com.nexvor.core.NexvorLogger;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Instant;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class DiscordWebhookSender {
    private final Nexvor plugin;
    private final NexvorLogger logger;
    private final HttpClient httpClient;
    private String webhookUrl;
    private boolean enabled;

    public DiscordWebhookSender(Nexvor plugin) {
        this.plugin = plugin;
        this.logger = plugin.getNexvorLogger();
        this.httpClient = HttpClient.newHttpClient();
        this.loadConfiguration();
    }

    private void loadConfiguration() {
        this.webhookUrl = this.plugin.getConfig().getString("webhooks.discord.url", "");
        this.enabled = this.plugin.getConfig().getBoolean("webhooks.discord.enabled", false);
        if (this.enabled && (this.webhookUrl == null || this.webhookUrl.isEmpty())) {
            this.logger.warn("Discord webhooks enabled but no URL configured");
            this.enabled = false;
        }
        if (this.enabled) {
            this.logger.info("Discord webhooks enabled");
        }
    }

    public void sendCommandAlert(String playerName, String command, boolean success, boolean dryRun) {
        if (!this.enabled) {
            return;
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try {
                String title = this.escapeJson(dryRun ? "\ud83d\udd0d AI Command (Dry Run)" : "\u26a0\ufe0f AI Command Executed");
                String description = this.escapeJson(String.format("**Player:** %s\n**Command:** `%s`\n**Status:** %s", playerName, command, success ? "\u2705 Success" : "\u274c Failed"));
                int color = dryRun ? 16753920 : (success ? 65280 : 0xFF0000);
                String timestamp = Instant.now().toString();
                this.sendEmbed(title, description, color, timestamp);
            }
            catch (Exception e) {
                this.logger.error("Failed to send command webhook", e);
            }
        });
    }

    public void sendModerationAlert(String playerName, String severity, String action, String reason) {
        if (!this.enabled) {
            return;
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try {
                String title = this.escapeJson("\ud83d\udea8 Moderation Action");
                String description = this.escapeJson(String.format("**Player:** %s\n**Severity:** %s\n**Action:** %s\n**Reason:** %s", playerName, severity, action, reason));
                int color = this.getColorForSeverity(severity);
                String timestamp = Instant.now().toString();
                this.sendEmbed(title, description, color, timestamp);
            }
            catch (Exception e) {
                this.logger.error("Failed to send moderation webhook", e);
            }
        });
    }

    public void sendErrorAlert(String errorTitle, String errorMessage) {
        if (!this.enabled) {
            return;
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try {
                String title = this.escapeJson("\u274c Critical Error");
                String description = this.escapeJson(String.format("**Error:** %s\n**Message:** %s", errorTitle, errorMessage));
                int color = 0xFF0000;
                String timestamp = Instant.now().toString();
                this.sendEmbed(title, description, color, timestamp);
            }
            catch (Exception e) {
                this.logger.error("Failed to send error webhook", e);
            }
        });
    }

    private void sendEmbed(String title, String description, int color, String timestamp) throws IOException, InterruptedException {
        String payload = String.format("{\"embeds\":[{\"title\":\"%s\",\"description\":\"%s\",\"color\":%d,\"timestamp\":\"%s\"}]}", title, description, color, timestamp);
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(this.webhookUrl)).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(payload)).build();
        HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
        if (response.statusCode() != 204 && response.statusCode() != 200) {
            this.logger.warn("Discord webhook returned status " + response.statusCode() + ": " + response.body());
        }
    }

    private String escapeJson(String str) {
        return str.replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", "\\n").replace("\r", "\\r").replace("\t", "\\t");
    }

    private int getColorForSeverity(String severity) {
        return switch (severity.toUpperCase()) {
            case "LOW" -> 0xFFFF00;
            case "MEDIUM" -> 16753920;
            case "HIGH" -> 16729344;
            case "CRITICAL" -> 0xFF0000;
            default -> 0x808080;
        };
    }

    public void reload() {
        this.loadConfiguration();
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

