/*
 * Decompiled with CFR 0.152.
 */
package com.nexvor.features.max;

import com.nexvor.Nexvor;
import com.nexvor.ai.AIProvider;
import com.nexvor.ai.ProviderManager;
import com.nexvor.ai.providers.CustomProvider;
import com.nexvor.ai.providers.GroqProvider;
import com.nexvor.ai.providers.OpenAIProvider;
import com.nexvor.core.NexvorLogger;
import com.nexvor.core.PluginTier;
import com.nexvor.features.max.models.BotPersonality;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class BotPersonalityManager {
    private final Nexvor plugin;
    private final NexvorLogger logger;
    private final Map<String, BotPersonality> bots;
    private String defaultBotName;

    public BotPersonalityManager(Nexvor plugin) {
        this.plugin = plugin;
        this.logger = plugin.getNexvorLogger();
        this.bots = new HashMap<String, BotPersonality>();
    }

    public void initialize() {
        if (!this.plugin.hasTier(PluginTier.MAX)) {
            this.logger.info("Multi-Bot Support requires MAX tier license");
            return;
        }
        if (!this.plugin.getConfig().getBoolean("bots.enabled", false)) {
            this.logger.info("Multi-Bot Support is disabled in config");
            return;
        }
        this.defaultBotName = this.plugin.getConfig().getString("bots.default_bot", "default");
        List personalitiesList = this.plugin.getConfig().getMapList("bots.personalities");
        if (personalitiesList.isEmpty()) {
            this.logger.warn("No bot personalities configured! Add at least one in config.yml");
            return;
        }
        for (Map botConfig : personalitiesList) {
            try {
                this.loadBotPersonality(botConfig);
            }
            catch (Exception e) {
                this.logger.severe("Failed to load bot personality: " + e.getMessage());
            }
        }
        if (this.bots.isEmpty()) {
            this.logger.severe("No bot personalities loaded! Multi-bot support disabled.");
            return;
        }
        if (!this.bots.containsKey(this.defaultBotName)) {
            this.logger.warn("Default bot '" + this.defaultBotName + "' not found, using first bot");
            this.defaultBotName = this.bots.keySet().iterator().next();
        }
        this.logger.info("Loaded " + this.bots.size() + " bot personalities (default: " + this.defaultBotName + ")");
    }

    private void loadBotPersonality(Map<?, ?> config) {
        AIProvider provider;
        Map providerConfig;
        String systemPrompt;
        String name = (String)config.get("name");
        if (name == null || name.isEmpty()) {
            this.logger.warn("Bot personality missing 'name' field, skipping");
            return;
        }
        String personality = (String)config.get("personality");
        if (personality == null) {
            personality = "helper";
        }
        if ((systemPrompt = (String)config.get("system_prompt")) == null || systemPrompt.isEmpty()) {
            systemPrompt = this.getDefaultSystemPrompt(personality);
        }
        if ((providerConfig = (Map)config.get("provider")) == null) {
            this.logger.warn("Bot '" + name + "' missing 'provider' config, skipping");
            return;
        }
        String providerType = (String)providerConfig.get("type");
        String apiKey = (String)providerConfig.get("api_key");
        String model = (String)providerConfig.get("model");
        if (providerType == null || apiKey == null || model == null) {
            this.logger.warn("Bot '" + name + "' has incomplete provider config, skipping");
            return;
        }
        if (providerType.equals("custom")) {
            String providerName = (String)providerConfig.get("name");
            String baseUrl = (String)providerConfig.get("base_url");
            Map headers = (Map)providerConfig.get("headers");
            if (baseUrl == null || baseUrl.isEmpty()) {
                this.logger.warn("Bot '" + name + "' has custom provider but missing base_url");
                return;
            }
            provider = new CustomProvider(this.plugin, providerName, baseUrl, apiKey, model, headers);
        } else {
            switch (providerType.toLowerCase()) {
                case "groq": {
                    AIProvider aIProvider = new GroqProvider(this.plugin, apiKey, model);
                    break;
                }
                case "openai": {
                    AIProvider aIProvider = new OpenAIProvider(this.plugin, apiKey, model);
                    break;
                }
                default: {
                    this.logger.warn("Bot '" + name + "' has unsupported provider type: " + providerType);
                    AIProvider aIProvider = provider = null;
                }
            }
        }
        if (provider == null || !provider.isConfigured()) {
            this.logger.warn("Failed to create provider for bot '" + name + "'");
            return;
        }
        ProviderManager providerManager = new ProviderManager(this.plugin, provider);
        Map rateLimitConfig = (Map)config.get("rate_limit");
        int cooldownSeconds = 3;
        int maxPerMinute = 10;
        if (rateLimitConfig != null) {
            Object maxPerMinuteObj;
            Object cooldownObj = rateLimitConfig.get("cooldown_seconds");
            if (cooldownObj instanceof Number) {
                cooldownSeconds = ((Number)cooldownObj).intValue();
            }
            if ((maxPerMinuteObj = rateLimitConfig.get("max_per_minute")) instanceof Number) {
                maxPerMinute = ((Number)maxPerMinuteObj).intValue();
            }
        }
        BotPersonality bot = new BotPersonality(name, personality, providerManager, systemPrompt, cooldownSeconds, maxPerMinute);
        this.bots.put(name, bot);
        this.logger.info("Loaded bot personality: " + name + " (" + personality + ")");
    }

    private String getDefaultSystemPrompt(String personality) {
        return switch (personality.toLowerCase()) {
            case "helper" -> "You are a concise Minecraft server AI. Keep ALL responses under 15 words. For events/achievements: acknowledge briefly (e.g., 'Nice job!' or 'Congrats!'). No explanations unless asked.";
            case "roleplay" -> "You are a mystical character in a Minecraft fantasy realm. Stay in character, be creative, and enhance the roleplay experience.";
            case "moderator" -> "You are a server moderator assistant. Help enforce rules, answer policy questions, and maintain a positive community.";
            case "companion" -> "You are a friendly companion AI. Be conversational, supportive, and engage in casual chat with players.";
            default -> "You are a concise AI assistant on a Minecraft server. Keep responses under 15 words.";
        };
    }

    public BotPersonality getBot(String name) {
        return this.bots.get(name);
    }

    public BotPersonality getDefaultBot() {
        return this.bots.get(this.defaultBotName);
    }

    public Collection<BotPersonality> getAllBots() {
        return this.bots.values();
    }

    public Set<String> getBotNames() {
        return this.bots.keySet();
    }

    public BotPersonality getPlayerActiveBot(UUID playerUuid) {
        String botName = this.plugin.getDatabaseManager().getPlayerActiveBot(playerUuid);
        BotPersonality bot = this.bots.get(botName);
        return bot != null ? bot : this.getDefaultBot();
    }

    public boolean setPlayerActiveBot(UUID playerUuid, String botName) {
        if (!this.bots.containsKey(botName)) {
            return false;
        }
        this.plugin.getDatabaseManager().setPlayerActiveBot(playerUuid, botName);
        return true;
    }

    public boolean isEnabled() {
        return !this.bots.isEmpty();
    }

    public String getDefaultBotName() {
        return this.defaultBotName;
    }
}

