/*
 * Decompiled with CFR 0.152.
 */
package com.nexvor.features.max;

import com.nexvor.Nexvor;
import com.nexvor.core.NexvorLogger;
import com.nexvor.features.max.DiscordWebhookSender;
import com.nexvor.features.max.models.CommandExecutionResult;
import com.nexvor.features.max.models.CommandValidator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.ServerOperator;

public class AICommandExecutor {
    private final Nexvor plugin;
    private final NexvorLogger logger;
    private static final Pattern COMMAND_PATTERN = Pattern.compile("\\[COMMAND\\]\\s*(.+?)(?:\\n|$)", 2);
    private final List<CommandValidator> validators = new ArrayList<CommandValidator>();
    private final Map<String, List<Long>> commandHistory = new ConcurrentHashMap<String, List<Long>>();

    public AICommandExecutor(Nexvor plugin) {
        this.plugin = plugin;
        this.logger = plugin.getNexvorLogger();
        this.loadValidators();
    }

    private void loadValidators() {
        this.validators.clear();
        if (!this.plugin.getConfig().contains("commands.whitelist")) {
            this.logger.warn("No command whitelist configured - AI command execution disabled");
            return;
        }
        List whitelistConfig = this.plugin.getConfig().getMapList("commands.whitelist");
        for (Map entry : whitelistConfig) {
            try {
                String command = (String)entry.get("command");
                boolean enabled = entry.containsKey("enabled") ? (Boolean)entry.get("enabled") : true;
                String validatorRegex = (String)entry.get("validator");
                String description = entry.containsKey("description") ? (String)entry.get("description") : "";
                ArrayList<String> blacklistItems = new ArrayList();
                if (entry.containsKey("blacklist_items")) {
                    blacklistItems = (List)entry.get("blacklist_items");
                }
                if (!enabled) continue;
                CommandValidator validator = new CommandValidator(command, validatorRegex, description, blacklistItems);
                this.validators.add(validator);
                this.logger.debug("Loaded command validator: " + command);
            }
            catch (Exception e) {
                this.logger.error("Failed to load command validator from config", e);
            }
        }
        this.logger.info("Loaded " + this.validators.size() + " command validators");
    }

    public CommandExecutionResult execute(Player player, String aiResponse) {
        boolean success;
        if (!this.plugin.getConfig().getBoolean("commands.allow_ai_commands", false)) {
            return CommandExecutionResult.disabled();
        }
        Matcher matcher = COMMAND_PATTERN.matcher(aiResponse);
        if (!matcher.find()) {
            return CommandExecutionResult.noCommand();
        }
        String command = matcher.group(1).trim();
        this.logger.info("[AI Command] Detected command request: " + command + " (from " + player.getName() + ")");
        CommandValidator validator = this.findValidator(command);
        if (validator == null) {
            this.logger.warn("[AI Command] REJECTED: Command not in whitelist: " + command);
            return CommandExecutionResult.rejected("Command not in whitelist");
        }
        if (!validator.validate(command)) {
            this.logger.warn("[AI Command] REJECTED: Failed validation: " + command);
            return CommandExecutionResult.rejected("Failed validation pattern");
        }
        if (command.startsWith("/give") && validator.hasBlacklistedItems()) {
            for (String blacklistedItem : validator.getBlacklistItems()) {
                if (!command.toLowerCase().contains(blacklistedItem.toLowerCase())) continue;
                this.logger.warn("[AI Command] REJECTED: Blacklisted item: " + blacklistedItem);
                return CommandExecutionResult.rejected("Blacklisted item: " + blacklistedItem);
            }
        }
        if (!this.rateLimitPassed(player)) {
            int maxPerMinute = this.plugin.getConfig().getInt("commands.max_per_minute", 5);
            this.logger.warn("[AI Command] RATE LIMITED: " + player.getName());
            return CommandExecutionResult.rateLimited("You can only execute " + maxPerMinute + " AI commands per minute");
        }
        String requiredPermission = this.plugin.getConfig().getString("commands.require_permission", "nexvor.admin");
        if (!player.hasPermission(requiredPermission)) {
            this.logger.warn("[AI Command] REJECTED: No permission (" + requiredPermission + "): " + player.getName());
            return CommandExecutionResult.noPermission();
        }
        boolean dryRun = this.plugin.getConfig().getBoolean("commands.dry_run", true);
        if (dryRun) {
            this.logger.info("[AI Command] [DRY RUN] Would execute: " + command);
            this.notifyAdmins(player, command, true);
            this.plugin.getDatabaseManager().logCommand(player.getUniqueId(), player.getName(), command, true, true);
            DiscordWebhookSender webhookSender = this.plugin.getDiscordWebhookSender();
            if (webhookSender != null && webhookSender.isEnabled()) {
                webhookSender.sendCommandAlert(player.getName(), command, true, true);
            }
            return CommandExecutionResult.dryRun(command);
        }
        this.logger.warn("[AI Command] EXECUTING: " + command + " (requested by " + player.getName() + ")");
        try {
            success = Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)(command.startsWith("/") ? command.substring(1) : command));
        }
        catch (Exception e) {
            this.logger.error("[AI Command] Execution failed: " + command, e);
            success = false;
        }
        this.plugin.getDatabaseManager().logCommand(player.getUniqueId(), player.getName(), command, success, false);
        this.notifyAdmins(player, command, false);
        DiscordWebhookSender webhookSender = this.plugin.getDiscordWebhookSender();
        if (webhookSender != null && webhookSender.isEnabled()) {
            webhookSender.sendCommandAlert(player.getName(), command, success, false);
        }
        this.recordCommand(player);
        return success ? CommandExecutionResult.success(command) : CommandExecutionResult.failed(command, "Command execution returned false");
    }

    private CommandValidator findValidator(String command) {
        String commandName = command.split(" ")[0];
        for (CommandValidator validator : this.validators) {
            if (!commandName.equalsIgnoreCase(validator.getCommand())) continue;
            return validator;
        }
        return null;
    }

    private boolean rateLimitPassed(Player player) {
        int maxPerMinute = this.plugin.getConfig().getInt("commands.max_per_minute", 5);
        if (maxPerMinute <= 0) {
            return true;
        }
        long now = System.currentTimeMillis();
        long oneMinuteAgo = now - 60000L;
        List history = this.commandHistory.computeIfAbsent(player.getUniqueId().toString(), k -> new ArrayList());
        history.removeIf(time -> time < oneMinuteAgo);
        return history.size() < maxPerMinute;
    }

    private void recordCommand(Player player) {
        long now = System.currentTimeMillis();
        List history = this.commandHistory.computeIfAbsent(player.getUniqueId().toString(), k -> new ArrayList());
        history.add(now);
    }

    private void notifyAdmins(Player player, String command, boolean dryRun) {
        if (!this.plugin.getConfig().getBoolean("commands.notify_admins", true)) {
            return;
        }
        String prefix = dryRun ? "[DRY RUN] " : "[LIVE] ";
        String message = String.valueOf(ChatColor.GOLD) + "[Nexvor AI Command] " + prefix + String.valueOf(ChatColor.WHITE) + player.getName() + String.valueOf(ChatColor.GRAY) + " \u2192 " + String.valueOf(ChatColor.YELLOW) + command;
        Bukkit.getOnlinePlayers().stream().filter(ServerOperator::isOp).forEach(op -> op.sendMessage(message));
    }

    public String getSystemPromptAddition() {
        if (!this.plugin.getConfig().getBoolean("commands.allow_ai_commands", false)) {
            return "";
        }
        if (this.validators.isEmpty()) {
            return "";
        }
        StringBuilder prompt = new StringBuilder("\n\nIMPORTANT: You have the ability to execute certain Minecraft commands.\n\n");
        prompt.append("Available commands:\n");
        for (CommandValidator validator : this.validators) {
            prompt.append("- ").append(validator.getCommand());
            if (!validator.getDescription().isEmpty()) {
                prompt.append(" - ").append(validator.getDescription());
            }
            prompt.append("\n");
        }
        prompt.append("\nTo execute a command, respond with:\n");
        prompt.append("[COMMAND] /give Steve diamond 5\n\n");
        prompt.append("RULES:\n");
        prompt.append("- Only use commands when explicitly requested by the player\n");
        prompt.append("- Validate player names (must exist on server)\n");
        prompt.append("- /give limited to 1-64 items\n");
        prompt.append("- Never give banned items: bedrock, command_block, barrier, structure_block\n");
        prompt.append("- Explain what you're doing before executing\n");
        return prompt.toString();
    }

    public void cleanup() {
        long oneMinuteAgo = System.currentTimeMillis() - 60000L;
        this.commandHistory.entrySet().removeIf(entry -> {
            ((List)entry.getValue()).removeIf(time -> time < oneMinuteAgo);
            return ((List)entry.getValue()).isEmpty();
        });
    }
}

