/*
 * Decompiled with CFR 0.152.
 */
package com.nexvor.events;

public enum EventType {
    PLAYER_DEATH("player_death", "Player Death", "When a player dies"),
    PLAYER_ACHIEVEMENT("player_achievement", "Player Achievement", "When a player gets an achievement"),
    PLAYER_ADVANCEMENT("player_advancement", "Player Advancement", "When a player completes an advancement"),
    PLAYER_LEVEL_UP("player_level_up", "Player Level Up", "When a player levels up"),
    PLAYER_FIRST_JOIN("player_first_join", "Player First Join", "When a player joins the server for the first time"),
    PLAYER_JOIN("player_join", "Player Join", "When a player joins the server"),
    PLAYER_QUIT("player_quit", "Player Quit", "When a player leaves the server"),
    PLAYER_KILL_PLAYER("player_kill_player", "Player Kill Player", "When a player kills another player (PvP)"),
    PLAYER_KILL_ENTITY("player_kill_entity", "Player Kill Entity", "When a player kills any entity"),
    FISHING_RARE_CATCH("fishing_rare_catch", "Fishing Rare Catch", "When a player catches treasure or rare fish"),
    RAID_TRIGGERED("raid_triggered", "Raid Triggered", "When a raid starts"),
    RAID_COMPLETED("raid_completed", "Raid Completed", "When a raid is completed"),
    BOSS_SPAWNED("boss_spawned", "Boss Spawned", "When Ender Dragon or Wither spawns"),
    BOSS_KILLED("boss_killed", "Boss Killed", "When Ender Dragon or Wither is killed"),
    BLOCK_BREAK_RARE("block_break_rare", "Rare Block Break", "When valuable ore is mined");

    private final String configKey;
    private final String displayName;
    private final String description;

    private EventType(String configKey, String displayName, String description) {
        this.configKey = configKey;
        this.displayName = displayName;
        this.description = description;
    }

    public String getConfigKey() {
        return this.configKey;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public static EventType fromConfigKey(String configKey) {
        for (EventType type : EventType.values()) {
            if (!type.configKey.equalsIgnoreCase(configKey)) continue;
            return type;
        }
        return null;
    }

    public static String[] getAllConfigKeys() {
        EventType[] types = EventType.values();
        String[] keys = new String[types.length];
        for (int i = 0; i < types.length; ++i) {
            keys[i] = types[i].configKey;
        }
        return keys;
    }
}

