/*
 * Decompiled with CFR 0.152.
 */
package com.nexvor.dashboard.routes;

import com.nexvor.Nexvor;
import io.javalin.Javalin;
import io.javalin.http.Context;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;

public class DashboardRoutes {
    private final Nexvor plugin;

    public DashboardRoutes(Nexvor plugin) {
        this.plugin = plugin;
    }

    public void register(Javalin app) {
        app.get("/login", this::serveLogin);
        app.get("/", this::serveDashboard);
        app.get("/js/{filename}", this::serveJS);
        app.get("/css/{filename}", this::serveCSS);
    }

    private void serveLogin(Context ctx) {
        String html = this.loadResource("dashboard/login.html");
        if (html != null) {
            ctx.html(html);
        } else {
            ctx.status(500).result("Failed to load login page");
        }
    }

    private void serveDashboard(Context ctx) {
        String html = this.loadResource("dashboard/index.html");
        if (html != null) {
            ctx.html(html);
        } else {
            ctx.status(500).result("Failed to load dashboard");
        }
    }

    private void serveJS(Context ctx) {
        String filename = ctx.pathParam("filename");
        String js = this.loadResource("dashboard/js/" + filename);
        if (js != null) {
            ctx.contentType("application/javascript").result(js);
        } else {
            ctx.status(404).result("Not found");
        }
    }

    private void serveCSS(Context ctx) {
        String filename = ctx.pathParam("filename");
        String css = this.loadResource("dashboard/css/" + filename);
        if (css != null) {
            ctx.contentType("text/css").result(css);
        } else {
            ctx.status(404).result("Not found");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String loadResource(String path) {
        try (InputStream in = this.plugin.getResource(path);){
            if (in == null) return null;
            String string = new String(in.readAllBytes(), StandardCharsets.UTF_8);
            return string;
        }
        catch (Exception e) {
            this.plugin.getNexvorLogger().error("Failed to load resource: " + path, e);
        }
        return null;
    }
}

