/*
 * Decompiled with CFR 0.152.
 */
package com.nexvor.dashboard.routes;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.nexvor.Nexvor;
import com.nexvor.dashboard.auth.AuthenticationManager;
import com.nexvor.dashboard.models.DashboardSession;
import io.javalin.Javalin;
import io.javalin.http.Context;

public class AuthRoutes {
    private final Nexvor plugin;
    private final AuthenticationManager authManager;
    private final Gson gson;

    public AuthRoutes(Nexvor plugin, AuthenticationManager authManager) {
        this.plugin = plugin;
        this.authManager = authManager;
        this.gson = new Gson();
    }

    public void register(Javalin app) {
        app.post("/auth/login", this::handleLogin);
        app.post("/auth/logout", this::handleLogout);
        app.get("/auth/validate", this::handleValidate);
    }

    private void handleLogin(Context ctx) {
        JsonObject json = this.gson.fromJson(ctx.body(), JsonObject.class);
        String type = json.has("type") ? json.get("type").getAsString() : null;
        DashboardSession session = null;
        if ("access_code".equals(type)) {
            String code = json.get("code").getAsString();
            session = this.authManager.loginWithAccessCode(code);
        } else if ("admin".equals(type)) {
            username = json.get("username").getAsString();
            String password = json.get("password").getAsString();
            session = this.authManager.loginWithAdmin(username, password);
        } else if ("credentials".equals(type)) {
            username = json.get("username").getAsString();
            String password = json.get("password").getAsString();
            session = this.authManager.loginWithCredentials(username, password);
        }
        if (session != null) {
            response = new JsonObject();
            response.addProperty("success", true);
            response.addProperty("session_token", session.getSessionToken());
            response.addProperty("username", session.getUserName());
            response.addProperty("is_admin", session.isAdmin());
            response.addProperty("expires_at", session.getExpiresAt());
            ctx.json(response.toString());
        } else {
            response = new JsonObject();
            response.addProperty("success", false);
            response.addProperty("message", "Invalid credentials");
            ctx.status(401).json(response.toString());
        }
    }

    private void handleLogout(Context ctx) {
        JsonObject response = new JsonObject();
        response.addProperty("success", true);
        response.addProperty("message", "Logged out successfully");
        ctx.json(response.toString());
    }

    private void handleValidate(Context ctx) {
        DashboardSession session;
        String sessionToken = ctx.header("Authorization");
        if (sessionToken != null && sessionToken.startsWith("Bearer ")) {
            sessionToken = sessionToken.substring(7);
        }
        if ((session = this.authManager.validateSession(sessionToken)) != null) {
            JsonObject response = new JsonObject();
            response.addProperty("valid", true);
            response.addProperty("username", session.getUserName());
            response.addProperty("is_admin", session.isAdmin());
            response.addProperty("expires_at", session.getExpiresAt());
            ctx.json(response.toString());
        } else {
            JsonObject response = new JsonObject();
            response.addProperty("valid", false);
            response.addProperty("message", "Invalid or expired session");
            ctx.status(401).json(response.toString());
        }
    }
}

