/*
 * Decompiled with CFR 0.152.
 */
package com.nexvor.dashboard.models;

public class DashboardSession {
    private final String id;
    private final String userUuid;
    private final String userName;
    private final String sessionToken;
    private final long createdAt;
    private final long expiresAt;
    private long lastActive;
    private final boolean isAdmin;

    public DashboardSession(String id, String userUuid, String userName, String sessionToken, long expiresAt, boolean isAdmin) {
        this.id = id;
        this.userUuid = userUuid;
        this.userName = userName;
        this.sessionToken = sessionToken;
        this.createdAt = System.currentTimeMillis();
        this.expiresAt = expiresAt;
        this.lastActive = this.createdAt;
        this.isAdmin = isAdmin;
    }

    public DashboardSession(String id, String userUuid, String userName, String sessionToken, long createdAt, long expiresAt, long lastActive, boolean isAdmin) {
        this.id = id;
        this.userUuid = userUuid;
        this.userName = userName;
        this.sessionToken = sessionToken;
        this.createdAt = createdAt;
        this.expiresAt = expiresAt;
        this.lastActive = lastActive;
        this.isAdmin = isAdmin;
    }

    public String getId() {
        return this.id;
    }

    public String getUserUuid() {
        return this.userUuid;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getSessionToken() {
        return this.sessionToken;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public long getExpiresAt() {
        return this.expiresAt;
    }

    public long getLastActive() {
        return this.lastActive;
    }

    public boolean isAdmin() {
        return this.isAdmin;
    }

    public void updateLastActive() {
        this.lastActive = System.currentTimeMillis();
    }

    public boolean isExpired() {
        return System.currentTimeMillis() > this.expiresAt;
    }

    public boolean isValid() {
        return !this.isExpired();
    }
}

