/*
 * Decompiled with CFR 0.152.
 */
package com.nexvor.dashboard.models;

public class AccessCode {
    private final String code;
    private final String playerUuid;
    private final String playerName;
    private final long createdAt;
    private final long expiresAt;
    private boolean used;

    public AccessCode(String code, String playerUuid, String playerName, long expiresAt) {
        this.code = code;
        this.playerUuid = playerUuid;
        this.playerName = playerName;
        this.createdAt = System.currentTimeMillis();
        this.expiresAt = expiresAt;
        this.used = false;
    }

    public AccessCode(String code, String playerUuid, String playerName, long createdAt, long expiresAt, boolean used) {
        this.code = code;
        this.playerUuid = playerUuid;
        this.playerName = playerName;
        this.createdAt = createdAt;
        this.expiresAt = expiresAt;
        this.used = used;
    }

    public String getCode() {
        return this.code;
    }

    public String getPlayerUuid() {
        return this.playerUuid;
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public long getExpiresAt() {
        return this.expiresAt;
    }

    public boolean isUsed() {
        return this.used;
    }

    public void markUsed() {
        this.used = true;
    }

    public boolean isExpired() {
        return System.currentTimeMillis() > this.expiresAt;
    }

    public boolean isValid() {
        return !this.used && !this.isExpired();
    }
}

