/*
 * Decompiled with CFR 0.152.
 */
package com.nexvor.dashboard.models;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class APIToken {
    private final String token;
    private final String playerUuid;
    private final String playerName;
    private final String purpose;
    private final Set<String> scopes;
    private final long createdAt;
    private Long lastUsed;
    private boolean revoked;

    public APIToken(String token, String playerUuid, String playerName, String purpose, Set<String> scopes) {
        this.token = token;
        this.playerUuid = playerUuid;
        this.playerName = playerName;
        this.purpose = purpose;
        this.scopes = scopes != null ? scopes : new HashSet();
        this.createdAt = System.currentTimeMillis();
        this.lastUsed = null;
        this.revoked = false;
    }

    public APIToken(String token, String playerUuid, String playerName, String purpose, String scopesString, long createdAt, Long lastUsed, boolean revoked) {
        this.token = token;
        this.playerUuid = playerUuid;
        this.playerName = playerName;
        this.purpose = purpose;
        this.scopes = APIToken.parseScopesString(scopesString);
        this.createdAt = createdAt;
        this.lastUsed = lastUsed;
        this.revoked = revoked;
    }

    public String getToken() {
        return this.token;
    }

    public String getPlayerUuid() {
        return this.playerUuid;
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public String getPurpose() {
        return this.purpose;
    }

    public Set<String> getScopes() {
        return new HashSet<String>(this.scopes);
    }

    public String getScopesString() {
        return String.join((CharSequence)",", this.scopes);
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public Long getLastUsed() {
        return this.lastUsed;
    }

    public boolean isRevoked() {
        return this.revoked;
    }

    public void markUsed() {
        this.lastUsed = System.currentTimeMillis();
    }

    public void revoke() {
        this.revoked = true;
    }

    public boolean hasScope(String scope) {
        return this.scopes.contains(scope) || this.scopes.contains("admin");
    }

    public boolean isValid() {
        return !this.revoked;
    }

    private static Set<String> parseScopesString(String scopesString) {
        if (scopesString == null || scopesString.isEmpty()) {
            return new HashSet<String>();
        }
        return new HashSet<String>(Arrays.asList(scopesString.split(",")));
    }
}

