/*
 * Decompiled with CFR 0.152.
 */
package com.nexvor.dashboard.auth;

import com.nexvor.Nexvor;
import com.nexvor.core.NexvorLogger;
import com.nexvor.dashboard.models.AccessCode;
import com.nexvor.memory.DatabaseManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Random;
import java.util.UUID;

public class AccessCodeGenerator {
    private final Nexvor plugin;
    private final NexvorLogger logger;
    private final DatabaseManager databaseManager;
    private final int expirationSeconds;
    private final Random random;

    public AccessCodeGenerator(Nexvor plugin) {
        this.plugin = plugin;
        this.logger = plugin.getNexvorLogger();
        this.databaseManager = plugin.getDatabaseManager();
        this.expirationSeconds = plugin.getConfig().getInt("dashboard.auth.access_codes.expiration_seconds", 300);
        this.random = new Random();
    }

    public AccessCode generate(UUID playerUuid, String playerName) {
        String code = this.generateRandomCode();
        long expiresAt = System.currentTimeMillis() + (long)this.expirationSeconds * 1000L;
        AccessCode accessCode = new AccessCode(code, playerUuid.toString(), playerName, expiresAt);
        try {
            String sql = "INSERT INTO access_codes (code, player_uuid, player_name, created_at, expires_at, used) VALUES (?, ?, ?, ?, ?, 0)";
            try (PreparedStatement stmt = this.databaseManager.getConnection().prepareStatement(sql);){
                stmt.setString(1, code);
                stmt.setString(2, playerUuid.toString());
                stmt.setString(3, playerName);
                stmt.setLong(4, accessCode.getCreatedAt());
                stmt.setLong(5, expiresAt);
                stmt.executeUpdate();
            }
            this.logger.debug("Generated access code for " + playerName + ": " + code);
            return accessCode;
        }
        catch (SQLException e) {
            this.logger.error("Failed to save access code", e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AccessCode validate(String code) {
        try {
            String sql = "SELECT * FROM access_codes WHERE code = ?";
            try (PreparedStatement stmt = this.databaseManager.getConnection().prepareStatement(sql);){
                stmt.setString(1, code);
                ResultSet rs = stmt.executeQuery();
                if (!rs.next()) return null;
                AccessCode accessCode = new AccessCode(rs.getString("code"), rs.getString("player_uuid"), rs.getString("player_name"), rs.getLong("created_at"), rs.getLong("expires_at"), rs.getInt("used") == 1);
                if (!accessCode.isValid()) {
                    this.logger.debug("Access code invalid: " + code + " (expired=" + accessCode.isExpired() + ", used=" + accessCode.isUsed() + ")");
                    AccessCode accessCode2 = null;
                    return accessCode2;
                }
                this.markUsed(code);
                this.logger.info("Access code validated for " + accessCode.getPlayerName());
                AccessCode accessCode3 = accessCode;
                return accessCode3;
            }
        }
        catch (SQLException e) {
            this.logger.error("Failed to validate access code", e);
        }
        return null;
    }

    private void markUsed(String code) throws SQLException {
        String sql = "UPDATE access_codes SET used = 1 WHERE code = ?";
        try (PreparedStatement stmt = this.databaseManager.getConnection().prepareStatement(sql);){
            stmt.setString(1, code);
            stmt.executeUpdate();
        }
    }

    public void cleanup() {
        try {
            long now = System.currentTimeMillis();
            String sql = "DELETE FROM access_codes WHERE expires_at < ?";
            try (PreparedStatement stmt = this.databaseManager.getConnection().prepareStatement(sql);){
                stmt.setLong(1, now);
                int deleted = stmt.executeUpdate();
                if (deleted > 0) {
                    this.logger.debug("Cleaned up " + deleted + " expired access codes");
                }
            }
        }
        catch (SQLException e) {
            this.logger.error("Failed to clean up access codes", e);
        }
    }

    private String generateRandomCode() {
        String letters1 = this.randomLetters(3);
        String numbers = this.randomNumbers(3);
        String letters2 = this.randomLetters(3);
        return letters1 + "-" + numbers + "-" + letters2;
    }

    private String randomLetters(int length) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            sb.append((char)(65 + this.random.nextInt(26)));
        }
        return sb.toString();
    }

    private String randomNumbers(int length) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            sb.append(this.random.nextInt(10));
        }
        return sb.toString();
    }
}

