/*
 * Decompiled with CFR 0.152.
 */
package com.nexvor.dashboard.auth;

import com.nexvor.Nexvor;
import com.nexvor.core.NexvorLogger;
import com.nexvor.dashboard.models.APIToken;
import com.nexvor.memory.DatabaseManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;

public class APITokenManager {
    private final Nexvor plugin;
    private final NexvorLogger logger;
    private final DatabaseManager databaseManager;

    public APITokenManager(Nexvor plugin) {
        this.plugin = plugin;
        this.logger = plugin.getNexvorLogger();
        this.databaseManager = plugin.getDatabaseManager();
    }

    public APIToken createToken(UUID playerUuid, String playerName, String purpose, Set<String> scopes) {
        String token = this.generateToken();
        APIToken apiToken = new APIToken(token, playerUuid.toString(), playerName, purpose, scopes);
        try {
            String sql = "INSERT INTO api_tokens (token, player_uuid, player_name, purpose, scopes, created_at, last_used, revoked) VALUES (?, ?, ?, ?, ?, ?, ?, 0)";
            try (PreparedStatement stmt = this.databaseManager.getConnection().prepareStatement(sql);){
                stmt.setString(1, token);
                stmt.setString(2, playerUuid.toString());
                stmt.setString(3, playerName);
                stmt.setString(4, purpose);
                stmt.setString(5, apiToken.getScopesString());
                stmt.setLong(6, apiToken.getCreatedAt());
                stmt.setObject(7, null);
                stmt.executeUpdate();
            }
            this.logger.info("Created API token for " + playerName + " (purpose: " + purpose + ", scopes: " + apiToken.getScopesString() + ")");
            return apiToken;
        }
        catch (SQLException e) {
            this.logger.error("Failed to create API token", e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public APIToken validateToken(String token) {
        try {
            String sql = "SELECT * FROM api_tokens WHERE token = ?";
            try (PreparedStatement stmt = this.databaseManager.getConnection().prepareStatement(sql);){
                stmt.setString(1, token);
                ResultSet rs = stmt.executeQuery();
                if (!rs.next()) return null;
                APIToken apiToken = new APIToken(rs.getString("token"), rs.getString("player_uuid"), rs.getString("player_name"), rs.getString("purpose"), rs.getString("scopes"), rs.getLong("created_at"), rs.getObject("last_used") != null ? Long.valueOf(rs.getLong("last_used")) : null, rs.getInt("revoked") == 1);
                if (!apiToken.isValid()) {
                    APIToken aPIToken = null;
                    return aPIToken;
                }
                this.updateLastUsed(token);
                APIToken aPIToken = apiToken;
                return aPIToken;
            }
        }
        catch (SQLException e) {
            this.logger.error("Failed to validate API token", e);
        }
        return null;
    }

    public List<APIToken> getTokens(UUID playerUuid) {
        ArrayList<APIToken> tokens = new ArrayList<APIToken>();
        try {
            String sql = "SELECT * FROM api_tokens WHERE player_uuid = ? ORDER BY created_at DESC";
            try (PreparedStatement stmt = this.databaseManager.getConnection().prepareStatement(sql);){
                stmt.setString(1, playerUuid.toString());
                ResultSet rs = stmt.executeQuery();
                while (rs.next()) {
                    tokens.add(new APIToken(rs.getString("token"), rs.getString("player_uuid"), rs.getString("player_name"), rs.getString("purpose"), rs.getString("scopes"), rs.getLong("created_at"), rs.getObject("last_used") != null ? Long.valueOf(rs.getLong("last_used")) : null, rs.getInt("revoked") == 1));
                }
            }
        }
        catch (SQLException e) {
            this.logger.error("Failed to get API tokens", e);
        }
        return tokens;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean revokeToken(String token) {
        try {
            String sql = "UPDATE api_tokens SET revoked = 1 WHERE token = ?";
            try (PreparedStatement stmt = this.databaseManager.getConnection().prepareStatement(sql);){
                stmt.setString(1, token);
                int updated = stmt.executeUpdate();
                if (updated <= 0) return false;
                this.logger.info("Revoked API token: " + token);
                boolean bl = true;
                return bl;
            }
        }
        catch (SQLException e) {
            this.logger.error("Failed to revoke API token", e);
        }
        return false;
    }

    public void logTokenUsage(String token, String endpoint, String method2, boolean success) {
        try {
            String sql = "INSERT INTO api_token_logs (token, endpoint, method, success, timestamp) VALUES (?, ?, ?, ?, ?)";
            try (PreparedStatement stmt = this.databaseManager.getConnection().prepareStatement(sql);){
                stmt.setString(1, token);
                stmt.setString(2, endpoint);
                stmt.setString(3, method2);
                stmt.setInt(4, success ? 1 : 0);
                stmt.setLong(5, System.currentTimeMillis());
                stmt.executeUpdate();
            }
        }
        catch (SQLException e) {
            this.logger.error("Failed to log API token usage", e);
        }
    }

    private void updateLastUsed(String token) {
        try {
            String sql = "UPDATE api_tokens SET last_used = ? WHERE token = ?";
            try (PreparedStatement stmt = this.databaseManager.getConnection().prepareStatement(sql);){
                stmt.setLong(1, System.currentTimeMillis());
                stmt.setString(2, token);
                stmt.executeUpdate();
            }
        }
        catch (SQLException e) {
            this.logger.error("Failed to update API token last used", e);
        }
    }

    private String generateToken() {
        return "nvr_" + UUID.randomUUID().toString().replace("-", "");
    }
}

