/*
 * Decompiled with CFR 0.152.
 */
package com.nexvor.dashboard;

import com.nexvor.Nexvor;
import com.nexvor.core.NexvorLogger;
import com.nexvor.dashboard.auth.AuthenticationManager;
import com.nexvor.dashboard.routes.APIRoutes;
import com.nexvor.dashboard.routes.AuthRoutes;
import com.nexvor.dashboard.routes.DashboardRoutes;
import io.javalin.Javalin;
import io.javalin.http.staticfiles.Location;
import java.net.InetAddress;

public class DashboardServer {
    private final Nexvor plugin;
    private final NexvorLogger logger;
    private final AuthenticationManager authManager;
    private Javalin app;
    private final int port;
    private final String host;

    public DashboardServer(Nexvor plugin, AuthenticationManager authManager) {
        this.plugin = plugin;
        this.logger = plugin.getNexvorLogger();
        this.authManager = authManager;
        this.port = plugin.getConfig().getInt("dashboard.server.port", 8080);
        this.host = plugin.getConfig().getString("dashboard.server.host", "0.0.0.0");
    }

    public void start() {
        try {
            this.app = Javalin.create(config -> {
                if (this.plugin.getConfig().getBoolean("dashboard.security.cors_enabled", true)) {
                    config.plugins.enableCors(cors -> cors.add(it -> it.anyHost()));
                }
                config.showJavalinBanner = false;
                config.staticFiles.add("/dashboard", Location.CLASSPATH);
            }).start(this.host, this.port);
            this.app.exception(Exception.class, (e, ctx) -> {
                this.logger.error("Dashboard error: " + e.getMessage(), e);
                ctx.status(500).result("Internal server error");
            });
            new AuthRoutes(this.plugin, this.authManager).register(this.app);
            new APIRoutes(this.plugin, this.authManager).register(this.app);
            new DashboardRoutes(this.plugin).register(this.app);
            this.logger.info("Dashboard server started on http://" + this.host + ":" + this.port);
            this.logger.info("Access dashboard at: http://" + this.getServerIP() + ":" + this.port);
        }
        catch (Exception e2) {
            this.logger.error("Failed to start dashboard server", e2);
            throw new RuntimeException("Dashboard server failed to start", e2);
        }
    }

    public void stop() {
        if (this.app != null) {
            this.app.stop();
            this.logger.info("Dashboard server stopped");
        }
    }

    private String getServerIP() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception e) {
            return "YOUR_SERVER_IP";
        }
    }

    public String getDashboardURL() {
        return "http://" + this.getServerIP() + ":" + this.port;
    }

    public boolean isRunning() {
        return this.app != null;
    }
}

