/*
 * Decompiled with CFR 0.152.
 */
package com.nexvor.dashboard;

import com.nexvor.Nexvor;
import com.nexvor.core.NexvorLogger;
import com.nexvor.dashboard.DashboardServer;
import com.nexvor.dashboard.auth.APITokenManager;
import com.nexvor.dashboard.auth.AuthenticationManager;
import java.util.UUID;
import org.bukkit.plugin.Plugin;

public class DashboardManager {
    private final Nexvor plugin;
    private final NexvorLogger logger;
    private AuthenticationManager authManager;
    private APITokenManager tokenManager;
    private DashboardServer server;
    private boolean enabled;

    public DashboardManager(Nexvor plugin) {
        this.plugin = plugin;
        this.logger = plugin.getNexvorLogger();
        this.enabled = plugin.getConfig().getBoolean("dashboard.enabled", false);
    }

    public void initialize() {
        if (!this.enabled) {
            this.logger.info("Dashboard disabled in config");
            return;
        }
        try {
            this.authManager = new AuthenticationManager(this.plugin);
            this.logger.debug("Dashboard authentication manager initialized");
            this.tokenManager = new APITokenManager(this.plugin);
            this.logger.debug("Dashboard API token manager initialized");
            this.ensureAdminPassword();
            this.server = new DashboardServer(this.plugin, this.authManager);
            this.server.start();
            this.startCleanupTask();
            this.logger.info("[MAX] Dashboard initialized successfully");
            this.logger.info("[MAX] Dashboard URL: " + this.server.getDashboardURL());
        }
        catch (Exception e) {
            this.logger.error("Failed to initialize dashboard", e);
            this.enabled = false;
        }
    }

    public void shutdown() {
        if (this.server != null) {
            this.server.stop();
        }
    }

    private void ensureAdminPassword() {
        if (!this.plugin.getConfig().getBoolean("dashboard.auth.admin_enabled", true)) {
            return;
        }
        String password = this.plugin.getConfig().getString("dashboard.auth.admin_password");
        if (password == null || password.isEmpty() || password.equals("auto_generated_on_first_start")) {
            String generatedPassword = UUID.randomUUID().toString().substring(0, 16);
            this.logger.warn("========================================");
            this.logger.warn("DASHBOARD ADMIN PASSWORD NOT SET!");
            this.logger.warn("Auto-generated password: " + generatedPassword);
            this.logger.warn("Please set 'dashboard.auth.admin_password' in config.yml");
            this.logger.warn("========================================");
        }
    }

    private void startCleanupTask() {
        int cleanupInterval = this.plugin.getConfig().getInt("dashboard.sessions.cleanup_interval", 300);
        this.plugin.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, () -> {
            if (this.authManager != null) {
                this.authManager.cleanupSessions();
                this.authManager.getAccessCodeGenerator().cleanup();
            }
        }, 6000L, (long)cleanupInterval * 20L);
    }

    public AuthenticationManager getAuthManager() {
        return this.authManager;
    }

    public APITokenManager getTokenManager() {
        return this.tokenManager;
    }

    public DashboardServer getServer() {
        return this.server;
    }

    public boolean isEnabled() {
        return this.enabled && this.server != null && this.server.isRunning();
    }
}

