/*
 * Decompiled with CFR 0.152.
 */
package com.nexvor.core;

import com.nexvor.Nexvor;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Properties;
import java.util.UUID;
import org.bukkit.Bukkit;

public class ServerInfo {
    private final Nexvor plugin;
    private final File serverIdFile;
    private String serverUuid;

    public ServerInfo(Nexvor plugin) {
        this.plugin = plugin;
        this.serverIdFile = new File(plugin.getDataFolder(), "server.properties");
    }

    public void initialize() {
        this.loadOrGenerateUuid();
    }

    private void loadOrGenerateUuid() {
        if (this.serverIdFile.exists()) {
            try {
                Properties props = new Properties();
                try (FileReader reader = new FileReader(this.serverIdFile);){
                    props.load(reader);
                }
                this.serverUuid = props.getProperty("server-uuid");
                if (this.serverUuid != null && !this.serverUuid.isEmpty()) {
                    try {
                        UUID.fromString(this.serverUuid);
                        this.plugin.getNexvorLogger().debug("Loaded server UUID: " + this.serverUuid);
                        return;
                    }
                    catch (IllegalArgumentException e) {
                        this.plugin.getNexvorLogger().warn("Invalid server UUID format, generating new one");
                    }
                }
            }
            catch (IOException e) {
                this.plugin.getNexvorLogger().warn("Failed to load server UUID: " + e.getMessage());
            }
        }
        this.generateAndSaveUuid();
    }

    private void generateAndSaveUuid() {
        this.serverUuid = UUID.randomUUID().toString();
        try {
            if (!this.plugin.getDataFolder().exists()) {
                this.plugin.getDataFolder().mkdirs();
            }
            Properties props = new Properties();
            props.setProperty("server-uuid", this.serverUuid);
            props.setProperty("generated-at", String.valueOf(System.currentTimeMillis()));
            try (FileWriter writer = new FileWriter(this.serverIdFile);){
                props.store(writer, "Nexvor Server Identification - DO NOT DELETE");
            }
            this.plugin.getNexvorLogger().info("Generated new server UUID: " + this.serverUuid);
        }
        catch (IOException e) {
            this.plugin.getNexvorLogger().error("Failed to save server UUID", e);
        }
    }

    public String getServerUuid() {
        return this.serverUuid;
    }

    public String getServerName() {
        try {
            String name = Bukkit.getServer().getName();
            if (name != null && !name.isEmpty()) {
                return name;
            }
        }
        catch (Exception e) {
            this.plugin.getNexvorLogger().debug("Failed to get server name: " + e.getMessage());
        }
        return "Unknown Server";
    }

    public String getServerIp() {
        try {
            String ip2 = Bukkit.getServer().getIp();
            int port = Bukkit.getServer().getPort();
            if (ip2 != null && !ip2.isEmpty()) {
                return ip2 + ":" + port;
            }
        }
        catch (Exception e) {
            this.plugin.getNexvorLogger().debug("Failed to get server IP: " + e.getMessage());
        }
        return null;
    }

    public String getMinecraftVersion() {
        try {
            return Bukkit.getServer().getVersion();
        }
        catch (Exception e) {
            this.plugin.getNexvorLogger().debug("Failed to get Minecraft version: " + e.getMessage());
            return null;
        }
    }

    public String getBukkitVersion() {
        try {
            return Bukkit.getServer().getBukkitVersion();
        }
        catch (Exception e) {
            this.plugin.getNexvorLogger().debug("Failed to get Bukkit version: " + e.getMessage());
            return null;
        }
    }
}

