/*
 * Decompiled with CFR 0.152.
 */
package com.nexvor.commands.subcommands;

import com.nexvor.Nexvor;
import com.nexvor.commands.BaseCommand;
import com.nexvor.memory.ConversationManager;
import com.nexvor.memory.models.Conversation;
import com.nexvor.memory.models.PlayerData;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class PrivacyCommand
extends BaseCommand {
    public PrivacyCommand(Nexvor plugin) {
        super(plugin);
    }

    @Override
    public boolean execute(CommandSender sender, String[] args2) {
        if (!(sender instanceof Player)) {
            this.sendError(sender, "This command can only be used by players!");
            return true;
        }
        Player player = (Player)sender;
        if (args2.length > 0) {
            String subcommand;
            switch (subcommand = args2[0].toLowerCase()) {
                case "view": {
                    int page = 1;
                    if (args2.length > 1) {
                        try {
                            page = Integer.parseInt(args2[1]);
                        }
                        catch (NumberFormatException e) {
                            this.sendError(sender, "Invalid page number: " + args2[1]);
                            return true;
                        }
                    }
                    return this.viewData(player, page);
                }
                case "opt-out": 
                case "optout": {
                    return this.toggleOptOut(player);
                }
                case "delete": {
                    return this.deleteData(player);
                }
            }
            this.sendError(sender, "Unknown subcommand: " + args2[0]);
            return this.showUsage(sender);
        }
        return this.showPrivacyInfo(player);
    }

    private boolean showPrivacyInfo(Player player) {
        ConversationManager conversationManager = this.plugin.getConversationManager();
        UUID playerUuid = player.getUniqueId();
        this.sendMessage((CommandSender)player, "\u00a77========================================");
        this.sendMessage((CommandSender)player, "\u00a7b\u00a7lNexvor Privacy Information");
        this.sendMessage((CommandSender)player, "\u00a77========================================");
        this.sendMessage((CommandSender)player, "");
        this.sendMessage((CommandSender)player, "\u00a77Data Collection:");
        this.sendMessage((CommandSender)player, "  \u00a7f\u2022 Conversation history (stored locally on this server)");
        this.sendMessage((CommandSender)player, "  \u00a7f\u2022 Player UUID and username");
        this.sendMessage((CommandSender)player, "  \u00a7f\u2022 First seen and last seen timestamps");
        this.sendMessage((CommandSender)player, "");
        this.sendMessage((CommandSender)player, "\u00a77Your Current Status:");
        if (conversationManager.isOptedOut(playerUuid)) {
            this.sendMessage((CommandSender)player, "  \u00a7e\u2022 You are OPTED OUT");
            this.sendMessage((CommandSender)player, "  \u00a77  (AI chat is disabled for you)");
        } else {
            this.sendMessage((CommandSender)player, "  \u00a7a\u2022 You are opted in");
            this.sendMessage((CommandSender)player, "  \u00a77  (AI chat is enabled)");
        }
        int messageCount = conversationManager.getMessageCount(playerUuid);
        this.sendMessage((CommandSender)player, "  \u00a7f\u2022 Messages stored: \u00a7b" + messageCount);
        this.sendMessage((CommandSender)player, "");
        this.sendMessage((CommandSender)player, "\u00a77Your Rights (GDPR Compliant):");
        this.sendMessage((CommandSender)player, "  \u00a7f\u2022 View your data: \u00a7b/nexvor privacy view");
        this.sendMessage((CommandSender)player, "  \u00a7f\u2022 Delete your data: \u00a7b/nexvor privacy delete");
        this.sendMessage((CommandSender)player, "  \u00a7f\u2022 Opt-out of AI chat: \u00a7b/nexvor privacy opt-out");
        this.sendMessage((CommandSender)player, "");
        this.sendMessage((CommandSender)player, "\u00a77Data Storage & Security:");
        this.sendMessage((CommandSender)player, "  \u00a7f\u2022 All data stored locally on this server");
        this.sendMessage((CommandSender)player, "  \u00a7f\u2022 Never shared with third parties");
        this.sendMessage((CommandSender)player, "  \u00a7f\u2022 AI provider: \u00a7b" + this.plugin.getConfigManager().getApiProvider());
        this.sendMessage((CommandSender)player, "  \u00a77  (Your messages are sent to " + this.plugin.getConfigManager().getApiProvider() + " for AI processing)");
        this.sendMessage((CommandSender)player, "");
        this.showTelemetryInfo(player);
        this.sendMessage((CommandSender)player, "");
        this.sendMessage((CommandSender)player, "\u00a77========================================");
        return true;
    }

    private void showTelemetryInfo(Player player) {
        boolean telemetryEnabled = this.plugin.getConfigManager().isTelemetryEnabled();
        boolean sendToDev = this.plugin.getConfig().getBoolean("telemetry.send_to_developer", false);
        this.sendMessage((CommandSender)player, "\u00a77Telemetry Settings:");
        if (telemetryEnabled) {
            this.sendMessage((CommandSender)player, "  \u00a7e\u2022 Telemetry is ENABLED on this server");
            if (sendToDev) {
                this.sendMessage((CommandSender)player, "  \u00a7e\u2022 Data is sent to developer (server admin opted in)");
                this.sendMessage((CommandSender)player, "");
                this.sendMessage((CommandSender)player, "  \u00a77What may be sent:");
                this.sendMessage((CommandSender)player, "    \u00a7f\u2022 Anonymous usage statistics");
                this.sendMessage((CommandSender)player, "    \u00a7f\u2022 Error reports (crash logs)");
                this.sendMessage((CommandSender)player, "");
                this.sendMessage((CommandSender)player, "  \u00a77What is NEVER sent:");
                this.sendMessage((CommandSender)player, "    \u00a7a\u2022 API keys or secrets");
                this.sendMessage((CommandSender)player, "    \u00a7a\u2022 Player passwords or sensitive data");
                this.sendMessage((CommandSender)player, "    \u00a7a\u2022 Your personal information");
            } else {
                this.sendMessage((CommandSender)player, "  \u00a7a\u2022 Data is kept locally only (not sent to developer)");
                this.sendMessage((CommandSender)player, "  \u00a77  Server admin can enable sending in config.yml");
            }
        } else {
            this.sendMessage((CommandSender)player, "  \u00a7a\u2022 Telemetry is DISABLED on this server");
            this.sendMessage((CommandSender)player, "  \u00a77  No usage data is collected");
        }
    }

    private boolean viewData(Player player, int page) {
        ConversationManager conversationManager = this.plugin.getConversationManager();
        UUID playerUuid = player.getUniqueId();
        this.sendMessage((CommandSender)player, "\u00a77========================================");
        this.sendMessage((CommandSender)player, "\u00a7b\u00a7lYour Stored Data");
        this.sendMessage((CommandSender)player, "\u00a77========================================");
        this.sendMessage((CommandSender)player, "");
        PlayerData playerData = conversationManager.getPlayerData(playerUuid, player.getName());
        if (playerData == null) {
            this.sendMessage((CommandSender)player, "\u00a77No data found for your account.");
            return true;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.sendMessage((CommandSender)player, "\u00a77Player Information:");
        this.sendMessage((CommandSender)player, "  \u00a7f\u2022 UUID: \u00a7b" + String.valueOf(playerData.getUuid()));
        this.sendMessage((CommandSender)player, "  \u00a7f\u2022 Username: \u00a7b" + playerData.getUsername());
        this.sendMessage((CommandSender)player, "  \u00a7f\u2022 First seen: \u00a7b" + dateFormat.format(new Date(playerData.getFirstSeen())));
        this.sendMessage((CommandSender)player, "  \u00a7f\u2022 Last seen: \u00a7b" + dateFormat.format(new Date(playerData.getLastSeen())));
        this.sendMessage((CommandSender)player, "  \u00a7f\u2022 Opted out: \u00a7b" + (playerData.isOptedOut() ? "Yes" : "No"));
        this.sendMessage((CommandSender)player, "");
        int messageCount = conversationManager.getMessageCount(playerUuid);
        this.sendMessage((CommandSender)player, "\u00a77Conversation History:");
        this.sendMessage((CommandSender)player, "  \u00a7f\u2022 Total messages: \u00a7b" + messageCount);
        if (messageCount > 0) {
            int messagesPerPage = 10;
            int totalPages = (int)Math.ceil((double)messageCount / (double)messagesPerPage);
            if (page < 1) {
                page = 1;
            } else if (page > totalPages) {
                page = totalPages;
            }
            int offset = (page - 1) * messagesPerPage;
            this.sendMessage((CommandSender)player, "  \u00a7f\u2022 Page \u00a7b" + page + "\u00a7f/\u00a7b" + totalPages + " \u00a77(showing " + messagesPerPage + " per page)");
            this.sendMessage((CommandSender)player, "");
            List<Conversation> allMessages = this.plugin.getDatabaseManager().getConversationHistory(playerUuid, messageCount);
            int startIndex = Math.max(0, allMessages.size() - offset - messagesPerPage);
            int endIndex = Math.max(0, allMessages.size() - offset);
            if (startIndex < endIndex) {
                List<Conversation> pageMessages = allMessages.subList(startIndex, endIndex);
                for (int i = 0; i < pageMessages.size(); ++i) {
                    Conversation msg = pageMessages.get(i);
                    String roleColor = msg.getRole().equals("user") ? "\u00a7a" : "\u00a7b";
                    String roleLabel = msg.getRole().equals("user") ? "You" : "Bot";
                    String timestamp = dateFormat.format(new Date(msg.getTimestamp()));
                    Object preview = msg.getContent();
                    if (((String)preview).length() > 60) {
                        preview = ((String)preview).substring(0, 57) + "...";
                    }
                    this.sendMessage((CommandSender)player, "  \u00a77" + (offset + i + 1) + ". " + roleColor + "[" + roleLabel + "] \u00a77" + timestamp);
                    this.sendMessage((CommandSender)player, "     \u00a7f\"" + (String)preview + "\"");
                }
            }
            this.sendMessage((CommandSender)player, "");
            if (totalPages > 1) {
                StringBuilder nav = new StringBuilder("  ");
                if (page > 1) {
                    nav.append("\u00a7b[<] Previous \u00a77| ");
                } else {
                    nav.append("\u00a78[<] Previous \u00a77| ");
                }
                nav.append("\u00a7fPage \u00a7b").append(page).append("\u00a7f/\u00a7b").append(totalPages);
                if (page < totalPages) {
                    nav.append(" \u00a77| \u00a7bNext [>]");
                } else {
                    nav.append(" \u00a77| \u00a78Next [>]");
                }
                this.sendMessage((CommandSender)player, nav.toString());
                if (page > 1) {
                    this.sendMessage((CommandSender)player, "  \u00a77Previous: \u00a7b/nexvor privacy view " + (page - 1));
                }
                if (page < totalPages) {
                    this.sendMessage((CommandSender)player, "  \u00a77Next: \u00a7b/nexvor privacy view " + (page + 1));
                }
            }
        }
        this.sendMessage((CommandSender)player, "");
        this.sendMessage((CommandSender)player, "\u00a77To delete all your data: \u00a7b/nexvor privacy delete");
        this.sendMessage((CommandSender)player, "\u00a77========================================");
        return true;
    }

    private boolean toggleOptOut(Player player) {
        UUID playerUuid;
        ConversationManager conversationManager = this.plugin.getConversationManager();
        boolean currentStatus = conversationManager.isOptedOut(playerUuid = player.getUniqueId());
        boolean newStatus = !currentStatus;
        conversationManager.setOptOut(playerUuid, newStatus);
        this.sendMessage((CommandSender)player, "\u00a77========================================");
        if (newStatus) {
            this.sendSuccess((CommandSender)player, "You have OPTED OUT of AI chat");
            this.sendMessage((CommandSender)player, "\u00a77\u2022 You can no longer use /nexvor chat");
            this.sendMessage((CommandSender)player, "\u00a77\u2022 Your existing data is still stored");
            this.sendMessage((CommandSender)player, "\u00a77\u2022 Use \u00a7b/nexvor privacy delete \u00a77to remove your data");
            this.sendMessage((CommandSender)player, "\u00a77\u2022 Use \u00a7b/nexvor privacy opt-out \u00a77again to opt back in");
        } else {
            this.sendSuccess((CommandSender)player, "You have OPTED IN to AI chat");
            this.sendMessage((CommandSender)player, "\u00a77\u2022 You can now use /nexvor chat");
            this.sendMessage((CommandSender)player, "\u00a77\u2022 Use \u00a7b/nexvor privacy opt-out \u00a77to opt out again");
        }
        this.sendMessage((CommandSender)player, "\u00a77========================================");
        return true;
    }

    private boolean deleteData(Player player) {
        UUID playerUuid;
        ConversationManager conversationManager = this.plugin.getConversationManager();
        int messageCount = conversationManager.getMessageCount(playerUuid = player.getUniqueId());
        if (messageCount == 0) {
            this.sendMessage((CommandSender)player, "\u00a77You don't have any data to delete.");
            return true;
        }
        conversationManager.clearHistory(playerUuid);
        this.sendMessage((CommandSender)player, "\u00a77========================================");
        this.sendSuccess((CommandSender)player, "All your data has been deleted!");
        this.sendMessage((CommandSender)player, "\u00a77\u2022 Deleted " + messageCount + " conversation messages");
        this.sendMessage((CommandSender)player, "\u00a77\u2022 Your player record still exists (UUID, username)");
        this.sendMessage((CommandSender)player, "\u00a77\u2022 You can still use /nexvor chat");
        this.sendMessage((CommandSender)player, "\u00a77\u2022 Use \u00a7b/nexvor privacy opt-out \u00a77to prevent future data collection");
        this.sendMessage((CommandSender)player, "\u00a77========================================");
        return true;
    }

    private boolean showUsage(CommandSender sender) {
        this.sendMessage(sender, "\u00a77========================================");
        this.sendMessage(sender, "\u00a7b\u00a7lNexvor Privacy Commands");
        this.sendMessage(sender, "\u00a77========================================");
        this.sendMessage(sender, "");
        this.sendMessage(sender, "\u00a7b/nexvor privacy \u00a77- Show privacy information");
        this.sendMessage(sender, "\u00a7b/nexvor privacy view [page] \u00a77- View your stored data");
        this.sendMessage(sender, "\u00a7b/nexvor privacy opt-out \u00a77- Toggle opt-out status");
        this.sendMessage(sender, "\u00a7b/nexvor privacy delete \u00a77- Delete all your data");
        this.sendMessage(sender, "");
        this.sendMessage(sender, "\u00a77========================================");
        return true;
    }

    @Override
    public String getName() {
        return "privacy";
    }

    @Override
    public String getDescription() {
        return "Manage your privacy and data (view, opt-out, delete)";
    }

    @Override
    public String getUsage() {
        return "/nexvor privacy [view [page]|opt-out|delete]";
    }

    @Override
    public String getPermission() {
        return "nexvor.privacy";
    }
}

