/*
 * Decompiled with CFR 0.152.
 */
package com.nexvor.commands.subcommands;

import com.nexvor.Nexvor;
import com.nexvor.commands.BaseCommand;
import com.nexvor.core.PluginTier;
import com.nexvor.rag.KnowledgeBaseManager;
import com.nexvor.rag.RAGSearcher;
import com.nexvor.rag.models.KnowledgeBase;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;

public class KBCommand
extends BaseCommand {
    private final KnowledgeBaseManager kbManager;
    private final RAGSearcher ragSearcher;

    public KBCommand(Nexvor plugin) {
        super(plugin);
        this.kbManager = plugin.getKnowledgeBaseManager();
        this.ragSearcher = plugin.getRAGSearcher();
    }

    @Override
    public String getName() {
        return "kb";
    }

    @Override
    public String getDescription() {
        return "Manage knowledge bases (upload/list/delete) (MAX tier)";
    }

    @Override
    public String getUsage() {
        return "/nexvor kb <upload|list|info|delete|search>";
    }

    @Override
    public String getPermission() {
        return "nexvor.kb";
    }

    @Override
    public boolean execute(CommandSender sender, String[] args2) {
        String subcommand;
        if (!this.plugin.hasTier(PluginTier.MAX)) {
            this.sendError(sender, "Knowledge bases require MAX tier. Upgrade at: https://nexvor.dev/upgrade");
            return true;
        }
        if (!this.plugin.getConfig().getBoolean("rag.enabled", false)) {
            this.sendError(sender, "RAG system is disabled. Enable in config.yml under 'rag.enabled'");
            return true;
        }
        if (this.kbManager == null || !this.kbManager.isVectorDBAvailable()) {
            this.sendError(sender, "Vector database is not available! RAG requires vector_db to be enabled.");
            return true;
        }
        if (args2.length < 2) {
            this.sendUsage(sender);
            return true;
        }
        switch (subcommand = args2[1].toLowerCase()) {
            case "upload": {
                this.handleUpload(sender, args2);
                break;
            }
            case "list": {
                this.handleList(sender);
                break;
            }
            case "info": {
                this.handleInfo(sender, args2);
                break;
            }
            case "delete": {
                this.handleDelete(sender, args2);
                break;
            }
            case "search": {
                this.handleSearch(sender, args2);
                break;
            }
            default: {
                this.sendUsage(sender);
            }
        }
        return true;
    }

    private void handleUpload(CommandSender sender, String[] args2) {
        String kbDescription;
        if (args2.length < 3) {
            this.sendError(sender, "Usage: /nexvor kb upload <file_path> [kb_name] [description]");
            return;
        }
        String filePath = args2[2];
        String kbName = args2.length > 3 ? args2[3] : "Server Knowledge";
        StringBuilder descBuilder = new StringBuilder();
        if (args2.length > 4) {
            for (int i = 4; i < args2.length; ++i) {
                descBuilder.append(args2[i]).append(" ");
            }
        }
        if ((kbDescription = descBuilder.toString().trim()).isEmpty()) {
            kbDescription = "Server documentation and guides";
        }
        Path file = filePath.startsWith("/") || filePath.contains(":") ? Paths.get(filePath, new String[0]) : this.plugin.getDataFolder().toPath().resolve(filePath);
        if (!this.kbManager.getDocumentParser().isSupported(file.getFileName().toString())) {
            this.sendError(sender, "Unsupported file type! Supported: " + String.join((CharSequence)", ", this.kbManager.getDocumentParser().getSupportedExtensions()));
            return;
        }
        this.sendSuccess(sender, "Uploading document: " + String.valueOf(file.getFileName()) + "...");
        this.sendMessage(sender, "This may take a moment for large files.");
        String kbId = UUID.nameUUIDFromBytes(kbName.getBytes()).toString();
        this.kbManager.uploadDocument(kbId, file, kbName, kbDescription).thenAccept(chunkCount -> {
            if (chunkCount > 0) {
                this.sendSuccess(sender, "Successfully uploaded " + String.valueOf(file.getFileName()) + " (" + chunkCount + " chunks) to knowledge base: " + kbName);
                this.sendMessage(sender, "KB ID: " + kbId);
            } else {
                this.sendError(sender, "Failed to upload document. Check console for errors.");
            }
        });
    }

    private void handleList(CommandSender sender) {
        List<KnowledgeBase> kbs = this.kbManager.listKnowledgeBases();
        if (kbs.isEmpty()) {
            this.sendMessage(sender, "No knowledge bases found. Upload documents with /nexvor kb upload");
            return;
        }
        sender.sendMessage(String.valueOf(ChatColor.GOLD) + "=== Knowledge Bases ===");
        for (KnowledgeBase kb : kbs) {
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + kb.getName() + String.valueOf(ChatColor.GRAY) + " (ID: " + kb.getId() + ")");
            sender.sendMessage(String.valueOf(ChatColor.GRAY) + "  Description: " + kb.getDescription());
            sender.sendMessage(String.valueOf(ChatColor.GRAY) + "  Chunks: " + kb.getChunkCount() + " | Collection: " + kb.getCollection());
        }
        sender.sendMessage(String.valueOf(ChatColor.GRAY) + "Total: " + kbs.size() + " knowledge bases");
        sender.sendMessage(String.valueOf(ChatColor.GRAY) + "Use /nexvor kb info <id> for details");
    }

    private void handleInfo(CommandSender sender, String[] args2) {
        if (args2.length < 3) {
            this.sendError(sender, "Usage: /nexvor kb info <kb_id>");
            return;
        }
        String kbId = args2[2];
        KnowledgeBase kb = this.kbManager.getKnowledgeBase(kbId);
        if (kb == null) {
            this.sendError(sender, "Knowledge base not found: " + kbId);
            return;
        }
        sender.sendMessage(String.valueOf(ChatColor.GOLD) + "=== Knowledge Base Info ===");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Name: " + String.valueOf(ChatColor.WHITE) + kb.getName());
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "ID: " + String.valueOf(ChatColor.WHITE) + kb.getId());
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Description: " + String.valueOf(ChatColor.WHITE) + kb.getDescription());
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Collection: " + String.valueOf(ChatColor.WHITE) + kb.getCollection());
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Chunks: " + String.valueOf(ChatColor.WHITE) + kb.getChunkCount());
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Created: " + String.valueOf(ChatColor.WHITE) + String.valueOf(new Date(kb.getCreatedAt())));
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Updated: " + String.valueOf(ChatColor.WHITE) + String.valueOf(new Date(kb.getUpdatedAt())));
    }

    private void handleDelete(CommandSender sender, String[] args2) {
        if (args2.length < 3) {
            this.sendError(sender, "Usage: /nexvor kb delete <kb_id>");
            return;
        }
        String kbId = args2[2];
        KnowledgeBase kb = this.kbManager.getKnowledgeBase(kbId);
        if (kb == null) {
            this.sendError(sender, "Knowledge base not found: " + kbId);
            return;
        }
        this.sendMessage(sender, "Deleting knowledge base: " + kb.getName() + " (" + kb.getChunkCount() + " chunks)...");
        this.kbManager.deleteKnowledgeBase(kbId).thenAccept(success -> {
            if (success.booleanValue()) {
                this.sendSuccess(sender, "Successfully deleted knowledge base: " + kb.getName());
            } else {
                this.sendError(sender, "Failed to delete knowledge base. Check console for errors.");
            }
        });
    }

    private void handleSearch(CommandSender sender, String[] args2) {
        if (args2.length < 3) {
            this.sendError(sender, "Usage: /nexvor kb search <query>");
            return;
        }
        StringBuilder queryBuilder = new StringBuilder();
        for (int i = 2; i < args2.length; ++i) {
            queryBuilder.append(args2[i]).append(" ");
        }
        String query = queryBuilder.toString().trim();
        this.sendMessage(sender, "Searching knowledge bases for: " + query);
        this.ragSearcher.searchContext(query).thenAccept(context -> {
            if (context == null || context.isEmpty()) {
                this.sendMessage(sender, "No relevant context found in knowledge bases.");
            } else {
                sender.sendMessage(String.valueOf(ChatColor.GOLD) + "=== RAG Search Results ===");
                sender.sendMessage(String.valueOf(ChatColor.WHITE) + context);
            }
        });
    }

    private void sendUsage(CommandSender sender) {
        sender.sendMessage(String.valueOf(ChatColor.GOLD) + "=== Knowledge Base Commands ===");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/nexvor kb upload <file> [name] [description]" + String.valueOf(ChatColor.GRAY) + " - Upload document");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/nexvor kb list" + String.valueOf(ChatColor.GRAY) + " - List all knowledge bases");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/nexvor kb info <id>" + String.valueOf(ChatColor.GRAY) + " - Show KB details");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/nexvor kb delete <id>" + String.valueOf(ChatColor.GRAY) + " - Delete knowledge base");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/nexvor kb search <query>" + String.valueOf(ChatColor.GRAY) + " - Test RAG search");
    }

    public List<String> getTabCompletions(CommandSender sender, String[] args2) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args2.length == 2) {
            completions.add("upload");
            completions.add("list");
            completions.add("info");
            completions.add("delete");
            completions.add("search");
        } else if (args2.length == 3) {
            String subcommand = args2[1].toLowerCase();
            if (subcommand.equals("info") || subcommand.equals("delete")) {
                List<KnowledgeBase> kbs = this.kbManager.listKnowledgeBases();
                for (KnowledgeBase kb : kbs) {
                    completions.add(kb.getId());
                }
            } else if (subcommand.equals("upload")) {
                completions.add("rules.txt");
                completions.add("faq.md");
                completions.add("guide.md");
            }
        }
        return completions;
    }
}

