/*
 * Decompiled with CFR 0.152.
 */
package com.nexvor.commands.subcommands;

import com.nexvor.Nexvor;
import com.nexvor.commands.BaseCommand;
import com.nexvor.core.PluginTier;
import com.nexvor.memory.GroupConversation;
import com.nexvor.memory.GroupConversationManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class GroupCommand
extends BaseCommand {
    public GroupCommand(Nexvor plugin) {
        super(plugin);
    }

    @Override
    public String getName() {
        return "group";
    }

    @Override
    public String getDescription() {
        return "Manage group conversations (Medium tier)";
    }

    @Override
    public String getUsage() {
        return "/nexvor group <create|join|leave|list|invite|kick|disband|info> [args]";
    }

    @Override
    public String getPermission() {
        return "nexvor.group";
    }

    @Override
    public boolean execute(CommandSender sender, String[] args2) {
        String subcommand;
        if (!this.plugin.hasTier(PluginTier.MEDIUM)) {
            this.sendError(sender, "Group conversations require Medium tier or higher!");
            sender.sendMessage("\u00a7eUpgrade at: https://nexvor.dev/upgrade");
            return true;
        }
        GroupConversationManager groupManager = this.plugin.getGroupConversationManager();
        if (groupManager == null) {
            this.sendError(sender, "Group conversation system not initialized!");
            return true;
        }
        if (!(sender instanceof Player)) {
            this.sendError(sender, "Only players can use group commands!");
            return true;
        }
        Player player = (Player)sender;
        if (args2.length < 2) {
            this.sendUsage(sender);
            return true;
        }
        switch (subcommand = args2[1].toLowerCase()) {
            case "create": {
                this.handleCreate(player, args2, groupManager);
                break;
            }
            case "join": {
                this.handleJoin(player, args2, groupManager);
                break;
            }
            case "leave": {
                this.handleLeave(player, args2, groupManager);
                break;
            }
            case "list": {
                this.handleList(player, groupManager);
                break;
            }
            case "invite": {
                this.handleInvite(player, args2, groupManager);
                break;
            }
            case "kick": {
                this.handleKick(player, args2, groupManager);
                break;
            }
            case "disband": {
                this.handleDisband(player, args2, groupManager);
                break;
            }
            case "info": {
                this.handleInfo(player, args2, groupManager);
                break;
            }
            default: {
                this.sendUsage(sender);
            }
        }
        return true;
    }

    private void handleCreate(Player player, String[] args2, GroupConversationManager manager) {
        if (args2.length < 3) {
            this.sendError((CommandSender)player, "Usage: /nexvor group create <name>");
            return;
        }
        String groupName = String.join((CharSequence)" ", Arrays.copyOfRange(args2, 2, args2.length));
        GroupConversation group = manager.createGroup(groupName, player.getUniqueId());
        if (group != null) {
            this.sendSuccess((CommandSender)player, "Group created: \u00a7e" + groupName);
            player.sendMessage("\u00a77Group ID: \u00a7f" + group.getGroupId());
            player.sendMessage("\u00a77Use \u00a7e/nexvor group invite <player>\u00a77 to add members");
        } else {
            this.sendError((CommandSender)player, "Failed to create group. Check server logs.");
        }
    }

    private void handleJoin(Player player, String[] args2, GroupConversationManager manager) {
        if (args2.length < 3) {
            this.sendError((CommandSender)player, "Usage: /nexvor group join <groupId>");
            return;
        }
        String groupId = args2[2];
        GroupConversation group = manager.getGroup(groupId);
        if (group == null) {
            this.sendError((CommandSender)player, "Group not found!");
            return;
        }
        if (!group.isActive()) {
            this.sendError((CommandSender)player, "This group has been disbanded!");
            return;
        }
        if (group.isMember(player.getUniqueId())) {
            this.sendError((CommandSender)player, "You are already a member of this group!");
            return;
        }
        if (manager.addMember(groupId, player.getUniqueId())) {
            this.sendSuccess((CommandSender)player, "Joined group: \u00a7e" + group.getGroupName());
        } else {
            this.sendError((CommandSender)player, "Failed to join group!");
        }
    }

    private void handleLeave(Player player, String[] args2, GroupConversationManager manager) {
        if (args2.length < 3) {
            this.sendError((CommandSender)player, "Usage: /nexvor group leave <groupId>");
            return;
        }
        String groupId = args2[2];
        GroupConversation group = manager.getGroup(groupId);
        if (group == null) {
            this.sendError((CommandSender)player, "Group not found!");
            return;
        }
        if (group.isOwner(player.getUniqueId())) {
            this.sendError((CommandSender)player, "Group owner cannot leave! Use /nexvor group disband instead.");
            return;
        }
        if (manager.removeMember(groupId, player.getUniqueId())) {
            this.sendSuccess((CommandSender)player, "Left group: \u00a7e" + group.getGroupName());
        } else {
            this.sendError((CommandSender)player, "Failed to leave group!");
        }
    }

    private void handleList(Player player, GroupConversationManager manager) {
        List<GroupConversation> groups2 = manager.getPlayerGroups(player.getUniqueId());
        if (groups2.isEmpty()) {
            player.sendMessage("\u00a77You are not in any groups.");
            player.sendMessage("\u00a77Create one with \u00a7e/nexvor group create <name>");
            return;
        }
        player.sendMessage("\u00a7a\u00a7l\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
        player.sendMessage("\u00a7a\u00a7lYour Groups");
        player.sendMessage("\u00a7a\u00a7l\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
        for (GroupConversation group : groups2) {
            String ownerTag = group.isOwner(player.getUniqueId()) ? " \u00a77(Owner)" : "";
            player.sendMessage("\u00a7e" + group.getGroupName() + ownerTag);
            player.sendMessage("  \u00a77ID: \u00a7f" + group.getGroupId());
            player.sendMessage("  \u00a77Members: \u00a7f" + group.getMemberCount());
        }
        player.sendMessage("\u00a7a\u00a7l\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
    }

    private void handleInvite(Player player, String[] args2, GroupConversationManager manager) {
        if (args2.length < 4) {
            this.sendError((CommandSender)player, "Usage: /nexvor group invite <player> <groupId>");
            return;
        }
        Player target = Bukkit.getPlayer((String)args2[2]);
        if (target == null) {
            this.sendError((CommandSender)player, "Player not found!");
            return;
        }
        String groupId = args2[3];
        GroupConversation group = manager.getGroup(groupId);
        if (group == null) {
            this.sendError((CommandSender)player, "Group not found!");
            return;
        }
        if (!group.isMember(player.getUniqueId())) {
            this.sendError((CommandSender)player, "You are not a member of this group!");
            return;
        }
        if (group.isMember(target.getUniqueId())) {
            this.sendError((CommandSender)player, target.getName() + " is already in this group!");
            return;
        }
        if (manager.addMember(groupId, target.getUniqueId())) {
            this.sendSuccess((CommandSender)player, "Invited \u00a7e" + target.getName() + "\u00a7a to the group!");
            target.sendMessage(this.getPrefix() + " \u00a7aYou've been added to group: \u00a7e" + group.getGroupName());
            target.sendMessage("\u00a77Group ID: \u00a7f" + groupId);
        } else {
            this.sendError((CommandSender)player, "Failed to invite player!");
        }
    }

    private void handleKick(Player player, String[] args2, GroupConversationManager manager) {
        if (args2.length < 4) {
            this.sendError((CommandSender)player, "Usage: /nexvor group kick <player> <groupId>");
            return;
        }
        Player target = Bukkit.getPlayer((String)args2[2]);
        if (target == null) {
            this.sendError((CommandSender)player, "Player not found!");
            return;
        }
        String groupId = args2[3];
        GroupConversation group = manager.getGroup(groupId);
        if (group == null) {
            this.sendError((CommandSender)player, "Group not found!");
            return;
        }
        if (!group.isOwner(player.getUniqueId())) {
            this.sendError((CommandSender)player, "Only the group owner can kick members!");
            return;
        }
        if (target.getUniqueId().equals(player.getUniqueId())) {
            this.sendError((CommandSender)player, "You cannot kick yourself! Use /nexvor group disband instead.");
            return;
        }
        if (manager.removeMember(groupId, target.getUniqueId())) {
            this.sendSuccess((CommandSender)player, "Kicked \u00a7e" + target.getName() + "\u00a7a from the group!");
            target.sendMessage(this.getPrefix() + " \u00a7cYou've been removed from group: \u00a7e" + group.getGroupName());
        } else {
            this.sendError((CommandSender)player, "Failed to kick player!");
        }
    }

    private void handleDisband(Player player, String[] args2, GroupConversationManager manager) {
        if (args2.length < 3) {
            this.sendError((CommandSender)player, "Usage: /nexvor group disband <groupId>");
            return;
        }
        String groupId = args2[2];
        GroupConversation group = manager.getGroup(groupId);
        if (group == null) {
            this.sendError((CommandSender)player, "Group not found!");
            return;
        }
        if (!group.isOwner(player.getUniqueId())) {
            this.sendError((CommandSender)player, "Only the group owner can disband the group!");
            return;
        }
        if (manager.disbandGroup(groupId)) {
            this.sendSuccess((CommandSender)player, "Group disbanded: \u00a7e" + group.getGroupName());
            String prefix = this.getPrefix();
            for (UUID memberUuid : group.getMembers()) {
                Player member = Bukkit.getPlayer((UUID)memberUuid);
                if (member == null || member.equals((Object)player)) continue;
                member.sendMessage(prefix + " \u00a7cGroup disbanded: \u00a7e" + group.getGroupName());
            }
        } else {
            this.sendError((CommandSender)player, "Failed to disband group!");
        }
    }

    private void handleInfo(Player player, String[] args2, GroupConversationManager manager) {
        if (args2.length < 3) {
            this.sendError((CommandSender)player, "Usage: /nexvor group info <groupId>");
            return;
        }
        String groupId = args2[2];
        GroupConversation group = manager.getGroup(groupId);
        if (group == null) {
            this.sendError((CommandSender)player, "Group not found!");
            return;
        }
        player.sendMessage("\u00a7a\u00a7l\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
        player.sendMessage("\u00a7a\u00a7lGroup Info: \u00a7e" + group.getGroupName());
        player.sendMessage("\u00a7a\u00a7l\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
        player.sendMessage("\u00a77ID: \u00a7f" + group.getGroupId());
        Player owner = Bukkit.getPlayer((UUID)group.getOwnerUuid());
        String ownerName = owner != null ? owner.getName() : "Unknown";
        player.sendMessage("\u00a77Owner: \u00a7f" + ownerName);
        player.sendMessage("\u00a77Members (\u00a7f" + group.getMemberCount() + "\u00a77):");
        for (UUID memberUuid : group.getMembers()) {
            Player member = Bukkit.getPlayer((UUID)memberUuid);
            String memberName = member != null ? member.getName() : "Offline";
            String onlineStatus = member != null ? "\u00a7a\u25cf" : "\u00a77\u25cf";
            player.sendMessage("  " + onlineStatus + " \u00a7f" + memberName);
        }
        player.sendMessage("\u00a7a\u00a7l\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
    }

    private void sendUsage(CommandSender sender) {
        sender.sendMessage("\u00a7a\u00a7l\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
        sender.sendMessage("\u00a7a\u00a7lGroup Commands \u00a77(Medium Tier)");
        sender.sendMessage("\u00a7a\u00a7l\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
        sender.sendMessage("\u00a7e/nexvor group create <name> \u00a77- Create a new group");
        sender.sendMessage("\u00a7e/nexvor group join <id> \u00a77- Join a group");
        sender.sendMessage("\u00a7e/nexvor group leave <id> \u00a77- Leave a group");
        sender.sendMessage("\u00a7e/nexvor group list \u00a77- List your groups");
        sender.sendMessage("\u00a7e/nexvor group invite <player> <id> \u00a77- Invite a player");
        sender.sendMessage("\u00a7e/nexvor group kick <player> <id> \u00a77- Kick a player");
        sender.sendMessage("\u00a7e/nexvor group disband <id> \u00a77- Disband a group");
        sender.sendMessage("\u00a7e/nexvor group info <id> \u00a77- Show group info");
        sender.sendMessage("\u00a7a\u00a7l\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String[] args2) {
        ArrayList<String> suggestions = new ArrayList<String>();
        if (args2.length == 2) {
            suggestions.add("create");
            suggestions.add("join");
            suggestions.add("leave");
            suggestions.add("list");
            suggestions.add("invite");
            suggestions.add("kick");
            suggestions.add("disband");
            suggestions.add("info");
        }
        return suggestions;
    }
}

