/*
 * Decompiled with CFR 0.152.
 */
package com.nexvor.commands.subcommands;

import com.nexvor.Nexvor;
import com.nexvor.commands.BaseCommand;
import com.nexvor.memory.ConversationManager;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ForgetCommand
extends BaseCommand {
    public ForgetCommand(Nexvor plugin) {
        super(plugin);
    }

    @Override
    public boolean execute(CommandSender sender, String[] args2) {
        if (!(sender instanceof Player)) {
            this.sendError(sender, "This command can only be used by players!");
            return true;
        }
        Player player = (Player)sender;
        ConversationManager conversationManager = this.plugin.getConversationManager();
        if (conversationManager == null) {
            this.sendError(sender, "Conversation manager not initialized! Check server logs.");
            return true;
        }
        if (!conversationManager.hasHistory(player.getUniqueId())) {
            this.sendMessage(sender, "\u00a77You don't have any conversation history to clear.");
            return true;
        }
        int messagesCleared = conversationManager.clearHistory(player.getUniqueId());
        this.sendSuccess(sender, "Your conversation history has been cleared!");
        this.sendMessage(sender, "\u00a77Cleared " + messagesCleared + " messages. The bot will no longer remember previous conversations.");
        return true;
    }

    @Override
    public String getName() {
        return "forget";
    }

    @Override
    public String getDescription() {
        return "Clear your conversation history";
    }

    @Override
    public String getUsage() {
        return "/nexvor forget";
    }

    @Override
    public String getPermission() {
        return "nexvor.forget";
    }
}

