/*
 * Decompiled with CFR 0.152.
 */
package com.nexvor.commands.subcommands;

import com.nexvor.Nexvor;
import com.nexvor.commands.BaseCommand;
import com.nexvor.core.PluginTier;
import com.nexvor.events.EventType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class EventsCommand
extends BaseCommand {
    public EventsCommand(Nexvor plugin) {
        super(plugin);
    }

    @Override
    public String getName() {
        return "events";
    }

    @Override
    public String getDescription() {
        return "Manage AI event response preferences";
    }

    @Override
    public String getUsage() {
        return "/nexvor events <list|toggle> [event_type|all]";
    }

    @Override
    public String getPermission() {
        return "nexvor.events";
    }

    @Override
    public boolean execute(CommandSender sender, String[] args2) {
        String subCommand;
        if (!this.plugin.hasTier(PluginTier.MEDIUM)) {
            this.sendError(sender, "Event management requires Medium tier or higher!");
            sender.sendMessage("\u00a7eUpgrade at: https://nexvor.dev/upgrade");
            return true;
        }
        if (!(sender instanceof Player)) {
            this.sendError(sender, "This command can only be used by players.");
            return true;
        }
        Player player = (Player)sender;
        if (!this.plugin.getConfig().getBoolean("event_awareness.enabled", true)) {
            this.sendError((CommandSender)player, "Event awareness is currently disabled in the config.");
            return true;
        }
        if (args2.length == 0) {
            this.sendUsage(player);
            return true;
        }
        switch (subCommand = args2[0].toLowerCase()) {
            case "list": {
                this.handleList(player);
                break;
            }
            case "toggle": {
                this.handleToggle(player, args2);
                break;
            }
            default: {
                this.sendUsage(player);
            }
        }
        return true;
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String[] args2) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args2.length == 1) {
            completions.add("list");
            completions.add("toggle");
        } else if (args2.length == 2 && args2[0].equalsIgnoreCase("toggle")) {
            Arrays.stream(EventType.values()).map(EventType::getConfigKey).forEach(completions::add);
            completions.add("all");
        }
        return completions;
    }

    private void handleList(Player player) {
        this.sendMessage((CommandSender)player, "\u00a76\u00a7lEvent Preferences");
        player.sendMessage("\u00a77\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
        for (EventType eventType : EventType.values()) {
            boolean globalEnabled = this.isEventEnabledGlobally(eventType);
            boolean playerEnabled = this.isEventEnabledForPlayer(player, eventType);
            String status = !globalEnabled ? "\u00a78[DISABLED GLOBALLY]" : (playerEnabled ? "\u00a7a[ENABLED]" : "\u00a7c[DISABLED]");
            player.sendMessage(String.format("\u00a7e%s \u00a77- %s %s", eventType.getDisplayName(), eventType.getDescription(), status));
        }
        player.sendMessage("\u00a77\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
        player.sendMessage("\u00a77Use \u00a7e/nexvor events toggle <event> \u00a77to enable/disable");
        player.sendMessage("\u00a77Use \u00a7e/nexvor events toggle all \u00a77to enable/disable all");
    }

    private void handleToggle(Player player, String[] args2) {
        if (args2.length < 2) {
            this.sendError((CommandSender)player, "Usage: /nexvor events toggle <event_type|all>");
            return;
        }
        String eventKey = args2[1].toLowerCase();
        if (eventKey.equals("all")) {
            this.handleToggleAll(player);
            return;
        }
        EventType eventType = EventType.fromConfigKey(eventKey);
        if (eventType == null) {
            this.sendError((CommandSender)player, "Unknown event type: " + eventKey);
            player.sendMessage("\u00a77Use \u00a7e/nexvor events list \u00a77to see all event types");
            return;
        }
        if (!this.isEventEnabledGlobally(eventType)) {
            this.sendError((CommandSender)player, "This event is disabled globally in the config.");
            player.sendMessage("\u00a77Contact a server administrator to enable it.");
            return;
        }
        boolean currentlyEnabled = this.isEventEnabledForPlayer(player, eventType);
        boolean newValue = !currentlyEnabled;
        this.setEventPreference(player, eventType, newValue);
        String status = newValue ? "\u00a7aenabled" : "\u00a7cdisabled";
        this.sendMessage((CommandSender)player, String.format("%s is now %s.", eventType.getDisplayName(), status));
    }

    private void handleToggleAll(Player player) {
        boolean anyEnabled = false;
        for (EventType eventType : EventType.values()) {
            if (!this.isEventEnabledForPlayer(player, eventType)) continue;
            anyEnabled = true;
            break;
        }
        boolean newValue = !anyEnabled;
        int toggledCount = 0;
        for (EventType eventType : EventType.values()) {
            if (!this.isEventEnabledGlobally(eventType)) continue;
            this.setEventPreference(player, eventType, newValue);
            ++toggledCount;
        }
        String status = newValue ? "\u00a7aenabled" : "\u00a7cdisabled";
        this.sendMessage((CommandSender)player, String.format("All events (%d) are now %s.", toggledCount, status));
    }

    private boolean isEventEnabledGlobally(EventType eventType) {
        return this.plugin.getConfig().getBoolean("event_awareness.events." + eventType.getConfigKey(), false);
    }

    private boolean isEventEnabledForPlayer(Player player, EventType eventType) {
        Boolean preference = this.plugin.getDatabaseManager().getEventPreference(player.getUniqueId(), eventType);
        if (preference == null) {
            return this.isEventEnabledGlobally(eventType);
        }
        return preference;
    }

    private void setEventPreference(Player player, EventType eventType, boolean enabled) {
        this.plugin.getDatabaseManager().setEventPreference(player.getUniqueId(), eventType, enabled);
    }

    private void sendUsage(Player player) {
        this.sendMessage((CommandSender)player, "\u00a76Event Management Commands:");
        player.sendMessage("\u00a7e/nexvor events list \u00a77- List all event types and their status");
        player.sendMessage("\u00a7e/nexvor events toggle <event> \u00a77- Toggle specific event");
        player.sendMessage("\u00a7e/nexvor events toggle all \u00a77- Toggle all events");
    }
}

