/*
 * Decompiled with CFR 0.152.
 */
package com.nexvor.commands.subcommands;

import com.nexvor.Nexvor;
import com.nexvor.commands.BaseCommand;
import com.nexvor.core.PluginTier;
import com.nexvor.dashboard.DashboardManager;
import com.nexvor.dashboard.auth.APITokenManager;
import com.nexvor.dashboard.auth.AuthenticationManager;
import com.nexvor.dashboard.models.APIToken;
import com.nexvor.dashboard.models.AccessCode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class DashboardCommand
extends BaseCommand {
    public DashboardCommand(Nexvor plugin) {
        super(plugin);
    }

    @Override
    public String getName() {
        return "dashboard";
    }

    @Override
    public String getDescription() {
        return "Manage web dashboard (MAX tier)";
    }

    @Override
    public String getUsage() {
        return "/nexvor dashboard [register|token|status]";
    }

    @Override
    public String getPermission() {
        return "nexvor.dashboard";
    }

    @Override
    public boolean execute(CommandSender sender, String[] args2) {
        String subcommand;
        if (!this.plugin.hasTier(PluginTier.MAX)) {
            this.sendError(sender, "Dashboard requires MAX tier. Upgrade at: https://nexvor.dev/upgrade");
            return true;
        }
        DashboardManager dashboardManager = this.plugin.getDashboardManager();
        if (dashboardManager == null || !dashboardManager.isEnabled()) {
            this.sendError(sender, "Dashboard is not enabled! Enable in config.yml under 'dashboard.enabled'");
            return true;
        }
        if (args2.length == 0) {
            if (!(sender instanceof Player)) {
                this.sendError(sender, "Console cannot generate access codes! Use /nexvor dashboard status instead.");
                return true;
            }
            return this.handleAccessCode((Player)sender, dashboardManager.getAuthManager());
        }
        switch (subcommand = args2[0].toLowerCase()) {
            case "register": {
                return this.handleRegister(sender, args2, dashboardManager.getAuthManager());
            }
            case "token": {
                return this.handleToken(sender, args2, dashboardManager.getTokenManager());
            }
            case "status": {
                return this.handleStatus(sender, dashboardManager);
            }
        }
        this.sendUsage(sender);
        return true;
    }

    private boolean handleAccessCode(Player player, AuthenticationManager authManager) {
        AccessCode code = authManager.getAccessCodeGenerator().generate(player.getUniqueId(), player.getName());
        if (code != null) {
            player.sendMessage(String.valueOf(ChatColor.GOLD) + "=== Dashboard Access ===");
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Your access code: " + String.valueOf(ChatColor.WHITE) + String.valueOf(ChatColor.BOLD) + code.getCode());
            player.sendMessage(String.valueOf(ChatColor.GRAY) + "Valid for 5 minutes");
            player.sendMessage("");
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Dashboard URL: " + String.valueOf(ChatColor.AQUA) + this.plugin.getDashboardManager().getServer().getDashboardURL());
            player.sendMessage(String.valueOf(ChatColor.GRAY) + "Enter this code on the login page");
            return true;
        }
        this.sendError((CommandSender)player, "Failed to generate access code. Check server logs.");
        return true;
    }

    private boolean handleRegister(CommandSender sender, String[] args2, AuthenticationManager authManager) {
        if (!(sender instanceof Player)) {
            this.sendError(sender, "Only players can register dashboard accounts!");
            return true;
        }
        Player player = (Player)sender;
        if (!this.plugin.getConfig().getBoolean("dashboard.auth.user_accounts.enabled", false)) {
            this.sendError(sender, "Per-user accounts are disabled! Use access codes instead: /nexvor dashboard");
            return true;
        }
        if (args2.length < 2) {
            this.sendError(sender, "Usage: /nexvor dashboard register <password>");
            return true;
        }
        String password = args2[1];
        int minLength = this.plugin.getConfig().getInt("dashboard.auth.user_accounts.min_password_length", 8);
        if (password.length() < minLength) {
            this.sendError(sender, "Password must be at least " + minLength + " characters!");
            return true;
        }
        boolean success = authManager.registerUser(player.getUniqueId(), player.getName(), password);
        if (success) {
            this.sendSuccess(sender, "Dashboard account created!");
            this.sendMessage(sender, "\u00a77Username: \u00a7f" + player.getName());
            this.sendMessage(sender, "\u00a77Password: \u00a7f" + password);
            this.sendMessage(sender, "\u00a77Login at: \u00a7b" + this.plugin.getDashboardManager().getServer().getDashboardURL());
        } else {
            this.sendError(sender, "Failed to create account. You may already have an account.");
        }
        return true;
    }

    private boolean handleToken(CommandSender sender, String[] args2, APITokenManager tokenManager) {
        String tokenAction;
        if (!(sender instanceof Player)) {
            this.sendError(sender, "Only players can manage API tokens!");
            return true;
        }
        Player player = (Player)sender;
        if (args2.length < 2) {
            this.sendError(sender, "Usage: /nexvor dashboard token <create|list|revoke>");
            return true;
        }
        switch (tokenAction = args2[1].toLowerCase()) {
            case "create": {
                if (args2.length < 3) {
                    this.sendError(sender, "Usage: /nexvor dashboard token create <purpose> [scopes]");
                    this.sendMessage(sender, "\u00a77Scopes: read, write, admin (comma-separated)");
                    this.sendMessage(sender, "\u00a77Example: /nexvor dashboard token create \"Python Script\" read,write");
                    return true;
                }
                String purpose = args2[2];
                HashSet<String> scopes = new HashSet<String>();
                if (args2.length > 3) {
                    scopes.addAll(Arrays.asList(args2[3].split(",")));
                } else {
                    scopes.add("read");
                }
                APIToken token = tokenManager.createToken(player.getUniqueId(), player.getName(), purpose, scopes);
                if (token != null) {
                    this.sendSuccess(sender, "API token created!");
                    this.sendMessage(sender, "\u00a77Token: \u00a7f" + token.getToken());
                    this.sendMessage(sender, "\u00a77Purpose: \u00a7f" + purpose);
                    this.sendMessage(sender, "\u00a77Scopes: \u00a7f" + String.join((CharSequence)", ", scopes));
                    this.sendMessage(sender, "\u00a7cKeep this token secret! You won't be able to see it again.");
                } else {
                    this.sendError(sender, "Failed to create API token. Check server logs.");
                }
                return true;
            }
            case "list": {
                List<APIToken> tokens = tokenManager.getTokens(player.getUniqueId());
                if (tokens.isEmpty()) {
                    this.sendMessage(sender, "You don't have any API tokens.");
                    this.sendMessage(sender, "\u00a77Create one with: /nexvor dashboard token create <purpose>");
                    return true;
                }
                sender.sendMessage(String.valueOf(ChatColor.GOLD) + "=== Your API Tokens ===");
                for (APIToken token : tokens) {
                    sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "\u2022 " + token.getPurpose());
                    sender.sendMessage(String.valueOf(ChatColor.GRAY) + "  Token: " + token.getToken().substring(0, 12) + "...");
                    sender.sendMessage(String.valueOf(ChatColor.GRAY) + "  Scopes: " + String.join((CharSequence)", ", token.getScopes()));
                    sender.sendMessage(String.valueOf(ChatColor.GRAY) + "  Created: " + String.valueOf(new Date(token.getCreatedAt())));
                    sender.sendMessage(String.valueOf(ChatColor.GRAY) + "  Status: " + (token.isRevoked() ? String.valueOf(ChatColor.RED) + "Revoked" : String.valueOf(ChatColor.GREEN) + "Active"));
                }
                return true;
            }
            case "revoke": {
                if (args2.length < 3) {
                    this.sendError(sender, "Usage: /nexvor dashboard token revoke <token>");
                    return true;
                }
                String tokenToRevoke = args2[2];
                boolean success = tokenManager.revokeToken(tokenToRevoke);
                if (success) {
                    this.sendSuccess(sender, "API token revoked successfully");
                } else {
                    this.sendError(sender, "Failed to revoke token. Invalid token or already revoked.");
                }
                return true;
            }
        }
        this.sendError(sender, "Unknown action: " + tokenAction);
        this.sendMessage(sender, "\u00a77Available: create, list, revoke");
        return true;
    }

    private boolean handleStatus(CommandSender sender, DashboardManager dashboardManager) {
        sender.sendMessage(String.valueOf(ChatColor.GOLD) + "=== Dashboard Status ===");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Enabled: " + String.valueOf(ChatColor.WHITE) + (dashboardManager.isEnabled() ? "Yes" : "No"));
        if (dashboardManager.isEnabled()) {
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "URL: " + String.valueOf(ChatColor.AQUA) + dashboardManager.getServer().getDashboardURL());
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Access: " + String.valueOf(ChatColor.WHITE) + "/nexvor dashboard \u00a77(generates access code)");
        }
        return true;
    }

    private void sendUsage(CommandSender sender) {
        sender.sendMessage(String.valueOf(ChatColor.GOLD) + "=== Dashboard Commands ===");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/nexvor dashboard" + String.valueOf(ChatColor.GRAY) + " - Generate access code");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/nexvor dashboard register <password>" + String.valueOf(ChatColor.GRAY) + " - Create account");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/nexvor dashboard token create <purpose> [scopes]" + String.valueOf(ChatColor.GRAY) + " - Create API token");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/nexvor dashboard token list" + String.valueOf(ChatColor.GRAY) + " - List your tokens");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/nexvor dashboard token revoke <token>" + String.valueOf(ChatColor.GRAY) + " - Revoke token");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/nexvor dashboard status" + String.valueOf(ChatColor.GRAY) + " - Show dashboard status");
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String[] args2) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args2.length == 1) {
            completions.add("register");
            completions.add("token");
            completions.add("status");
        } else if (args2.length == 2 && args2[0].equalsIgnoreCase("token")) {
            completions.add("create");
            completions.add("list");
            completions.add("revoke");
        }
        return completions;
    }
}

