/*
 * Decompiled with CFR 0.152.
 */
package com.nexvor.commands.subcommands;

import com.nexvor.Nexvor;
import com.nexvor.ai.ProviderManager;
import com.nexvor.ai.models.ChatMessage;
import com.nexvor.ai.models.ChatRequest;
import com.nexvor.commands.BaseCommand;
import com.nexvor.core.PluginTier;
import com.nexvor.features.max.AICommandExecutor;
import com.nexvor.features.max.BotPersonalityManager;
import com.nexvor.features.max.ModerationManager;
import com.nexvor.features.max.models.BotPersonality;
import com.nexvor.features.max.models.CommandExecutionResult;
import com.nexvor.features.max.models.ModerationAction;
import com.nexvor.features.max.models.ToxicityResult;
import com.nexvor.filter.FilterResult;
import com.nexvor.filter.LanguageFilter;
import com.nexvor.memory.ConversationManager;
import com.nexvor.ratelimit.RateLimitManager;
import com.nexvor.ratelimit.RateLimitResult;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class ChatCommand
extends BaseCommand {
    public ChatCommand(Nexvor plugin) {
        super(plugin);
    }

    @Override
    public boolean execute(CommandSender sender, String[] args2) {
        String ragContext;
        ToxicityResult toxicityCheck;
        ModerationManager moderationManager;
        FilterResult filterResult;
        RateLimitResult rateLimitResult;
        String systemPrompt;
        ProviderManager providerManager;
        if (args2.length == 0) {
            return false;
        }
        if (!(sender instanceof Player)) {
            this.sendError(sender, "This command can only be used by players!");
            return true;
        }
        Player player = (Player)sender;
        UUID playerUuid = player.getUniqueId();
        String playerName = player.getName();
        String botName = "default";
        if (this.plugin.hasTier(PluginTier.MAX)) {
            BotPersonalityManager botManager = this.plugin.getBotPersonalityManager();
            if (botManager != null && botManager.isEnabled()) {
                BotPersonality activeBot = botManager.getPlayerActiveBot(playerUuid);
                if (activeBot != null) {
                    providerManager = activeBot.getProviderManager();
                    systemPrompt = activeBot.getSystemPrompt();
                    botName = activeBot.getName();
                } else {
                    providerManager = this.plugin.getProviderManager();
                    systemPrompt = this.plugin.getConfigManager().getSystemPrompt();
                }
            } else {
                providerManager = this.plugin.getProviderManager();
                systemPrompt = this.plugin.getConfigManager().getSystemPrompt();
            }
        } else {
            providerManager = this.plugin.getProviderManager();
            systemPrompt = this.plugin.getConfigManager().getSystemPrompt();
        }
        if (providerManager == null || !providerManager.hasProvider()) {
            this.sendError(sender, "AI provider not initialized! Check server logs for errors.");
            return true;
        }
        ConversationManager conversationManager = this.plugin.getConversationManager();
        if (conversationManager == null) {
            this.sendError(sender, "Conversation manager not initialized! Check server logs.");
            return true;
        }
        RateLimitManager rateLimitManager = this.plugin.getRateLimitManager();
        if (rateLimitManager != null && !(rateLimitResult = rateLimitManager.checkAllowed(player)).isAllowed()) {
            this.sendMessage(sender, rateLimitResult.getMessage());
            return true;
        }
        if (conversationManager.isOptedOut(playerUuid)) {
            this.sendError(sender, "You have opted out of using the AI chatbot.");
            this.sendMessage(sender, "\u00a77Use /nexvor privacy to manage your privacy settings.");
            return true;
        }
        String message = String.join((CharSequence)" ", args2);
        LanguageFilter languageFilter = this.plugin.getLanguageFilter();
        if (languageFilter != null && languageFilter.isEnabled() && !(filterResult = languageFilter.check(message)).isAllowed()) {
            this.sendError(sender, "Your message contains inappropriate language.");
            this.sendMessage(sender, "\u00a77Please rephrase your message without offensive words.");
            this.plugin.getNexvorLogger().info("Blocked message from " + playerName + " (language filter): " + filterResult.getMatchCount() + " words");
            return true;
        }
        if (this.plugin.hasTier(PluginTier.MAX) && (moderationManager = this.plugin.getModerationManager()) != null && this.plugin.getConfig().getBoolean("moderation.enabled", false) && (toxicityCheck = moderationManager.analyzeToxicity(message, null)).isToxic() && !toxicityCheck.isWhitelisted()) {
            ModerationAction action = moderationManager.determineAction(toxicityCheck);
            moderationManager.takeAction(player, toxicityCheck, action);
            if (action.shouldBlock()) {
                this.plugin.getNexvorLogger().info("Blocked message from " + playerName + " (moderation): " + String.valueOf((Object)toxicityCheck.getSeverity()));
                return true;
            }
        }
        this.sendMessage(sender, "\u00a77" + this.plugin.getConfigManager().getBotName() + " is thinking...");
        List<ChatMessage> conversationHistory = !botName.equals("default") ? conversationManager.getConversationContextForBot(playerUuid, playerName, botName) : conversationManager.getConversationContext(playerUuid, playerName);
        String enhancedSystemPrompt = systemPrompt;
        if (this.plugin.hasTier(PluginTier.MAX) && this.plugin.getRAGSearcher() != null && this.plugin.getRAGSearcher().isEnabled() && (ragContext = this.plugin.getRAGSearcher().searchContext(message).join()) != null && !ragContext.isEmpty()) {
            enhancedSystemPrompt = this.plugin.getRAGSearcher().injectContext(systemPrompt, ragContext);
        }
        ChatRequest.Builder requestBuilder = ChatRequest.builder().model(providerManager.getPrimaryProvider().getDefaultModel()).addSystemMessage(enhancedSystemPrompt).temperature(0.7).maxTokens(500);
        for (ChatMessage historyMessage : conversationHistory) {
            if (historyMessage.getRole().equals("user")) {
                requestBuilder.addUserMessage(historyMessage.getContent());
                continue;
            }
            if (!historyMessage.getRole().equals("assistant")) continue;
            requestBuilder.addAssistantMessage(historyMessage.getContent());
        }
        requestBuilder.addUserMessage(message);
        ChatRequest request = requestBuilder.build();
        String finalBotName = botName;
        if (!botName.equals("default")) {
            conversationManager.saveUserMessageForBot(playerUuid, playerName, botName, message);
        } else {
            conversationManager.saveUserMessage(playerUuid, playerName, message);
        }
        ((CompletableFuture)providerManager.sendRequest(request).thenAccept(response -> this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
            CommandExecutionResult commandResult;
            AICommandExecutor commandExecutor;
            if (!response.isSuccess()) {
                this.sendError(sender, "Failed to get response: " + response.getErrorMessage());
                this.plugin.getNexvorLogger().severe("Chat error for " + playerName + ": " + response.getErrorMessage());
                return;
            }
            String aiResponse = response.getContent();
            if (!finalBotName.equals("default")) {
                conversationManager.saveAssistantMessageForBot(playerUuid, playerName, finalBotName, aiResponse);
            } else {
                conversationManager.saveAssistantMessage(playerUuid, playerName, aiResponse);
            }
            if (rateLimitManager != null) {
                rateLimitManager.recordRequest(player);
            }
            if (this.plugin.hasTier(PluginTier.MAX) && (commandExecutor = this.plugin.getAICommandExecutor()) != null && (commandResult = commandExecutor.execute(player, aiResponse)).hasCommand()) {
                switch (commandResult.getType()) {
                    case SUCCESS: {
                        this.sendMessage(sender, "\u00a7a\u2713 Command executed: \u00a77" + commandResult.getCommand());
                        break;
                    }
                    case FAILED: {
                        this.sendError(sender, "Command failed: " + commandResult.getMessage());
                        break;
                    }
                    case DRY_RUN: {
                        this.sendMessage(sender, "\u00a7e[DRY RUN] \u00a77Would execute: " + commandResult.getCommand());
                        break;
                    }
                    case REJECTED: {
                        this.sendError(sender, "Command rejected: " + commandResult.getMessage());
                        break;
                    }
                    case RATE_LIMITED: {
                        this.sendError(sender, commandResult.getMessage());
                        break;
                    }
                    case NO_PERMISSION: {
                        this.sendError(sender, "You don't have permission to execute AI commands");
                    }
                }
            }
            String visibleResponse = aiResponse.replaceAll("\\[COMMAND\\]\\s*.+?(?:\\n|$)", "").trim();
            String displayName = finalBotName.equals("default") ? this.plugin.getConfigManager().getBotName() : finalBotName;
            String prefix = this.plugin.getConfigManager().getPrefix();
            if (this.plugin.getConfigManager().isPublicResponses()) {
                Bukkit.broadcastMessage((String)(prefix + " \u00a7f" + visibleResponse));
                this.plugin.getLogger().info("[" + displayName + "] " + player.getName() + " asked: " + String.join((CharSequence)" ", args2));
                this.plugin.getLogger().info("[" + displayName + "] Response: " + visibleResponse);
            } else {
                sender.sendMessage(prefix + " \u00a7f" + visibleResponse);
            }
            this.plugin.getNexvorLogger().debug("Chat response for " + playerName + " - Tokens: " + response.getTotalTokens() + " (prompt: " + response.getPromptTokens() + ", completion: " + response.getCompletionTokens() + ") - History size: " + conversationManager.getMessageCount(playerUuid));
        }))).exceptionally(throwable -> {
            this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
                this.sendError(sender, "An error occurred while contacting the AI.");
                this.plugin.getNexvorLogger().error("Chat exception for " + playerName, (Throwable)throwable);
            });
            return null;
        });
        return true;
    }

    @Override
    public String getName() {
        return "chat";
    }

    @Override
    public String getDescription() {
        return "Chat with the AI bot";
    }

    @Override
    public String getUsage() {
        return "/nexvor chat <message>";
    }

    @Override
    public String getPermission() {
        return "nexvor.chat";
    }
}

