/*
 * Decompiled with CFR 0.152.
 */
package com.nexvor.commands.subcommands;

import com.nexvor.Nexvor;
import com.nexvor.commands.BaseCommand;
import com.nexvor.core.PluginTier;
import com.nexvor.features.max.BotPersonalityManager;
import com.nexvor.features.max.models.BotPersonality;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class BotsCommand
extends BaseCommand {
    private final BotPersonalityManager botManager;

    public BotsCommand(Nexvor plugin) {
        super(plugin);
        this.botManager = plugin.getBotPersonalityManager();
    }

    @Override
    public boolean execute(CommandSender sender, String[] args2) {
        String subcommand;
        if (!this.plugin.hasTier(PluginTier.MAX)) {
            this.sendError(sender, "This feature requires a MAX tier license.");
            return true;
        }
        if (this.botManager == null || !this.botManager.isEnabled()) {
            this.sendError(sender, "Multi-bot support is not enabled on this server.");
            return true;
        }
        if (!(sender instanceof Player)) {
            this.sendError(sender, "This command can only be used by players.");
            return true;
        }
        Player player = (Player)sender;
        if (args2.length == 0) {
            this.sendHelp(sender);
            return true;
        }
        return switch (subcommand = args2[0].toLowerCase()) {
            case "list" -> this.handleList(player);
            case "switch" -> this.handleSwitch(player, args2);
            case "info" -> this.handleInfo(player, args2);
            case "current" -> this.handleCurrent(player);
            default -> {
                this.sendError(sender, "Unknown subcommand. Use /nexvor bots for help.");
                yield true;
            }
        };
    }

    private boolean handleList(Player player) {
        TextComponent header = Component.text((String)"Available Bot Personalities", (TextColor)NamedTextColor.GOLD, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD});
        player.sendMessage((Component)header);
        BotPersonality activeBotPersonality = this.botManager.getPlayerActiveBot(player.getUniqueId());
        String activeBot = activeBotPersonality.getName();
        for (BotPersonality bot : this.botManager.getAllBots()) {
            boolean isActive = bot.getName().equals(activeBot);
            Component botLine = ((TextComponent)Component.text((String)"  \u2022 ", (TextColor)NamedTextColor.GRAY).append((Component)Component.text((String)bot.getName(), (TextColor)(isActive ? NamedTextColor.GREEN : NamedTextColor.YELLOW)))).append((Component)Component.text((String)(" - " + bot.getDescription()), (TextColor)NamedTextColor.GRAY));
            if (isActive) {
                botLine = botLine.append((Component)Component.text((String)" [ACTIVE]", (TextColor)NamedTextColor.GREEN, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}));
            }
            player.sendMessage(botLine);
        }
        player.sendMessage((Component)Component.text((String)"Use /nexvor bots switch <name> to change your bot", (TextColor)NamedTextColor.GRAY));
        return true;
    }

    private boolean handleSwitch(Player player, String[] args2) {
        if (args2.length < 2) {
            this.sendError((CommandSender)player, "Usage: /nexvor bots switch <name>");
            return true;
        }
        String botName = args2[1];
        BotPersonality bot = this.botManager.getBot(botName);
        if (bot == null) {
            this.sendError((CommandSender)player, "Bot '" + botName + "' not found. Use /nexvor bots list to see available bots.");
            return true;
        }
        BotPersonality currentBot = this.botManager.getPlayerActiveBot(player.getUniqueId());
        if (currentBot.getName().equals(botName)) {
            this.sendError((CommandSender)player, "You are already using '" + botName + "'.");
            return true;
        }
        this.botManager.setPlayerActiveBot(player.getUniqueId(), botName);
        this.sendSuccess((CommandSender)player, "Switched to bot personality: " + botName);
        player.sendMessage((Component)Component.text((String)"Your conversation history has been switched to this bot.", (TextColor)NamedTextColor.GRAY));
        return true;
    }

    private boolean handleInfo(Player player, String[] args2) {
        String botName;
        if (args2.length < 2) {
            BotPersonality currentBot = this.botManager.getPlayerActiveBot(player.getUniqueId());
            botName = currentBot.getName();
        } else {
            botName = args2[1];
        }
        BotPersonality bot = this.botManager.getBot(botName);
        if (bot == null) {
            this.sendError((CommandSender)player, "Bot '" + botName + "' not found.");
            return true;
        }
        boolean isActive = this.botManager.getPlayerActiveBot(player.getUniqueId()).getName().equals(botName);
        player.sendMessage((Component)Component.text((String)("Bot Info: " + bot.getName()), (TextColor)NamedTextColor.GOLD, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}));
        player.sendMessage(Component.text((String)"  Personality: ", (TextColor)NamedTextColor.GRAY).append((Component)Component.text((String)bot.getPersonality(), (TextColor)NamedTextColor.YELLOW)));
        player.sendMessage(Component.text((String)"  Provider: ", (TextColor)NamedTextColor.GRAY).append((Component)Component.text((String)bot.getProviderManager().getPrimaryProvider().getProviderName(), (TextColor)NamedTextColor.YELLOW)));
        player.sendMessage(Component.text((String)"  Model: ", (TextColor)NamedTextColor.GRAY).append((Component)Component.text((String)bot.getProviderManager().getPrimaryProvider().getDefaultModel(), (TextColor)NamedTextColor.YELLOW)));
        player.sendMessage(Component.text((String)"  Rate Limit: ", (TextColor)NamedTextColor.GRAY).append((Component)Component.text((String)(bot.getCooldownSeconds() + "s cooldown, " + bot.getMaxPerMinute() + "/min max"), (TextColor)NamedTextColor.YELLOW)));
        if (isActive) {
            player.sendMessage(Component.text((String)"  Status: ", (TextColor)NamedTextColor.GRAY).append((Component)Component.text((String)"ACTIVE", (TextColor)NamedTextColor.GREEN, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD})));
        }
        return true;
    }

    private boolean handleCurrent(Player player) {
        BotPersonality currentBot = this.botManager.getPlayerActiveBot(player.getUniqueId());
        player.sendMessage(Component.text((String)"Your active bot: ", (TextColor)NamedTextColor.GRAY).append((Component)Component.text((String)currentBot.getName(), (TextColor)NamedTextColor.GREEN, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD})));
        player.sendMessage((Component)Component.text((String)("  " + currentBot.getDescription()), (TextColor)NamedTextColor.GRAY));
        return true;
    }

    private void sendHelp(CommandSender sender) {
        sender.sendMessage((Component)Component.text((String)"Bot Personality Commands", (TextColor)NamedTextColor.GOLD, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}));
        sender.sendMessage(Component.text((String)"  /nexvor bots list", (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)" - List all available bots", (TextColor)NamedTextColor.GRAY)));
        sender.sendMessage(Component.text((String)"  /nexvor bots switch <name>", (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)" - Switch to a different bot", (TextColor)NamedTextColor.GRAY)));
        sender.sendMessage(Component.text((String)"  /nexvor bots info [name]", (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)" - Show bot details", (TextColor)NamedTextColor.GRAY)));
        sender.sendMessage(Component.text((String)"  /nexvor bots current", (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)" - Show your active bot", (TextColor)NamedTextColor.GRAY)));
    }

    @Override
    public String getName() {
        return "bots";
    }

    @Override
    public String getDescription() {
        return "Manage bot personalities (MAX tier)";
    }

    @Override
    public String getUsage() {
        return "/nexvor bots [list|switch|info|current]";
    }

    @Override
    public String getPermission() {
        return "nexvor.bots";
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String[] args2) {
        String subcommand;
        ArrayList<String> completions = new ArrayList<String>();
        if (this.botManager == null || !this.botManager.isEnabled()) {
            return completions;
        }
        if (args2.length == 1) {
            completions.add("list");
            completions.add("switch");
            completions.add("info");
            completions.add("current");
        } else if (args2.length == 2 && ((subcommand = args2[0].toLowerCase()).equals("switch") || subcommand.equals("info"))) {
            completions.addAll(this.botManager.getBotNames());
        }
        return completions;
    }
}

