/*
 * Decompiled with CFR 0.152.
 */
package com.nexvor.commands;

import com.nexvor.Nexvor;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;

public abstract class BaseCommand {
    protected final Nexvor plugin;

    public BaseCommand(Nexvor plugin) {
        this.plugin = plugin;
    }

    public abstract boolean execute(CommandSender var1, String[] var2);

    public abstract String getName();

    public abstract String getDescription();

    public abstract String getUsage();

    public abstract String getPermission();

    public List<String> tabComplete(CommandSender sender, String[] args2) {
        return new ArrayList<String>();
    }

    public boolean hasPermission(CommandSender sender) {
        String permission = this.getPermission();
        return permission == null || sender.hasPermission(permission);
    }

    protected String getPrefix() {
        return this.plugin.getConfigManager().getPrefix();
    }

    protected void sendMessage(CommandSender sender, String message) {
        sender.sendMessage(this.getPrefix() + " \u00a7f" + message);
    }

    protected void sendError(CommandSender sender, String message) {
        sender.sendMessage(this.getPrefix() + " \u00a7c" + message);
    }

    protected void sendSuccess(CommandSender sender, String message) {
        sender.sendMessage(this.getPrefix() + " \u00a7a" + message);
    }

    protected void broadcast(String message) {
        String formatted = this.getPrefix() + " \u00a7f" + message;
        Bukkit.broadcastMessage((String)formatted);
        this.plugin.getLogger().info("[" + this.plugin.getConfigManager().getBotName() + "] " + message);
    }
}

