/*
 * Decompiled with CFR 0.152.
 */
package com.nexvor.ai;

import com.nexvor.Nexvor;
import com.nexvor.ai.AIProvider;
import com.nexvor.ai.ProviderManager;
import com.nexvor.ai.providers.CustomProvider;
import com.nexvor.ai.providers.GroqProvider;
import com.nexvor.ai.providers.OpenAIProvider;
import com.nexvor.config.ConfigManager;
import com.nexvor.core.PluginTier;
import java.util.Map;

public class ProviderFactory {
    private final Nexvor plugin;

    public ProviderFactory(Nexvor plugin) {
        this.plugin = plugin;
    }

    public ProviderManager createProviderManager() {
        ConfigManager config = this.plugin.getConfigManager();
        if (this.plugin.hasTier(PluginTier.MEDIUM)) {
            this.plugin.getNexvorLogger().info("Loading Medium tier providers (multi-provider support)");
            AIProvider primary = this.createProviderFromConfig("primary");
            AIProvider fallback = this.createProviderFromConfig("fallback");
            boolean fallbackEnabled = config.isFallbackEnabled();
            if (primary != null) {
                if (fallback != null) {
                    this.plugin.getNexvorLogger().info("Initialized with fallback: " + fallback.getProviderName());
                }
                return new ProviderManager(this.plugin, primary, fallback, fallbackEnabled);
            }
            this.plugin.getNexvorLogger().warn("Medium tier detected but no providers configured in new format");
            this.plugin.getNexvorLogger().warn("Falling back to legacy single provider config");
        }
        AIProvider provider = this.createProvider();
        return new ProviderManager(this.plugin, provider);
    }

    private AIProvider createProviderFromConfig(String section) {
        AIProvider provider;
        ConfigManager config = this.plugin.getConfigManager();
        String providerType = config.getProviderType(section);
        if (providerType == null || providerType.isEmpty()) {
            return null;
        }
        String apiKey = config.getProviderApiKey(section);
        String model = config.getProviderModel(section);
        if (apiKey == null || apiKey.isEmpty() || apiKey.equals("your-api-key-here")) {
            this.plugin.getNexvorLogger().warn(section + " provider: No API key configured");
            return null;
        }
        if (providerType.equals("custom")) {
            String name = config.getProviderName(section);
            String baseUrl = config.getProviderBaseUrl(section);
            Map<String, String> headers = config.getProviderHeaders(section);
            if (baseUrl == null || baseUrl.isEmpty()) {
                this.plugin.getNexvorLogger().warn(section + " custom provider: No base_url configured");
                return null;
            }
            provider = new CustomProvider(this.plugin, name, baseUrl, apiKey, model, headers);
        } else {
            provider = this.createProviderByType(providerType, apiKey, model);
        }
        if (provider != null && provider.isConfigured()) {
            this.plugin.getNexvorLogger().info(section + " provider: " + provider.getProviderName() + " (model: " + provider.getDefaultModel() + ")");
            return provider;
        }
        return null;
    }

    public AIProvider createProvider() {
        AIProvider provider;
        ConfigManager config = this.plugin.getConfigManager();
        String providerName = config.getApiProvider().toLowerCase();
        String apiKey = config.getApiKey();
        String model = config.getApiModel();
        if (apiKey == null || apiKey.isEmpty() || apiKey.equals("your-api-key-here")) {
            this.plugin.getNexvorLogger().severe("API key not configured! Please set api.api_key in config.yml");
            return null;
        }
        switch (providerName) {
            case "groq": {
                AIProvider aIProvider = new GroqProvider(this.plugin, apiKey, model);
                break;
            }
            case "openai": {
                AIProvider aIProvider = new OpenAIProvider(this.plugin, apiKey, model);
                break;
            }
            default: {
                this.plugin.getNexvorLogger().severe("Unknown AI provider: " + providerName);
                this.plugin.getNexvorLogger().severe("Supported providers: groq, openai");
                AIProvider aIProvider = provider = null;
            }
        }
        if (provider != null && !provider.isConfigured()) {
            this.plugin.getNexvorLogger().severe("Provider " + providerName + " is not properly configured!");
            this.plugin.getNexvorLogger().severe("Please check your API key format in config.yml");
            return null;
        }
        if (provider != null) {
            this.plugin.getNexvorLogger().info("AI Provider initialized: " + provider.getProviderName() + " (model: " + provider.getDefaultModel() + ")");
        }
        return provider;
    }

    private AIProvider createProviderByType(String providerType, String apiKey, String model) {
        return switch (providerType.toLowerCase()) {
            case "groq" -> new GroqProvider(this.plugin, apiKey, model);
            case "openai" -> new OpenAIProvider(this.plugin, apiKey, model);
            default -> {
                this.plugin.getNexvorLogger().warn("Unknown provider type: " + providerType);
                yield null;
            }
        };
    }

    public static boolean isProviderSupported(String providerName) {
        boolean bl;
        block9: {
            block8: {
                if (providerName == null) break block8;
                switch (providerName.toLowerCase()) {
                    case "groq": 
                    case "openai": 
                    case "custom": {
                        break;
                    }
                    default: {
                        break block8;
                    }
                }
                bl = true;
                break block9;
            }
            bl = false;
        }
        return bl;
    }

    public static String getSupportedProviders() {
        return "groq, openai, custom";
    }
}

