/*
 * Decompiled with CFR 0.152.
 */
package com.nexvor;

import com.nexvor.ai.AIProvider;
import com.nexvor.ai.ProviderFactory;
import com.nexvor.ai.ProviderManager;
import com.nexvor.commands.NexvorCommand;
import com.nexvor.config.ConfigManager;
import com.nexvor.core.LicenseManager;
import com.nexvor.core.NexvorLogger;
import com.nexvor.core.PluginTier;
import com.nexvor.core.ServerInfo;
import com.nexvor.dashboard.DashboardManager;
import com.nexvor.features.max.AICommandExecutor;
import com.nexvor.features.max.BotPersonalityManager;
import com.nexvor.features.max.DiscordWebhookSender;
import com.nexvor.features.max.ModerationManager;
import com.nexvor.filter.LanguageFilter;
import com.nexvor.integrations.IntegrationManager;
import com.nexvor.listeners.ChatEventListener;
import com.nexvor.listeners.EventAwarenessListener;
import com.nexvor.listeners.MentionChatListener;
import com.nexvor.memory.ConversationManager;
import com.nexvor.memory.DatabaseManager;
import com.nexvor.memory.GlobalChatManager;
import com.nexvor.memory.GroupConversationManager;
import com.nexvor.memory.ProximityChatManager;
import com.nexvor.rag.KnowledgeBaseManager;
import com.nexvor.rag.RAGSearcher;
import com.nexvor.ratelimit.RateLimitManager;
import com.nexvor.updater.UpdateChecker;
import com.nexvor.vectordb.VectorDBManager;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Nexvor
extends JavaPlugin {
    private static Nexvor instance;
    private ConfigManager configManager;
    private NexvorLogger nexvorLogger;
    private LicenseManager licenseManager;
    private ServerInfo serverInfo;
    private PluginTier activeTier;
    private ProviderManager providerManager;
    private NexvorCommand commandHandler;
    private DatabaseManager databaseManager;
    private ConversationManager conversationManager;
    private GroupConversationManager groupConversationManager;
    private GlobalChatManager globalChatManager;
    private ProximityChatManager proximityChatManager;
    private RateLimitManager rateLimitManager;
    private LanguageFilter languageFilter;
    private IntegrationManager integrationManager;
    private UpdateChecker updateChecker;
    private AICommandExecutor aiCommandExecutor;
    private ModerationManager moderationManager;
    private DiscordWebhookSender discordWebhookSender;
    private BotPersonalityManager botPersonalityManager;
    private VectorDBManager vectorDBManager;
    private KnowledgeBaseManager knowledgeBaseManager;
    private RAGSearcher ragSearcher;
    private DashboardManager dashboardManager;

    public void onEnable() {
        String mode;
        instance = this;
        this.nexvorLogger = new NexvorLogger(this);
        this.nexvorLogger.info("========================================");
        this.nexvorLogger.info("  Nexvor AI Chatbot");
        this.nexvorLogger.info("  Version: " + this.getDescription().getVersion());
        this.nexvorLogger.info("========================================");
        this.saveDefaultConfig();
        try {
            this.configManager = new ConfigManager(this);
            this.nexvorLogger.info("Configuration loaded successfully");
        }
        catch (Exception e) {
            this.nexvorLogger.severe("Failed to load configuration: " + e.getMessage());
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.serverInfo = new ServerInfo(this);
        this.serverInfo.initialize();
        this.nexvorLogger.debug("Server UUID: " + this.serverInfo.getServerUuid());
        this.licenseManager = new LicenseManager(this);
        this.activeTier = this.licenseManager.validateLicense(this.configManager.getLicenseKey(), this.configManager.getLicenseValidationUrl(), this.configManager.getLicenseActivationUrl(), this.serverInfo);
        if (this.activeTier == PluginTier.BASIC) {
            this.nexvorLogger.info("Running in FREE tier - Basic features available");
            this.nexvorLogger.info("Want more features? Visit: https://nexvor.dev/upgrade");
        } else {
            this.nexvorLogger.info("Thank you for supporting Nexvor! " + this.activeTier.getDisplayName() + " tier activated");
        }
        ProviderFactory providerFactory = new ProviderFactory(this);
        this.providerManager = providerFactory.createProviderManager();
        if (this.providerManager == null || !this.providerManager.hasProvider()) {
            this.nexvorLogger.warn("AI provider not initialized! Commands will not work.");
            this.nexvorLogger.warn("Please configure your API key in config.yml");
        } else {
            this.nexvorLogger.info("Provider setup: " + this.providerManager.getSummary());
        }
        this.databaseManager = new DatabaseManager(this);
        this.databaseManager.initialize();
        this.nexvorLogger.info("Database initialized");
        this.conversationManager = new ConversationManager(this, this.databaseManager);
        this.nexvorLogger.info("Conversation manager initialized");
        if (this.hasTier(PluginTier.MEDIUM) && this.configManager.isGroupConversationsEnabled()) {
            switch (mode = this.configManager.getGroupConversationMode()) {
                case "private": {
                    this.groupConversationManager = new GroupConversationManager(this, this.databaseManager);
                    this.nexvorLogger.info("Group conversation manager initialized (private mode)");
                    break;
                }
                case "global": {
                    this.globalChatManager = new GlobalChatManager(this, this.databaseManager);
                    this.nexvorLogger.info("Global chat manager initialized (global mode)");
                    break;
                }
                case "proximity": {
                    this.proximityChatManager = new ProximityChatManager(this, this.databaseManager);
                    this.proximityChatManager.startUpdateTask();
                    this.nexvorLogger.info("Proximity chat manager initialized (proximity mode)");
                    break;
                }
                default: {
                    this.nexvorLogger.warn("Unknown group conversation mode: " + mode + ", defaulting to private");
                    this.groupConversationManager = new GroupConversationManager(this, this.databaseManager);
                }
            }
        }
        this.rateLimitManager = new RateLimitManager(this);
        this.nexvorLogger.info("Rate limit manager initialized");
        this.languageFilter = new LanguageFilter(this);
        this.nexvorLogger.info("Language filter initialized");
        this.integrationManager = new IntegrationManager(this);
        this.integrationManager.initialize();
        if (this.configManager.isMentionTriggerEnabled()) {
            this.getServer().getPluginManager().registerEvents((Listener)new MentionChatListener(this), (Plugin)this);
            this.nexvorLogger.info("Mention chat listener registered - say '" + this.configManager.getBotName() + "' in chat to trigger AI");
        }
        if (this.hasTier(PluginTier.MEDIUM) && this.configManager.isGroupConversationsEnabled() && ((mode = this.configManager.getGroupConversationMode()).equals("global") || mode.equals("proximity"))) {
            this.getServer().getPluginManager().registerEvents((Listener)new ChatEventListener(this), (Plugin)this);
            this.nexvorLogger.info("Group chat event listener registered");
        }
        if (this.hasTier(PluginTier.MEDIUM) && this.getConfig().getBoolean("event_awareness.enabled", true)) {
            this.getServer().getPluginManager().registerEvents((Listener)new EventAwarenessListener(this), (Plugin)this);
            this.nexvorLogger.info("Event awareness listener registered");
        }
        if (this.configManager.isUpdateCheckEnabled()) {
            this.updateChecker = new UpdateChecker(this, this.configManager.getUpdateUrl());
            this.nexvorLogger.info("Update checker initialized");
            this.updateChecker.checkForUpdatesAsync();
        }
        this.commandHandler = new NexvorCommand(this);
        this.getCommand("nexvor").setExecutor((CommandExecutor)this.commandHandler);
        this.getCommand("nexvor").setTabCompleter((TabCompleter)this.commandHandler);
        this.nexvorLogger.info("Commands registered");
        this.initializeFeatures();
        this.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this, () -> {
            if (this.rateLimitManager != null) {
                this.rateLimitManager.cleanup();
            }
        }, 6000L, 6000L);
        if (this.updateChecker != null) {
            this.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this, () -> {
                if (this.updateChecker != null) {
                    this.updateChecker.performPeriodicCheck();
                }
            }, 864000L, 864000L);
        }
        this.nexvorLogger.info("Nexvor enabled successfully!");
        this.nexvorLogger.info("========================================");
    }

    public void onDisable() {
        this.nexvorLogger.info("Shutting down Nexvor...");
        if (this.dashboardManager != null) {
            this.dashboardManager.shutdown();
        }
        if (this.integrationManager != null) {
            this.integrationManager.shutdown();
        }
        if (this.updateChecker != null) {
            this.updateChecker.shutdown();
        }
        if (this.licenseManager != null) {
            this.licenseManager.shutdown();
        }
        if (this.vectorDBManager != null) {
            this.vectorDBManager.shutdown();
        }
        if (this.providerManager != null) {
            this.providerManager.shutdown();
        }
        if (this.databaseManager != null) {
            this.databaseManager.close();
        }
        this.nexvorLogger.info("Nexvor disabled successfully!");
    }

    public static Nexvor getInstance() {
        return instance;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public NexvorLogger getNexvorLogger() {
        return this.nexvorLogger;
    }

    private void initializeFeatures() {
        this.nexvorLogger.info("Loading Basic tier features...");
        if (this.licenseManager.hasTier(PluginTier.MEDIUM)) {
            this.nexvorLogger.info("Loading Medium tier features...");
        }
        if (this.licenseManager.hasTier(PluginTier.MAX)) {
            this.nexvorLogger.info("Loading MAX tier features...");
            if (this.getConfig().getBoolean("webhooks.discord.enabled", false)) {
                this.discordWebhookSender = new DiscordWebhookSender(this);
                this.nexvorLogger.info("Discord webhooks initialized");
            }
            if (this.getConfig().getBoolean("commands.allow_ai_commands", false)) {
                this.aiCommandExecutor = new AICommandExecutor(this);
                this.nexvorLogger.info("AI command executor initialized (dry-run: " + this.getConfig().getBoolean("commands.dry_run", true) + ")");
            } else {
                this.nexvorLogger.info("AI command execution disabled (enable in config.yml)");
            }
            if (this.getConfig().getBoolean("moderation.enabled", false)) {
                this.moderationManager = new ModerationManager(this);
                this.nexvorLogger.info("Advanced moderation initialized (" + this.getConfig().getString("moderation.method", "hybrid") + " mode)");
            } else {
                this.nexvorLogger.info("Advanced moderation disabled (enable in config.yml)");
            }
            if (this.getConfig().getBoolean("bots.enabled", false)) {
                this.botPersonalityManager = new BotPersonalityManager(this);
                this.botPersonalityManager.initialize();
            } else {
                this.nexvorLogger.info("Multi-bot support disabled (enable in config.yml)");
            }
            if (this.getConfig().getBoolean("vector_db.enabled", false)) {
                this.vectorDBManager = new VectorDBManager(this);
                this.vectorDBManager.initialize().thenAccept(success -> {
                    if (success.booleanValue()) {
                        this.nexvorLogger.info("Vector database initialized (" + this.vectorDBManager.getMode() + " mode)");
                    } else {
                        this.nexvorLogger.warn("Vector database initialization failed!");
                    }
                });
            } else {
                this.nexvorLogger.info("Vector database disabled (enable in config.yml)");
            }
            if (this.getConfig().getBoolean("rag.enabled", false)) {
                if (this.vectorDBManager != null) {
                    this.knowledgeBaseManager = new KnowledgeBaseManager(this);
                    this.ragSearcher = new RAGSearcher(this);
                    this.nexvorLogger.info("RAG system initialized (knowledge bases enabled)");
                    this.extractRAGTemplates();
                } else {
                    this.nexvorLogger.warn("RAG requires vector_db to be enabled! Skipping RAG initialization.");
                }
            } else {
                this.nexvorLogger.info("RAG system disabled (enable in config.yml)");
            }
            if (this.getConfig().getBoolean("dashboard.enabled", false)) {
                this.dashboardManager = new DashboardManager(this);
                this.dashboardManager.initialize();
            } else {
                this.nexvorLogger.info("Web dashboard disabled (enable in config.yml)");
            }
            this.nexvorLogger.info("MAX tier features loaded successfully!");
        }
    }

    public LicenseManager getLicenseManager() {
        return this.licenseManager;
    }

    public PluginTier getActiveTier() {
        return this.activeTier;
    }

    public boolean hasTier(PluginTier tier) {
        return this.licenseManager.hasTier(tier);
    }

    public AIProvider getAIProvider() {
        return this.providerManager != null ? this.providerManager.getPrimaryProvider() : null;
    }

    public ProviderManager getProviderManager() {
        return this.providerManager;
    }

    public DatabaseManager getDatabaseManager() {
        return this.databaseManager;
    }

    public ConversationManager getConversationManager() {
        return this.conversationManager;
    }

    public GroupConversationManager getGroupConversationManager() {
        return this.groupConversationManager;
    }

    public GlobalChatManager getGlobalChatManager() {
        return this.globalChatManager;
    }

    public ProximityChatManager getProximityChatManager() {
        return this.proximityChatManager;
    }

    public RateLimitManager getRateLimitManager() {
        return this.rateLimitManager;
    }

    public LanguageFilter getLanguageFilter() {
        return this.languageFilter;
    }

    public UpdateChecker getUpdateChecker() {
        return this.updateChecker;
    }

    public AICommandExecutor getAICommandExecutor() {
        return this.aiCommandExecutor;
    }

    public ModerationManager getModerationManager() {
        return this.moderationManager;
    }

    public DiscordWebhookSender getDiscordWebhookSender() {
        return this.discordWebhookSender;
    }

    public BotPersonalityManager getBotPersonalityManager() {
        return this.botPersonalityManager;
    }

    public VectorDBManager getVectorDBManager() {
        return this.vectorDBManager;
    }

    public KnowledgeBaseManager getKnowledgeBaseManager() {
        return this.knowledgeBaseManager;
    }

    public RAGSearcher getRAGSearcher() {
        return this.ragSearcher;
    }

    public DashboardManager getDashboardManager() {
        return this.dashboardManager;
    }

    public void reload() {
        this.reloadConfig();
        this.configManager = new ConfigManager(this);
        this.activeTier = this.licenseManager.revalidate(this.configManager.getLicenseValidationUrl(), this.configManager.getLicenseActivationUrl(), this.serverInfo);
        ProviderFactory providerFactory = new ProviderFactory(this);
        if (this.providerManager != null) {
            this.providerManager.shutdown();
        }
        this.providerManager = providerFactory.createProviderManager();
        if (this.hasTier(PluginTier.MAX)) {
            if (this.moderationManager != null) {
                this.moderationManager.reload();
            }
            if (this.discordWebhookSender != null) {
                this.discordWebhookSender.reload();
            }
        }
        this.nexvorLogger.info("Configuration reloaded successfully");
        this.nexvorLogger.info("Active tier: " + this.activeTier.getDisplayName());
        if (this.providerManager != null) {
            this.nexvorLogger.info("Provider setup: " + this.providerManager.getSummary());
        }
    }

    private void extractRAGTemplates() {
        try {
            Path templatesDir = this.getDataFolder().toPath().resolve("rag_templates");
            Path extractedMarker = templatesDir.resolve(".extracted");
            if (Files.exists(extractedMarker, new LinkOption[0])) {
                this.nexvorLogger.debug("RAG templates already extracted, skipping");
                return;
            }
            if (!Files.exists(templatesDir, new LinkOption[0])) {
                Files.createDirectories(templatesDir, new FileAttribute[0]);
            }
            String[] templates = new String[]{"server_rules.md", "faq.md", "commands_guide.md", "README.txt"};
            int extracted = 0;
            for (String template : templates) {
                String resourcePath = "rag_templates/" + template;
                Path targetPath = templatesDir.resolve(template);
                if (Files.exists(targetPath, new LinkOption[0])) continue;
                try (InputStream in = this.getResource(resourcePath);){
                    if (in != null) {
                        Files.copy(in, targetPath, new CopyOption[0]);
                        ++extracted;
                        continue;
                    }
                    this.nexvorLogger.warn("Template resource not found: " + resourcePath);
                }
            }
            Files.createFile(extractedMarker, new FileAttribute[0]);
            if (extracted > 0) {
                this.nexvorLogger.info("[MAX] Extracted " + extracted + " RAG template files to: " + String.valueOf(templatesDir));
                this.nexvorLogger.info("[MAX] Customize these templates and upload with /nexvor kb upload");
            }
        }
        catch (Exception e) {
            this.nexvorLogger.warn("Failed to extract RAG templates: " + e.getMessage());
        }
    }
}

