/*
 * Decompiled with CFR 0.152.
 */
package com.nexvor.utils;

public class TokenEstimator {
    public static int estimateTokens(String text) {
        if (text == null || text.isEmpty()) {
            return 0;
        }
        int baseEstimate = (int)Math.ceil((double)text.length() / 4.0);
        int wordCount = TokenEstimator.countWords(text);
        double avgWordLength = (double)text.length() / (double)Math.max(1, wordCount);
        if (avgWordLength < 3.5) {
            return Math.max(baseEstimate, wordCount);
        }
        if (avgWordLength > 6.0) {
            baseEstimate = (int)((double)baseEstimate * 1.1);
        }
        return baseEstimate;
    }

    public static int estimateTokens(String ... messages) {
        int total = 0;
        for (String message : messages) {
            total += TokenEstimator.estimateTokens(message);
        }
        return total;
    }

    private static int countWords(String text) {
        if (text == null || text.isEmpty()) {
            return 0;
        }
        String trimmed = text.trim();
        if (trimmed.isEmpty()) {
            return 0;
        }
        return trimmed.split("\\s+").length;
    }

    public static String formatTokenCount(int tokens) {
        if (tokens < 1000) {
            return tokens + " tokens";
        }
        if (tokens < 10000) {
            return String.format("%.1fK tokens", (double)tokens / 1000.0);
        }
        return String.format("%dK tokens", tokens / 1000);
    }

    public static boolean fitsWithinLimit(String text, int limit) {
        return TokenEstimator.estimateTokens(text) <= limit;
    }

    public static String truncateToTokenLimit(String text, int maxTokens) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        int currentTokens = TokenEstimator.estimateTokens(text);
        if (currentTokens <= maxTokens) {
            return text;
        }
        int targetTokens = (int)((double)maxTokens * 0.9);
        int targetChars = targetTokens * 4;
        if (targetChars >= text.length()) {
            return text;
        }
        String truncated = text.substring(0, targetChars);
        int lastSpace = truncated.lastIndexOf(32);
        if (lastSpace > targetChars / 2) {
            truncated = truncated.substring(0, lastSpace);
        }
        return truncated + "...";
    }

    public static double estimateCostGPT35(int inputTokens, int outputTokens) {
        double inputCost = (double)inputTokens / 1000.0 * 0.0015;
        double outputCost = (double)outputTokens / 1000.0 * 0.002;
        return inputCost + outputCost;
    }

    public static double estimateCostGroq(int inputTokens, int outputTokens) {
        return 0.0;
    }

    public static String debugTokenEstimate(String text) {
        if (text == null || text.isEmpty()) {
            return "Empty text: 0 tokens";
        }
        int chars = text.length();
        int words = TokenEstimator.countWords(text);
        int tokens = TokenEstimator.estimateTokens(text);
        double avgWordLen = (double)chars / (double)Math.max(1, words);
        double charsPerToken = (double)chars / (double)Math.max(1, tokens);
        return String.format("Text: %d chars, %d words, ~%d tokens\nAvg word length: %.1f chars\nChars per token: %.2f", chars, words, tokens, avgWordLen, charsPerToken);
    }
}

