/*
 * Decompiled with CFR 0.152.
 */
package com.nexvor.memory;

import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;

public class ProximityGroup {
    private final String groupId;
    private final Set<UUID> members;
    private final long createdAt;
    private long lastActivity;

    public ProximityGroup(String groupId) {
        this.groupId = groupId;
        this.members = new HashSet<UUID>();
        this.lastActivity = this.createdAt = System.currentTimeMillis();
    }

    public boolean addMember(UUID playerUuid) {
        boolean added = this.members.add(playerUuid);
        if (added) {
            this.lastActivity = System.currentTimeMillis();
        }
        return added;
    }

    public boolean removeMember(UUID playerUuid) {
        boolean removed = this.members.remove(playerUuid);
        if (removed) {
            this.lastActivity = System.currentTimeMillis();
        }
        return removed;
    }

    public boolean isMember(UUID playerUuid) {
        return this.members.contains(playerUuid);
    }

    public Set<UUID> getMembers() {
        return Collections.unmodifiableSet(this.members);
    }

    public int getMemberCount() {
        return this.members.size();
    }

    public boolean isEmpty() {
        return this.members.isEmpty();
    }

    public void updateActivity() {
        this.lastActivity = System.currentTimeMillis();
    }

    public String getGroupId() {
        return this.groupId;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public long getLastActivity() {
        return this.lastActivity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProximityGroup that = (ProximityGroup)o;
        return Objects.equals(this.groupId, that.groupId);
    }

    public int hashCode() {
        return Objects.hash(this.groupId);
    }

    public String toString() {
        return "ProximityGroup{groupId='" + this.groupId + "', members=" + this.members.size() + "}";
    }
}

